<?PHP
/* vim: set expandtab tabstop=4 shiftwidth=4: */
// +----------------------------------------------------------------------------+
// | <G a n e s h a> - Free Web Based Training System                           |
// +----------------------------------------------------------------------------+
// | <G a n e s h a> - Plate-forme de tlformation gratuite et en open source  |
// +----------------------------------------------------------------------------|
// | Copyright (C) 2001-2003  Anma Formation  <http://www.anema.fr/>           |
// +----------------------------------------------------------------------------+
// |           Developer : Georges CALDEIRA <gcaldeira@anemalab.org>            |
// +----------------------------------------------------------------------------+
// |              Infos on project <http://anemalab.org/>                       |
// +----------------------------------------------------------------------------+
// | This program is free software; you can redistribute it and/or modify       |
// | it under the terms of the GNU General Public License as published by       |
// | the Free Software Foundation; either version 2 of the License, or          |
// | (at your option) any later version.                                        |
// |                                                                            |
// | This program is distributed in the hope that it will be useful,            |
// | but WITHOUT ANY WARRANTY; without even the implied warranty of             |
// | MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the              |
// | GNU General Public License for more details.                               |
// |                                                                            |
// | You should have received a copy of the GNU General Public License          |
// | along with this program; if not, write to the Free Software                |
// | Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA   |
// +----------------------------------------------------------------------------+

/**
* Definition de la class pour la gestion de la norme SCORM
* @author	Georges Caldeira <gcaldeira@anemalab.org>
* @package	GaneshaNorme
*/
/**
* Fournit une API pour la gestion de la norme SCORM
* @author	Georges Caldeira <gcaldeira@anemalab.org>
* @access	public
* @package	GaneshaNorme
*/	
class scorm {
	
	/**
	* Retourne la valeur du status
	* @param	string	$status valeur du status
	* @param	boolean	$texte format de retour
	* @access	public
	*/
	function GetStatus($status,$texte=false) {
		global $PASSED,$COMPLETED,$FAILED,$INCOMPLETE,$BROWSED,$NOT_ATTEMPTED,$NORME_STATUS;
		if ( $status == '' ) {
			return(NOT_ATTEMPTED);
		}
		$ret = NOT_ATTEMPTED ;
		$mystatus = strtoupper($status);
		if ( in_array($mystatus,$PASSED) ) {
			$ret = PASSED ;
		}
		if ( in_array($mystatus,$COMPLETED) ) {
			$ret = COMPLETED ;
		}
		if ( in_array($mystatus,$FAILED) ) {
			$ret = FAILED ;
		}
		if ( in_array($mystatus,$INCOMPLETE) ) {
			$ret = INCOMPLETE ;
		}
		if ( in_array($mystatus,$BROWSED) ) {
			$ret = BROWSED ;
		}
		if ( in_array($mystatus,$NOT_ATTEMPTED) ) {
			$ret = NOT_ATTEMPTED ;
		}
		if ( $texte ) {
			return($NORME_STATUS[$ret]);
		} else {
			return($ret);
		}
	}
	
}	

/**
* Fournit une API pour la gestion du message AICC CORE
* @author	Georges Caldeira <gcaldeira@anemalab.org>
* @access	public
* @package	GaneshaNorme
*/
class aiccCore {

	/**
	* Traitement du message core_aicc
	* @param	string	$student_id valeur de la session
	* @param	string	$version version AICC du module
	* @access	public
	*/	
	function GetCore($student_id,$version) {
		$name = 'eric' ;
		$ret = 'error=0'.CRLF.'error_text=Successful'.CRLF.'version='.$version.CRLF ;
		$ret.= 'aicc_data=[core]'.CRLF.'student_id='.$student_id.CRLF.'student_name='.$name.CRLF ;
		$ret.= 'output_file='.CRLF.'credit='.CRLF.'lesson_status='.CRLF.'path='.CRLF ;
		$ret.= 'score=0'.CRLF.'time=00:00:00'.CRLF ;
//		$ret.= '[core_vendor]'.CRLF.'auto_exit=0'.CRLF.'debug=0'.CRLF.'f_fwd=0'.CRLF.'[core_lesson]'.CRLF;
//		$ret.= '[core_lesson]'.CRLF;
		debug_msg($ret) ;
		return($ret);
	}
	
}

/**
* Fournit une API pour la gestion du message AICC DATA 
* @author	Georges Caldeira <gcaldeira@anemalab.org>
* @access	public
* @package	GaneshaNorme
*/
class aiccData {

	var $m_lms_data ;
	var $m_aicc_data ;
	var $m_cnt  ;

	/**
	* formate le message error.
	* @param	string	$val valeur de error
	* @access	public
	*/	
	function reponse($val) {
		$ret = 'error='.$val.CRLF ;
		debug_msg($ret) ;
		return($ret);
	}

	/**
	* Verification de la session GANESHA
	* @param	string	$session_id valeur de la session
	* @access	public
	*/	
	function VerifSession($session_id) {
		global $ClsGroupe, $ClsSession, $ClsModule, $guserid ;
		$sid = explode('-',$session_id);
		$val = '[Ganesha]'.CRLF ;
		$val.= 'Connexion='.$sid[0].CRLF;
		$val.= 'Groupe='.$sid[1].CRLF 	;
		$val.= 'Module='.$sid[2].CRLF 	;
		$val.= 'Chapitre='.$sid[3].CRLF ;
		debug_msg($val);
		if ( Init($sid[0]) ) {
			$val = '[Resultat Ganesha]'.CRLF ;
			if ( ! $ClsGroupe->verifMembreGroupe($guserid,$sid[1]) ) {
				$val.= 'Groupe=KO'.CRLF 	;
				debug_msg($val);
				$this->reponse(INVALID_SESSION_ID);
				$this->UrlErreur();
			}
			if ( ! $ClsSession->verifModuleGroupe($sid[2],$sid[1]) ) {
				$val.= 'Module=KO'.CRLF 	;
				debug_msg($val);
				$this->reponse(INVALID_SESSION_ID);
				$this->UrlErreur();
			}
			if ( ! $ClsModule->verifChapitre($sid[2],$sid[3]) ) {
				$val.= 'Chapitre=KO'.CRLF 	;
				debug_msg($val);
				$this->reponse(INVALID_SESSION_ID);
				$this->UrlErreur();
			}		
			$val.= 'Connexion=OK'.CRLF;
			$val.= 'Groupe=OK'.CRLF 	;
			$val.= 'Module=OK'.CRLF 	;
			$val.= 'Chapitre=OK'.CRLF ;			
			debug_msg($val);

			$this->m_lms_data['connexion'] 	= $sid[0] ;
			$this->m_lms_data['groupe'] 	= $sid[1] ;
			$this->m_lms_data['module'] 	= $sid[2] ;
			$this->m_lms_data['chapitre']  	= $sid[3] ;
			$this->m_lms_data['user']  		= $guserid ;
			return(true);
		} else {
			$val = '[Resultat Ganesha]'.CRLF ;
			$val.= 'Connexion=ERREUR!!!'.CRLF;
			debug_msg($val);
			$this->reponse(INVALID_SESSION_ID);
			$this->UrlErreur();
		}
	}

	/**
	* recherche une la valeur d'une cle
	* @param	string	$key	valeur de la cle recherchee
	* @param	string	$item	valeur de comparaison
	* @access	public
	*/	
	function ChercherItem($key,$item) {
		$ret = explode("=",$item);
		if ( count($ret) == 0 ) {
			return(false);
		}
		if ( strtoupper($key) == strtoupper($ret[0]) ) {
			return($ret[1]);
		} else {
			return('');
		}
	}

	/**
	* Retourne la valeur d'un  cle
	* @param	string	$key valeur de la cle
	* @access	public
	*/	
	function GetVal($key) {
		for($i=0;$i<$this->m_cnt;$i++){
			$item = $this->m_aicc_data[$i] ;
			$item = str_replace("\n",'',$item);
			$item = str_replace("\r",'',$item);
			$val = $this->ChercherItem(trim($key),trim($item)) ;
			if ( $val != '' ) return($val);
		}
		return('');
	}

	/**
	* Retourne la valeur du status
	* @param	string	$status valeur du status
	* @param	boolean	$texte format de retour
	* @access	public
	*/
	function GetStatus($status,$texte=false) {
		global $PASSED,$COMPLETED,$FAILED,$INCOMPLETE,$BROWSED,$NOT_ATTEMPTED,$NORME_STATUS;
		if ( $status == '' ) {
			return($this->reponse(INVALID_COMMAND));
		}
		$ret = NOT_FOUND ;
		$mystatus = strtoupper($status);
		if ( in_array($mystatus,$PASSED) ) {
			$ret = PASSED ;
		}
		if ( in_array($mystatus,$COMPLETED) ) {
			$ret = COMPLETED ;
		}
		if ( in_array($mystatus,$FAILED) ) {
			$ret = FAILED ;
		}
		if ( in_array($mystatus,$INCOMPLETE) ) {
			$ret = INCOMPLETE ;
		}
		if ( in_array($mystatus,$BROWSED) ) {
			$ret = BROWSED ;
		}
		if ( in_array($mystatus,$NOT_ATTEMPTED) ) {
			$ret = NOT_ATTEMPTED ;
		}
		if ( $texte ) {
			return($NORME_STATUS[$ret]);
		} else {
			return($ret);
		}
	}

	/**
	* Traitement du message DATA
	* @param	string	$data valeur du message DATA
	* @param	string	$session_id valeur de la session GANESHA
	* @access	public
	*/		
	function ExtractParam($data,$session_id) {
		global $ClsTracking ;
		debug_msg('1') ;
		$this->VerifSession($session_id);
		$this->m_aicc_data = explode("\n",$data);
		debug_msg($data) ;

		$this->m_cnt = count($this->m_aicc_data);
		if ( $this->m_cnt == 0 ) {
			return($this->reponse(INVALID_COMMAND));
		}
		$date = getdate() ;
		$this->m_lms_data['date']	= $date["0"] ;
		$this->m_lms_data['time']	= $this->GetVal("time");
		$score = $this->GetVal("score") ;
		$tscore = explode(",",$score);
		if ( count($tscore) > 0 ) {
			$this->m_lms_data['score']	= trim($tscore[0]) ;
			$this->m_lms_data['max_score']	= trim($tscore[1]) ;
		} else {
			$this->m_lms_data['score']	= $score ;
		}
		$this->m_lms_data['status']	= $this->GetStatus($this->GetVal("lesson_status"));
		$this->m_lms_data['session_id'] = $session_id ;
		while(list ($key, $val) = each ($this->m_lms_data)) {
			$str.= "[$key => $val]".CRLF;
		}
		debug_res($str) ;

		$ClsTracking->addg($this->m_lms_data);
		return($this->reponse(SUCCESSFUL));
	}

	/**
	* Affiche d'une page erreur.
	* @access	public
	*/		
	function UrlErreur() {
		print('
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Frameset//EN" "http://www.w3.org/TR/html4/frameset.dtd">
<html>
<head>
<title></title>
<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1">
</head>
<script type="text/javascript" language="javascript" >
<!-- 
	window.top.location.href = "'.HTTP_COMMUN.'p_error.php"  ;
// -->
</script>
</body>
</html>');
die();	
	}

	/**
	* traitement du message ExitAU
	* @access	public
	*/		
	function ExitAU() {
		print('
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Frameset//EN" "http://www.w3.org/TR/html4/frameset.dtd">
<html>
<head>
<title></title>
<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1">
</head>
<script type="text/javascript" language="javascript" >
<!-- 
	parent.top.location.reload()  ;
// -->
</script>
</body>
</html>');
die();	
	}
}

/**
* Instance de la classe aiccData
* @var	object	$aiccData
*/
$aiccData 	= new aiccData ;

/**
* Instance de la classe aiccCore
* @var	object	$aiccCore
*/
$aiccCore 	= new aiccCore ;

/**
* Instance de la classe scorm
* @var	object	$scorm
*/
$scorm 		= new scorm    ;

?>