<?PHP
/* vim: set expandtab tabstop=4 shiftwidth=4: */
// +----------------------------------------------------------------------------+
// | <G a n e s h a> - Free Web Based Training System                           |
// +----------------------------------------------------------------------------+
// | <G a n e s h a> - Plate-forme de tlformation gratuite et en open source  |
// +----------------------------------------------------------------------------|
// | Copyright (C) 2001-2003  Anma Formation  <http://www.anema.fr/>           |
// +----------------------------------------------------------------------------+
// |           Developer : Georges CALDEIRA <gcaldeira@anemalab.org>            |
// +----------------------------------------------------------------------------+
// |              Infos on project <http://anemalab.org/>                       |
// +----------------------------------------------------------------------------+
// | This program is free software; you can redistribute it and/or modify       |
// | it under the terms of the GNU General Public License as published by       |
// | the Free Software Foundation; either version 2 of the License, or          |
// | (at your option) any later version.                                        |
// |                                                                            |
// | This program is distributed in the hope that it will be useful,            |
// | but WITHOUT ANY WARRANTY; without even the implied warranty of             |
// | MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the              |
// | GNU General Public License for more details.                               |
// |                                                                            |
// | You should have received a copy of the GNU General Public License          |
// | along with this program; if not, write to the Free Software                |
// | Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA   |
// +----------------------------------------------------------------------------+

/**
* Definition de la class pour la gestion des Modules
* @author	Georges Caldeira <gcaldeira@anemalab.org>
* @package	GaneshaClass
*/
/**
* Fournit une API pour acceder aux modules
* @author	Georges Caldeira <gcaldeira@anemalab.org>
* @access	public
* @package	GaneshaClass
*/
class Module {

	/**
	* Retourne le titre du module $idm
	* @param	integer	$idm ID du module
	* @return	string	Retourne le titre du module 
	* @access	public
	*/
	function Title($idm) {
	 global $TBL, $db ;
		$title = '';
		$sSQL ="SELECT module_titre FROM ".$TBL['list_module']." where module_id=".$idm ;
		$db->query($sSQL);
		if ( $db->num_rows() !=  0) {
			$db->next_record()	;
			$title = $db->f(0)	;
			$db->free()			;
		}
		return($title);
	}

	/**
	* Retourne le titre du module $idm
	* @param	integer	$idm ID du module
	* @return	string	Retourne le titre du module 
	* @access	public
	*/
	function Support($idm) {
	 global $TBL, $db ;
		$title = '';
		$sSQL ="SELECT link FROM ".$TBL['module']." WHERE id_module=".$idm." AND numero=0";
		$db->query($sSQL);
		$ret = '' ;
		if ( $db->num_rows() ==  1) {
			$db->next_record()	;
			$ret = $db->f(0)	;
		}
 		return($ret);
	}

	/**
	* Positionne le titre et l'auteur du module $idm
	* @param	integer	$idm ID du module
	* @return	array	Retourne un tableau avec le titre du module et son auteur
	* @access	public
	*/
	function Info($idm) {
	 global $TBL, $db ;
		$sSQL  = "SELECT module_id,module_titre,auteur_id,code ";
		$sSQL .= "FROM ".$TBL['list_module']." where module_id=".$idm  ;
		$db->query($sSQL)	;
		$db->next_record()	;
		$ret['titre'] 	= $db->f('module_titre');
		$ret['auteur']	= $db->f('auteur_id')	;
		$ret['code']	= $db->f('code')		;
		$db->free()	;
		return($ret);
	}

	/**
	* Retourne le repertoire du module $idm
	* @param	integer	$idm ID du module
	* @return	string	Retourne le repertoire d'un module
	* @access	public
	*/
	function Directory($idm) {
	 global $TBL, $db ;
		$sSQL  = "SELECT repertoire " ;
		$sSQL .= "FROM ".$TBL['list_module']." where module_id=".$idm ;
		$db->query($sSQL)			;
		$db->next_record()			;
		$dir = $db->f("repertoire")	;
		$db->free()					;
		return($dir)				;
	}

	/**
	* Retourne la liste de tous les id des modules associes a un groupe
	* @param	integer	$idg	Id du groupe
	* @access	public
	*/
	function ListModules($idg) {
	 global $TBL, $db ;
		$tModule = Array() ;
		$sSQL = "SELECT DISTINCT lm.module_id ";
		$sSQL.= "FROM ".$TBL['list_module']." lm, ".$TBL['formation']." f, ".$TBL['membres']." m " ;
		$sSQL.= "where m.id_groupe=".$idg." and f.user_id=m.id ";
		$sSQL.= "and lm.module_id=f.module_id "	;
		$sSQL.= "order by f.ordre "	;
		$db->query($sSQL)			;
		$i    = 0					;
		while( $db->next_record() ) {
			$tModule[$i++] = $db->f(0);
		}
		return($tModule);
	}

	/**
	* Retourne la liste de tous les modules 
	* @access	public
	*/
	function read() {
	 global $TBL, $db, $ClsMembre ;
		$tModule = Array() ;
		$sSQL = "SELECT module_id,module_titre,repertoire,auteur_id,code ";
		$sSQL.= "FROM ".$TBL['list_module']." ORDER BY module_id DESC "		;
		$db->query($sSQL)	;
		$ret['cnt'] = $db->num_rows();
		$i = 0 ;
		while( $db->next_record() ) {
			$ret[$i]['id'] 		= $db->f('module_id');
			$ret[$i]['titre'] 	= $db->f('module_titre');
			$ret[$i]['repertoire'] = $db->f('repertoire');
			$ret[$i]['nom'] 	= $ClsMembre->GetAuteurName($db->f('auteur_id')); 
			$ret[$i]['code'] 	= $db->f('code');
			$i++ ;
		}
		return($ret);
	}
	

	/**
	* Retourne la config d'un module
	* @param	integer	$idm	Id du module	
	* @access	public
	*/
	function readModule($idm) {
	 global $TBL, $db ;
		$tModule = Array() ;
		$sSQL = "SELECT titre,numero,link,norme,type FROM ".$TBL['module']."  WHERE id_module=".$idm." ORDER BY numero ASC";
		$db->query($sSQL)	;
		$ret['cnt'] = $db->num_rows();
		$i = 0 ;
		while( $db->next_record() ) {
			$ret[$i]['titre'] 	= $db->f('titre')	;
			$ret[$i]['numero'] 	= $db->f('numero')	;
			$ret[$i]['link'] 	= $db->f('link')	;			
			$ret[$i]['norme'] 	= $db->f('norme')	;	
			$ret[$i]['type'] 	= $db->f('type')	;	
			$i++ ;
		}
		return($ret);
	}

			
	/**
	* Retourne la liste de tous les id des modules associes a un groupe
	* @param	integer	$idg	Id du groupe
	* @access	public
	*/
	function norme($val) {
		switch($val) {
		case 0 : return('GANESHA')	;
		case 1 : return('AICC')		;
		case 2 : return('SCORM')	;
		default  : return('Ganesha');
		}
	}

	/**
	* Retourne la liste de tous les id des modules associes a un groupe
	* @param	integer	$idg	Id du groupe
	* @access	public
	*/
	function type($val) {
		global $ad_texte ;
		switch($val) {
		case DOCUMENT : return($ad_texte['typedoc']);
		case QUIZZ : return($ad_texte['typequizz'])	;
		case TITRE : return($ad_texte['typetitre'])	;
		default  : return('&nbsp;');
		}
	}
		
	/**
	* Ajoute un nouveau module
	* @param	string	$titre	titre du module
	* @param	string	$code	code du module	
	* @param	integer	$aut	id de l'auteur
	* @param	string	$support	support du module
	* @access	public
	*/
	function add($titre,$code,$aut,$support) {
		global $TBL, $db, $ad_texte ;

		$sSQL = "INSERT INTO ".$TBL['list_module']." SET module_titre='".$titre."',";
		$sSQL.= "code='".$code."',auteur_id=".$aut;
		$db->query($sSQL)   ;

		$sSQL = "SELECT module_id FROM ".$TBL['list_module']." WHERE module_titre='".$titre."' ";
		$sSQL.= "AND auteur_id=".$aut;
		$db->query($sSQL)   ;
		$db->next_record();
		$idm = $db->f(0) ;

		if ( trim($code) == '' ) {
			$code = MOD_CODE.($idm < 10 ? '0'.$idm : $idm) ;
			$sSQL = "UPDATE ".$TBL['list_module']." SET code='".$code."' ";
			$sSQL.= "WHERE module_id=".$idm;
			$db->query($sSQL)   ;			
		}

		$sSQL="DELETE FROM ".$TBL['module']." WHERE id_module=".$idm ;
		$db->query($sSQL)   ;	

		/*
		$sSQL = "CREATE TABLE ".$TBL['module']."_".$idm."(titre varchar(80) NOT NULL,";
		$sSQL.= "numero int(11) NOT NULL,link varchar(80) NOT NULL," ;
		$sSQL.= "norme int(11) NOT NULL,type int(11) NOT NULL);" ;
		$db->query($sSQL)   ;
		*/

		$sSQL = "INSERT INTO ".$TBL['module']." (id_module,titre,numero,link,norme,type) ";
		$sSQL.= "VALUES (".$idm.",'".$ad_texte['support']."','0','".$support."',0,".TITRE.")";
		$db->query($sSQL)   ;

		return($idm);
	}

	/**
	* maj d'un module
	* @param	integer	$idm	id du module	
	* @param	string	$titre	titre du module
	* @param	string	$code	code du module
	* @param	integer	$aut	id de l'auteur
	* @param	string	$support	support du module
	* @access	public
	*/
	function update($idm,$titre,$code,$aut,$support) {
		global $TBL, $db ;
		if ( trim($code) == '' ) {
			$code = MOD_CODE.($idm < 10 ? '0'.$idm : $idm) ;
		}
		$sSQL = "UPDATE ".$TBL['list_module']." SET module_titre='".$titre."',";
		$sSQL.= "code='".$code."',auteur_id=".$aut." WHERE module_id=".$idm ;
		$db->query($sSQL)   ;

		$sSQL = "UPDATE ".$TBL['module']." SET link='".$support."', type=2 WHERE numero=0 AND id_module=".$idm;
		$db->query($sSQL)   ;
	}

	/**
	* Ajoute un nouveau chapitre a un module
	* @param	integer	$idm	id du module
	* @param	integer	$norme	norme du chapitre
	* @param	integer	$type	type du chapitre
	* @param	string	$chap	nom du chapitre
	* @param	string	$fic	fichier du chapitre
	* @access	public
	*/
	function addChapitre($idm,$norme,$type,$chap,$fic) {
		global $TBL, $db ;

		$sSQL = "SELECT MAX(numero) FROM ".$TBL['module']." WHERE id_module=".$idm ;
		$db->query($sSQL);
		$db->next_record();
		$numero = (is_numeric($db->f(0)) ? $db->f(0)+1 : 1 );

		if ( $type == TITRE ) {
			$sSQL = "DELETE FROM ".$TBL['module']." WHERE id_module=".$idm." AND numero=".$numero;
			$db->query($sSQL);
			$sSQL = "INSERT INTO ".$TBL['module']." (id_module,titre,numero,link,norme,type) ";
			$sSQL.= "VALUES (".$idm.",'".$chap."',".$numero.",'','".GANESHA."','".TITRE."')";
			$db->query($sSQL);
		} else {		
			if ( strlen(trim($chap))!=0 && strlen(trim($fic))!=0 ) {
				$sSQL = "DELETE FROM ".$TBL['module']." WHERE id_module=".$idm." AND numero=".$numero;
				$db->query($sSQL);
				$sSQL = "INSERT INTO ".$TBL['module']." (id_module,titre,numero,link,norme,type) ";
				$sSQL.= "VALUES (".$idm.",'".$chap."',".$numero.",'".$fic."','".$norme."','".$type."')";
				$db->query($sSQL);
			}
		}
	}

	/**
	* met a jour un chapitre
	* @param	integer	$idm	id du module
	* @param	integer	$numero	numero du chapitre
	* @param	integer	$norme	norme du chapitre
	* @param	integer	$type	type du chapitre
	* @param	string	$chap	nom du chapitre
	* @param	string	$fic	fichier du chapitre
	* @access	public
	*/
	function updateChapitre($idm,$numero,$norme,$type,$chap,$fic) {
		global $TBL, $db ;
		if ( $type == TITRE ) {
			$sSQL = "UPDATE ".$TBL['module']." ";
			$sSQL.= "SET norme=".GANESHA.", type=".TITRE.",";
			$sSQL.= "titre='".$chap."', link='' ";			
			$sSQL.= "WHERE id_module=".$idm." AND numero=".$numero;		
		} else {
			if ( strlen(trim($chap))!=0 && strlen(trim($fic))!=0 ) {
				$sSQL = "UPDATE ".$TBL['module']." ";
				$sSQL.= "SET norme=".$norme.", type=".$type.",";
				$sSQL.= "titre='".$chap."', link='".$fic."' ";			
				$sSQL.= "WHERE id_module=".$idm." AND numero=".$numero;
			}
		}
		$db->query($sSQL);
	}
		
	/**
	* suppression d'un module
	* @param	integer	$idm ID du module
	* @access	public
	*/
	function del($idm) {
		global $db, $TBL;
		$sSQL ="DELETE FROM ".$TBL['list_module']." WHERE module_id=".$idm;
		$db->query($sSQL)   ;
		$sSQL="DELETE FROM ".$TBL['module']." WHERE id_module=".$idm ;
		$db->query($sSQL)   ;	
	}

	/**
	* suppression d'un module
	* @param	integer	$idm ID du module
	* @param	integer	$numero numero du chapitre	
	* @access	public
	*/
	function delChapitre($idm,$numero) {
		global $db, $TBL;
		$sSQL ="DELETE FROM ".$TBL['module']." WHERE id_module=".$idm." AND numero=".$numero;
		$db->query($sSQL)   ;
		$sSQL = "UPDATE ".$TBL['module']." ";
		$sSQL.= "SET numero=(numero-1)  WHERE id_module=".$idm." AND numero>".$numero;
		$db->query($sSQL);		
		$sSQL = "UPDATE ".$TBL['tracking']." ";
		$sSQL.= "SET chapitre_id=(chapitre_id-1)  WHERE module_id=".$idm." AND chapitre_id>".$numero." AND chapitre_id=".$idm;
		$db->query($sSQL);				
	}
	
	/**
	* swap de 2 chapitres
	* @param	integer	$idm ID du module
	* @param	integer	$num1 numero du chapitre
	* @param	integer	$num2 numero du chapitre		
	* @access	public
	*/
	function swapNumeroChapitre($idm,$num1,$num2) {
		global $db, $TBL;
		$sSQL = "UPDATE ".$TBL['module']." SET numero=99  WHERE id_module=".$idm." AND numero=".$num1;
		$db->query($sSQL);
		$sSQL = "UPDATE ".$TBL['module']." SET numero=".$num1."  WHERE id_module=".$idm." AND numero=".$num2;
		$db->query($sSQL);
		$sSQL = "UPDATE ".$TBL['module']." SET numero=".$num2."  WHERE id_module=".$idm." AND numero=99";
		$db->query($sSQL);
		$sSQL = "UPDATE ".$TBL['tracking']." SET chapitre_id=99 WHERE chapitre_id=".$num1. " AND module_id=".$idm;
		$db->query($sSQL);
		$sSQL = "UPDATE ".$TBL['tracking']." SET chapitre_id=".$num1." WHERE chapitre_id=".$num2. " AND module_id=".$idm;
		$db->query($sSQL);
		$sSQL = "UPDATE ".$TBL['tracking']." SET chapitre_id=".$num2." WHERE chapitre_id=99 AND module_id=".$idm;
		$db->query($sSQL);
	}

	/**
	* Verifie un numero de chapitre pour un module
	* @param	integer	$idm ID du module
	* @param	integer	$numero numero du chapitre	
	* @access	public
	*/
	function verifChapitre($idm,$numero) {
		global $db, $TBL;
		$sSQL ="SELECT * FROM ".$TBL['module']." WHERE id_module=".$idm." AND numero=".$numero;
		$db->query($sSQL)   ;
		return($db->num_rows()==1);	
	}

	/**
	* Ajoute un nouveau chapitre a un module
	* @param	integer	$idu	id du user
	* @param	integer	$idg	id du groupe
	* @param	integer	$idm	id du module
	* @access	public
	*/
	function avancement($idu,$idg,$idm) {
		global $TBL, $db, $ClsChapitre, $ClsTracking ;
		$nbchapitre = $ClsChapitre->NbQuizz($idm)			;
		if ( $nbchapitre == 0 ) {
			return(0);
		}
		$nbchaptertracked = $ClsTracking->NbChapterTracked($idu,$idm,$idg)	;
		$avance = number_format(($nbchaptertracked/$nbchapitre)*100,2,",","")	;
		return($avance);
	}

 }// class Module

/**
* Instance de la classe Module
* @var	object	Module
*/
$ClsModule = new Module ;

?>