/* preferences.h -- preferences dialog for falling blocks game.  -*- C++ -*-
   Copyright (C) 2011-2012 Gerardo Ballabio

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>. */

#ifndef __PREFERENCES_
#define __PREFERENCES_

#include <vector>
#include <gtkmm.h>

const struct {
  Glib::ustring description;
  bool is_3d;
} brick_shape[] = {
  { "square bricks", false, },
  { "hexagonal bricks", false, },
  { "triangular bricks", false, },
  { "cubic bricks", true, },
};

class PrefsDialog : public Gtk::Dialog
{
private:
  // child widgets
  Gtk::Notebook notebook;

  // first tab
  ; Gtk::VBox tab_game;

  ; ; Gtk::VBox geometry_box1;
  ; ; ; Gtk::Label geometry_heading;
  ; ; ; Gtk::Alignment geometry_align;
  ; ; ; ; Gtk::VBox geometry_box2;
  ; ; ; ; ; Gtk::RadioButton::Group geometry_group;
  ; ; ; ; ; Gtk::RadioButton geometry_radio[sizeof(brick_shape) /
					    sizeof(brick_shape[0])];
  ; ; ; ; ; Gtk::CheckButton geometry_check;
  ; ; ; ; ; Gtk::HBox width_box;
  ; ; ; ; ; ; Gtk::Label width_label;
  ; ; ; ; ; ; Gtk::SpinButton width_spin;
  ; ; ; ; ; ; Gtk::Adjustment width_adjust;
  ; ; ; ; ; ; Gtk::HBox depth_box;
  ; ; ; ; ; ; ; Gtk::Label depth_label;
  ; ; ; ; ; ; ; Gtk::SpinButton depth_spin;
  ; ; ; ; ; ; ; Gtk::Adjustment depth_adjust;

  ; ; Gtk::VBox level_box1;
  ; ; ; Gtk::Label level_heading;
  ; ; ; Gtk::Alignment level_align;
  ; ; ; ; Gtk::VBox level_box2;
  ; ; ; ; ; Gtk::HBox mode_box1;
  ; ; ; ; ; ; Gtk::Label mode_label1;
  ; ; ; ; ; ; Gtk::ComboBoxText mode_combo1;
  ; ; ; ; ; Gtk::Alignment mode_align;
  ; ; ; ; ; ; Gtk::HBox mode_box2;
  ; ; ; ; ; ; ; Gtk::Label mode_label2;
  ; ; ; ; ; ; ; Gtk::ComboBoxText mode_combo2;
  ; ; ; ; ; ; ; Gtk::Label mode_label3;
  ; ; ; ; ; Gtk::HBox speed_box;
  ; ; ; ; ; ; Gtk::Label speed_label;
  ; ; ; ; ; ; Gtk::SpinButton speed_spin;
  ; ; ; ; ; ; Gtk::Adjustment speed_adjust;
  ; ; ; ; ; Gtk::HBox bricks_box;
  ; ; ; ; ; ; Gtk::Label bricks_label1;
  ; ; ; ; ; ; Gtk::SpinButton bricks_spin1;
  ; ; ; ; ; ; Gtk::Adjustment bricks_adjust1;
  ; ; ; ; ; ; Gtk::Label bricks_label2;
  ; ; ; ; ; ; Gtk::SpinButton bricks_spin2;
  ; ; ; ; ; ; Gtk::Adjustment bricks_adjust2;

  ; ; Gtk::VBox game_box1;
  ; ; ; Gtk::Label game_heading;
  ; ; ; Gtk::Alignment game_align;
  ; ; ; ; Gtk::VBox game_box2;
  ; ; ; ; ; Gtk::CheckButton next_check;
  ; ; ; ; ; Gtk::CheckButton land_check;
  ; ; ; ; ; Gtk::HBox empty_box;
  ; ; ; ; ; ; Gtk::Label empty_label1;
  ; ; ; ; ; ; Gtk::SpinButton empty_spin;
  ; ; ; ; ; ; Gtk::Adjustment empty_adjust;
  ; ; ; ; ; ; Gtk::Label empty_label2;

  // second tab
  ; Gtk::VBox tab_controls;
  ; ; Gtk::VBox controls_box;
  ; ; ; Gtk::Label two_heading;
  ; ; ; Gtk::Alignment two_align;
  ; ; ; ; Gtk::TreeView two_tree;
  ; ; ; ; Glib::RefPtr<Gtk::ListStore> two_list;
  ; ; ; ; struct ColumnsModel : public Gtk::TreeModel::ColumnRecord
	  {
	    Gtk::TreeModelColumn<Glib::ustring> action;
	    Gtk::TreeModelColumn<Glib::ustring> key;

	    ColumnsModel() { add(action); add(key); }
          } two_columns;
  ; ; ; Gtk::Label three_heading;
  ; ; ; Gtk::Alignment three_align;
  ; ; ; ; Gtk::TreeView three_tree;
  ; ; ; ; Glib::RefPtr<Gtk::ListStore> three_list;
  ; ; ; ; ColumnsModel three_columns;

  int width2, width3;
  int edit_keys;
  Glib::ustring edit_path;
protected:
  virtual void on_hide();
  virtual bool on_delete_event(GdkEventAny *event);
  virtual bool on_key_press_event(GdkEventKey *);
  virtual void on_geometry_radio_signal_toggled();
  virtual void on_width_spin_signal_value_changed();
  virtual void on_mode_combo1_signal_changed();
  virtual void on_bricks_spin1_signal_value_changed();
  virtual void on_two_cell_editing_started(Gtk::CellEditable *cell,
					   const Glib::ustring &path);
  virtual void on_three_cell_editing_started(Gtk::CellEditable *cell,
					     const Glib::ustring &path);
public:
  PrefsDialog();

  void reset_page() { notebook.set_current_page(0); }

  unsigned get_geometry() const;
  bool get_geometry_3d() const;
  bool get_reflection() const { return geometry_check.get_active(); }
  int get_width() const { return width_spin.get_value_as_int(); }
  int get_depth() const { return depth_spin.get_value_as_int(); }
  int get_mode1() const { return mode_combo1.get_active_row_number(); }
  int get_mode2() const { return mode_combo2.get_active_row_number(); }
  int get_speed() const { return speed_spin.get_value_as_int(); }
  int get_bricks_max() const { return bricks_spin1.get_value_as_int(); }
  int get_bricks_min() const { return bricks_spin2.get_value_as_int(); }
  bool get_next() const { return next_check.get_active(); }
  bool get_land() const { return land_check.get_active(); }
  int get_empty() const { return empty_spin.get_value_as_int(); }
  unsigned get_key_2d(int n) const;
  unsigned get_key_3d(int n) const;

  bool load();
  bool save() const;
};

#endif /* __PREFERENCES_ */
