/*  load_num_neuron.c */

/* 	Copyright 2004 Oswaldo Morizaki */

/* 	This file is part of ga-nn-ag.

    ga-nn-ag is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    ga-nn-ag is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with ga-nn; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "my_header.h"
#include "aux_prot.h"

int load_num_neuron(const char *filename)
{
	FILE * file_pointer;

	if	((file_pointer=fopen(filename,"r")) == NULL)
	{
		return(-1);
	}
	
	while(!feof(file_pointer))
	{
		fgets(char_buffer,BUFFSIZE,file_pointer);
		if(!strncmp(char_buffer,"num_neuron",10))
		{
			syslog(LOG_INFO,"num_neuron %s",char_buffer+11);
			fclose(file_pointer);
			return(atoi(char_buffer+11));
		}
	}
	fclose(file_pointer);
	return(0);
}
