/*  load_ga_server_config.c */

/* 	Copyright 2004 Oswaldo Morizaki */

/* 	This file is part of ga-nn-ag.

    ga-nn-ag is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    ga-nn-ag is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with ga-nn; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "my_header.h"
#include "aux_prot.h"

int load_ga_server_config(struct ga_server_config *conf, const char * filename)
{
	int k;
	int counter;
	char char_temp[BUFFSIZE];
	FILE * file_pointer;
	if ((file_pointer=fopen(filename,"r")) == NULL)
	{
		return(-1);
	}
	
	counter=0;
	while(!feof(file_pointer))
	{
		fgets(char_buffer,BUFFSIZE,file_pointer);
		if (!strncmp(char_buffer,"host",4))
		{
			counter += 1;
		}
	}
	
	if (counter)
	{
		if (!(conf->hosts = (char **)malloc(counter*sizeof(char *)) ))
		{
			syslog(LOG_CRIT,"Error malloc conf->hosts");
			return(-1);
		}
		for (k = 0; k< counter; k++)
		{
			if (!(conf->hosts[k] = (char *)malloc(BUFFSIZE*sizeof(char)) ))
			{
				syslog(LOG_CRIT,"Error malloc conf->hosts[%d]",k);
				return(-1);
			}
		}
	}
	
	conf->num_hosts = counter;
	
	syslog(LOG_INFO,"num_hosts = %d",conf->num_hosts);
	
	rewind(file_pointer);

	for (k = 0; k< counter; k++)
	{
		sprintf(char_temp,"host%d\n",k);
		while(!feof(file_pointer))
		{
			fgets(char_buffer,BUFFSIZE,file_pointer);
			if (!(strcmp(char_buffer,char_temp)))
			{
				fgets(char_buffer,BUFFSIZE,file_pointer);	
				clean_char_buffer(char_buffer);			
				strcpy(conf->hosts[k],char_buffer);
				syslog(LOG_INFO,"host%d = %s",k,conf->hosts[k]);
				break;
			}
		}
	}
	
	rewind(file_pointer);

	counter=0;
	while(!feof(file_pointer))
	{
		fgets(char_buffer,BUFFSIZE,file_pointer);
		if (!strncmp(char_buffer,"niche",5))
		{
			counter += 1;
		}
	}

	if (counter)
	{	
		if (!(conf->niches = (char **)malloc(counter*sizeof(char *)) ))
		{
			syslog(LOG_CRIT,"Error malloc conf->niches");
			return(-1);
		}
		for (k = 0; k< counter; k++)
		{
			if (!(conf->niches[k] = (char *)malloc(BUFFSIZE*sizeof(char)) ))
			{
				syslog(LOG_CRIT,"Error malloc conf->niches[%d]",k);
				return(-1);
			}
		}
	}
	
	conf->num_niche = counter;
	
	syslog(LOG_INFO,"num_niches = %d",conf->num_niche);
	
	rewind(file_pointer);

	for (k = 0; k< counter; k++)
	{
		sprintf(char_temp,"niche%d\n",k);
		while(!feof(file_pointer))
		{
			fgets(char_buffer,BUFFSIZE,file_pointer);
			if (!(strcmp(char_buffer,char_temp)))
			{
				fgets(char_buffer,BUFFSIZE,file_pointer);	
				clean_char_buffer(char_buffer);			
				strcpy(conf->niches[k],char_buffer);
				syslog(LOG_INFO,"niche%d = %s",k,conf->niches[k]);
				break;
			}
		}
	}
	
	rewind(file_pointer);

	while(!feof(file_pointer))
	{
		fgets(char_buffer,BUFFSIZE,file_pointer);

		if (!strcmp(char_buffer,"ip\n"))
		{
			fgets(char_buffer,BUFFSIZE,file_pointer);
			clean_char_buffer(char_buffer);
			strcpy(conf->ip,char_buffer);
			syslog(LOG_INFO,"ip = %s",conf->ip);
		}
		else if (!strcmp(char_buffer,"master\n"))
		{
			fgets(char_buffer,BUFFSIZE,file_pointer);
			conf->master = atoi(char_buffer);
			syslog(LOG_INFO,"master = %d",conf->master);
		}
		else if (!strcmp(char_buffer,"init_preffix\n"))
		{
			fgets(char_buffer,BUFFSIZE,file_pointer);
			clean_char_buffer(char_buffer);
			strcpy(conf->init_preffix,char_buffer);
			syslog(LOG_INFO,"init_preffix = %s",conf->init_preffix);
		}
		else if (!strcmp(char_buffer,"result_preffix\n"))
		{
			fgets(char_buffer,BUFFSIZE,file_pointer);
			clean_char_buffer(char_buffer);
			strcpy(conf->result_preffix,char_buffer);
			syslog(LOG_INFO,"result_preffix = %s",conf->result_preffix);
		}
		else if (!strcmp(char_buffer,"time_wait\n"))
		{
			fgets(char_buffer,BUFFSIZE,file_pointer);
			conf->time_wait=atoi(char_buffer);
			syslog(LOG_INFO,"time_wait = %d",conf->time_wait);
		}
		else if (!strcmp(char_buffer,"max_local\n"))
		{
			fgets(char_buffer,BUFFSIZE,file_pointer);
			conf->max_local=atoi(char_buffer);
			syslog(LOG_INFO,"max_local = %d",conf->max_local);
		}
		else if (!strcmp(char_buffer,"local_server_port\n"))
		{
			fgets(char_buffer,BUFFSIZE,file_pointer);
			conf->local_server_port=(unsigned int)atoi(char_buffer);
			syslog(LOG_INFO,"local_server_port = %d",conf->local_server_port);
		}
		else if (!strcmp(char_buffer,"remote_server_port\n"))
		{
			fgets(char_buffer,BUFFSIZE,file_pointer);
			conf->remote_server_port=(unsigned int)atoi(char_buffer);
			syslog(LOG_INFO,"remote_server_port = %d",conf->remote_server_port);
		}
		else if (!strcmp(char_buffer,"poblation\n"))
		{
			fgets(char_buffer,BUFFSIZE,file_pointer);
			conf->poblation=atoi(char_buffer);
			syslog(LOG_INFO,"poblation = %d",conf->poblation);
		}
		else if (!strcmp(char_buffer,"generations\n"))
		{
			fgets(char_buffer,BUFFSIZE,file_pointer);
			conf->generations=atoi(char_buffer);
			syslog(LOG_INFO,"generations = %d",conf->generations);
		}
		else if (!strcmp(char_buffer,"max_neuron_mut\n"))
		{
			fgets(char_buffer,BUFFSIZE,file_pointer);
			conf->max_neuron_mut=atoi(char_buffer);
			syslog(LOG_INFO,"max_neuron_mut = %d",conf->max_neuron_mut);
		}
		else if (!strcmp(char_buffer,"max_num_layer\n"))
		{
			fgets(char_buffer,BUFFSIZE,file_pointer);
			conf->max_num_layer=atoi(char_buffer);
			syslog(LOG_INFO,"max_num_layer = %d",conf->max_num_layer);
		}		
		else if (!strcmp(char_buffer,"max_num_neuron\n"))
		{
			fgets(char_buffer,BUFFSIZE,file_pointer);
			conf->max_num_neuron=atoi(char_buffer);
			syslog(LOG_INFO,"max_num_neuron = %d",conf->max_num_neuron);
		}
		else if (!strcmp(char_buffer,"agregation\n"))
		{
			fgets(char_buffer,BUFFSIZE,file_pointer);
			conf->agr=atoi(char_buffer);
			syslog(LOG_INFO,"agregation = %d",conf->agr);
		}
		else if (!strcmp(char_buffer,"lifespan\n"))
		{
			fgets(char_buffer,BUFFSIZE,file_pointer);
			conf->lifespan=atoi(char_buffer);
			syslog(LOG_INFO,"lifespan = %d",conf->lifespan);
		}
		else if (!strcmp(char_buffer,"mut_new_prob\n"))
		{
			fgets(char_buffer,BUFFSIZE,file_pointer);
			conf->mut_new_prob=atof(char_buffer);
			syslog(LOG_INFO,"mut_new_prob = %f",conf->mut_new_prob);
		}
		else if (!strcmp(char_buffer,"inm_prob\n"))
		{
			fgets(char_buffer,BUFFSIZE,file_pointer);
			conf->inm_prob=atof(char_buffer);
			syslog(LOG_INFO,"inm_prob = %f",conf->inm_prob);
		}
		else if (!strcmp(char_buffer,"mut_neuron_prob\n"))
		{
			fgets(char_buffer,BUFFSIZE,file_pointer);
			conf->mut_neuron_prob=atof(char_buffer);
			syslog(LOG_INFO,"mut_neuron_prob = %f",conf->mut_neuron_prob);
		}
		else if (!strcmp(char_buffer,"mut_net_prob\n"))
		{
			fgets(char_buffer,BUFFSIZE,file_pointer);
			conf->mut_net_prob=atof(char_buffer);
			syslog(LOG_INFO,"mut_net_prob = %f",conf->mut_net_prob);
		}
		else if (!strcmp(char_buffer,"base\n"))
		{
			fgets(char_buffer,BUFFSIZE,file_pointer);
			conf->base=atof(char_buffer);
			syslog(LOG_INFO,"base = %f",conf->base);
		}
		else if (!strcmp(char_buffer,"boost\n"))
		{
			fgets(char_buffer,BUFFSIZE,file_pointer);
			conf->boost=atof(char_buffer);
			syslog(LOG_INFO,"boost = %f",conf->boost);
		}
		else if (!strcmp(char_buffer,"level\n"))
		{
			fgets(char_buffer,BUFFSIZE,file_pointer);
			conf->level=atof(char_buffer);
			syslog(LOG_INFO,"level = %f",conf->level);
		}
		else if (!strcmp(char_buffer,"prob_alpha\n"))
		{
			fgets(char_buffer,BUFFSIZE,file_pointer);
			conf->prob_alpha=atof(char_buffer);
			syslog(LOG_INFO,"prob_alpha = %f",conf->prob_alpha);
		}		
		else if (!strcmp(char_buffer,"prob_conv_rate\n"))
		{
			fgets(char_buffer,BUFFSIZE,file_pointer);
			conf->prob_conv_rate=atof(char_buffer);
			syslog(LOG_INFO,"prob_conv_rate = %f",conf->prob_conv_rate);
		}		
		else if (!strcmp(char_buffer,"prob_bias_corr\n"))
		{
			fgets(char_buffer,BUFFSIZE,file_pointer);
			conf->prob_bias_corr=atof(char_buffer);
			syslog(LOG_INFO,"prob_bias_corr = %f",conf->prob_bias_corr);
		}		
		else if (!strcmp(char_buffer,"prob_delta_type\n"))
		{
			fgets(char_buffer,BUFFSIZE,file_pointer);
			conf->prob_delta_type=atof(char_buffer);
			syslog(LOG_INFO,"prob_delta_type = %f",conf->prob_delta_type);
		}		
		else if (!strcmp(char_buffer,"prob_momentum\n"))
		{
			fgets(char_buffer,BUFFSIZE,file_pointer);
			conf->prob_momentum=atof(char_buffer);
			syslog(LOG_INFO,"prob_momentum = %f",conf->prob_momentum);
		}		
		else if (!strcmp(char_buffer,"prob_num_con\n"))
		{
			fgets(char_buffer,BUFFSIZE,file_pointer);
			conf->prob_num_con=atof(char_buffer);
			syslog(LOG_INFO,"prob_num_con = %f",conf->prob_num_con);
		}		
		else if (!strcmp(char_buffer,"prob_bias\n"))
		{
			fgets(char_buffer,BUFFSIZE,file_pointer);
			conf->prob_bias=atof(char_buffer);
			syslog(LOG_INFO,"prob_bias = %f",conf->prob_bias);
		}		
	}
	fclose(file_pointer);
	return(1);
}
