/*  ga_server_remote.c */
/* 	Copyright 2004 Oswaldo Morizaki */

/* 	This file is part of ga-nn-ag.

    ga-nn-ag is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    ga-nn-ag is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with ga-nn; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "my_header.h"
#include "aux_prot.h"

/*********** Require Revision ************/

int main(int argc, char * argv[])
{
pid_t pid;
socklen_t clilen;
struct sockaddr_in cli_in_addr, serv_in_addr;
struct ga_server_config ga_conf;

int listenfd, connfd;
int k,l,m,n;
int port;
int status;

char ip[BUFFSIZE];
char char_temp[BUFFSIZE];

char path_buffer[8*BUFFSIZE];

char ** char_vector;

if (argc != 3)
{
	printf("Wrong number of parameters\nUsage:\n");
	printf("%s ip port\n",argv[0]);
	exit(1);
}

strcpy(ip,argv[1]);
port = atoi(argv[2]);

/*
if ( getcwd(path_buffer, 8*BUFFSIZE) == NULL)
{
	syslog(LOG_CRIT,"Couldn't get path, NICHE unavalaible");
}

chdir(path_buffer);
*/

if( (pid = fork()) <0 )
{
	printf("Error fork: %s\n",strerror(errno));
	return(1);
}
else if (pid != 0)
{
	printf("ga_server_remote started\n");
	exit(0);
}

setsid();

openlog("ga_server_remote",LOG_PID,LOG_LOCAL4);

if ( (listenfd = socket(PF_INET, SOCK_STREAM, 0)) < 0)
{
	syslog(LOG_CRIT,"Error creating listen socket");
	return(1);
}
bzero(&serv_in_addr,sizeof(serv_in_addr));
serv_in_addr.sin_family = AF_INET;
if (inet_pton(AF_INET,ip,&serv_in_addr.sin_addr) < 1)
{
	syslog(LOG_CRIT,"Error inet_pton() %s",strerror(errno));
	return(1);
}
serv_in_addr.sin_port = htons((uint16_t)port);

if ( (bind(listenfd, (struct sockaddr *) &serv_in_addr, sizeof(serv_in_addr)) ) < 0)
{
	syslog(LOG_CRIT,"Error Binding socket: %s",strerror(errno));
	return(1);
}

if ( (listen(listenfd,LISTENQ)) <0 )
{
	syslog(LOG_CRIT,"Error listenning %s",strerror(errno));
	return(1);
}

/*********************************/
syslog(LOG_INFO,"ga_server_remote daemon");
syslog(LOG_INFO,"listen ip = %s",ip);
syslog(LOG_INFO,"listen port = %d",port);
syslog(LOG_INFO,"Ready for connections");

while(1)
{
	clilen = sizeof(cli_in_addr);
	if ( (connfd = accept(listenfd, (struct sockaddr *) &cli_in_addr, &clilen)) <0 )
	{
		if (errno == EINTR)
		{
			continue;
		}
		else
		{
			syslog(LOG_CRIT,"Accept error: %s",strerror(errno));
			return;
		}
	}
	syslog(LOG_INFO,"Master connection accepted");
	
	if ((pid = fork())< 0)
	{
		syslog(LOG_CRIT,"Fork error");
	}
	else if(pid == 0)
	{
		close(listenfd);
	
		if (read_ga_server_remote_config(&ga_conf,connfd) != 1)
		{
			syslog(LOG_CRIT,"Error reading ga_conf in remote server");
			exit(0);
		}

		if ( !strncmp(ga_conf.message,"SPAWN",5) )
		{
			syslog(LOG_INFO,"Spawning clients");
			for (k = ga_conf.first_local; k <= ga_conf.last_local; k++)
			{
				if ((pid=fork()) < 0)
				{
					syslog(LOG_CRIT,"Error fork client: %d %s",k,strerror(errno));
					return(1);
				}
				else if (pid==0)
				{
					setsid();
					if ( !(char_vector = (char **)malloc(11*sizeof(char *)) ))
					{
						syslog(LOG_CRIT,"Error malloc char_vector");
						return(1);
					}
					for (l=0; l< 11; l++)
					{
						if ( !(char_vector[l] = (char *)malloc(BUFFSIZE*sizeof(char)) ))
						{
							syslog(LOG_CRIT,"Error malloc char_vector[%d]",l);
							return(1);
						}
					}
					char_vector[10]=NULL;
					sprintf(char_vector[0],"./ga_client\0");
					sprintf(char_vector[1],"%d\0",k);
					sprintf(char_vector[2],"%d\0",ga_conf.max_num_layer);
					sprintf(char_vector[3],"%d\0",ga_conf.max_num_neuron);
					sprintf(char_vector[4],"%d\0",ga_conf.generations);
					sprintf(char_vector[5],"%s\0",ga_conf.ip);
					sprintf(char_vector[6],"%d\0",ga_conf.local_server_port+k);
					sprintf(char_vector[7],"%d\0",ga_conf.agr);
					sprintf(char_vector[8],"%s\0",ga_conf.init_preffix);
					sprintf(char_vector[9],"%s\0",ga_conf.result_preffix);
				
					execvp("./ga_client",char_vector);
				}

				if(waitpid(pid,&status,0) < 0)
				{
					syslog(LOG_CRIT,"Wait error ga_remote_server %s",strerror(errno));
					return(1);	
				}
				exit(0);
			}
		}
		else if (!strncmp(ga_conf.message,"NICHE",5) )
		{
			syslog(LOG_INFO,"Init new NICHE");
			execlp("./ga_server","./ga_server",NULL);
		}
		close(connfd);
		exit(0);
	}
//	if(waitpid(pid,&status,0) < 0)
//	{
//		syslog(LOG_CRIT,"Wait error ga_remote_server %s",strerror(errno));
//		return(1);	
//	}

	
}

}
