/*  mutate_neuron.c */

/* 	Copyright 2004 Oswaldo Morizaki */

/* 	This file is part of ga-nn-ag.

    ga-nn-ag is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    ga-nn-ag is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with ga-nn-ag; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "my_header.h"
#include "aux_prot.h"

void * mutate_neuron(struct neuron * neuron_unit, struct ga_server_config * mut)
{
	float * fitness;
	float * con_x;
	float * con_y;
	
	double * con_w;
	double * delta_con_w;
	
	int * age;
	
	double temp;
	
	int result;
	int k,l,m;
	int size;

	size=7;

	if( !(fitness = malloc(size*sizeof(float)) ))
	{
		syslog(LOG_CRIT,"Error malloc fitness in mutate_neuron()");
		return(NULL);
	}
	
	fitness[0] = (neuron_unit->momentum > 0) ? mut->prob_alpha : 0.0 ;
	fitness[1] = mut->prob_conv_rate;
	fitness[2] = mut->prob_bias_corr;
	fitness[3] = mut->prob_delta_type;
	fitness[4] = mut->prob_momentum;
	fitness[5] = (neuron_unit->num_con > 0) ? mut->prob_num_con : 0.0 ;
	fitness[6] = mut->prob_bias;
	
	sprintf(char_buffer,"Probability: %f %f %f %f %f %f %f",fitness[0],fitness[1],
													fitness[2],fitness[3],fitness[4],fitness[5],fitness[6]);
	syslog(LOG_INFO,char_buffer);
	
	result = roulette(size,fitness);
	
	switch (result)
	{
		case 0:
		{
			if (neuron_unit->alpha > 0.0)
			{
				temp = pow(100,-(rand_gen(neuron_unit->num_con)));
				temp = (coin_toss(neuron_unit->num_con + 1) == 1) ? temp : -temp;
				temp *= neuron_unit->alpha;
			}
			else
			{
				rand_gen(neuron_unit->num_con);
			}
			syslog(LOG_INFO,"Current alpha = %3.9f",neuron_unit->alpha);
			neuron_unit->alpha += temp;
			syslog(LOG_INFO,"New alpha = %3.9f",neuron_unit->alpha);
			break;
		}
		case 1:
		{
			if (neuron_unit->conv_rate > 0.0)
			{
				temp = pow(100,-(rand_gen(neuron_unit->num_con + 2)));
				temp = (coin_toss(neuron_unit->num_con + 3) == 1) ? temp : -temp;
				temp *= neuron_unit->conv_rate;
			}
			else
			{
				temp = rand_gen(neuron_unit->num_con + 2);
			}
			syslog(LOG_INFO,"Current conv_rate = %3.9f",neuron_unit->conv_rate);
			neuron_unit->conv_rate += temp;
			syslog(LOG_INFO,"New conv_rate = %3.9f",neuron_unit->conv_rate);
			break;
		}
		case 2:
		{
			neuron_unit->bias_corr = (neuron_unit->bias_corr == 1) ? 0 : 1;
			syslog(LOG_INFO,"New bias_corr = %d",neuron_unit->bias_corr);
			break;
		}
		case 3:
		{
			neuron_unit->delta_type = (neuron_unit->delta_type == 1) ? 0 : 1;
			syslog(LOG_INFO,"New delta_type = %d",neuron_unit->delta_type);
			break;
		}
		case 4:
		{
			if (neuron_unit->momentum == 1)
			{
				neuron_unit->momentum = 0;
				if (neuron_unit->num_con)
				{
					free(neuron_unit->delta_con_w);
				}
				neuron_unit->delta_con_w = NULL;
			}
			else
			{
				neuron_unit->momentum = 1;
				if (neuron_unit->num_con)
				{
					if (!(neuron_unit->delta_con_w = (double *)calloc(
													neuron_unit->num_con,sizeof(float)) ))
					{
						syslog(LOG_CRIT,"Error in calloc delta_con_w in mutate_neuron()");
						return(NULL);
					}
				}
			}
			syslog(LOG_INFO,"New momentum = %d",neuron_unit->momentum);
			break;
		}
		case 5:
		{
			k = dice_toss(neuron_unit->num_con + 4, neuron_unit->num_con);
			if ( coin_toss(neuron_unit->num_con + 5) )
			{
				if (*(neuron_unit->con_w+k) > 0.0)
				{
					temp = pow(100,-(rand_gen(neuron_unit->num_con + 6)));
					temp = (coin_toss(neuron_unit->num_con + 3) == 1) ? temp : -temp;
					temp *= *(neuron_unit->con_w + k);
				}
				else
				{
					temp = rand_gen(neuron_unit->num_con + 6);
				}
				syslog(LOG_INFO,"Current weight[%d]: %3.9f",k,*(neuron_unit->con_w+k));
				*(neuron_unit->con_w + k) += temp;
				syslog(LOG_INFO,"New weight[%d]: %3.9f",k,*(neuron_unit->con_w+k));
				break;
			}

			syslog(LOG_INFO,"Erasing connection num_con=%d connection=%d",neuron_unit->num_con,k);
			neuron_unit->num_con -= 1;
			
			if (neuron_unit->num_con)
			{
				if (!(con_x = (float *)calloc(neuron_unit->num_con,sizeof(float)) ))
				{
					syslog(LOG_CRIT,"Error calloc con_x in mutate_neuron()");
					return(NULL);
				}
				if (!(con_y = (float *)calloc(neuron_unit->num_con,sizeof(float)) ))
				{
					syslog(LOG_CRIT,"Error calloc con_y in mutate_neuron()");
					return(NULL);
				}
				if (!(con_w = (double *)calloc(neuron_unit->num_con,sizeof(double)) ))
				{
					syslog(LOG_CRIT,"Error calloc con_w in mutate_neuron()");
					return(NULL);
				}
				if (!(age = (int *)calloc(neuron_unit->num_con,sizeof(int)) ))
				{
					syslog(LOG_CRIT,"Error calloc age in mutate_neuron()");
					return(NULL);
				}

				if (neuron_unit->momentum == 1)
				{
					if (!(delta_con_w = (double *)calloc(neuron_unit->num_con,sizeof(double)) ))
					{
						syslog(LOG_CRIT,"Error calloc delta_con_w in mutate_neuron()");
						return(NULL);
					}
				}
				
				m=0;
				for (l=0; l< neuron_unit->num_con + 1; l++)
				{
					if (k != l)
					{
						*(con_x+m) = *(neuron_unit->con_x+l);
						*(con_y+m) = *(neuron_unit->con_y+l);
						*(con_w+m) = *(neuron_unit->con_w+l);
						*(age + m) = *(neuron_unit->age + l);
						if (neuron_unit->momentum == 1)
						{
							*(delta_con_w+m) = *(neuron_unit->delta_con_w+l);
						}
						m++;
					}
				}
				if (!(neuron_unit->con_x = (float *)realloc(neuron_unit->con_x,
																					neuron_unit->num_con*sizeof(float)) ))
				{
					syslog(LOG_CRIT,"Error realloc neuron_unit->con_x in mutate_neuron()");
					return(NULL);
				}			
				if (!(neuron_unit->con_y = (float *)realloc(neuron_unit->con_y,
																					neuron_unit->num_con*sizeof(float)) ))
				{
					syslog(LOG_CRIT,"Error realloc neuron_unit->con_y in mutate_neuron()");
					return(NULL);
				}			
				if (!(neuron_unit->con_w = (double *)realloc(neuron_unit->con_w,
																				neuron_unit->num_con*sizeof(double)) ))
				{
					syslog(LOG_CRIT,"Error realloc neuron_unit->con_w in mutate_neuron()");
					return(NULL);
				}			
				if (!(neuron_unit->age = (int *)realloc(neuron_unit->age,
																				neuron_unit->num_con*sizeof(int)) ))
				{
					syslog(LOG_CRIT,"Error realloc neuron_unit->age in mutate_neuron()");
					return(NULL);
				}			

				if (neuron_unit->momentum == 1)
				{
					if (!(neuron_unit->delta_con_w = (double *)realloc(neuron_unit->delta_con_w,
																								neuron_unit->num_con*sizeof(double)) ))
					{
						syslog(LOG_CRIT,"Error realloc neuron_unit->delta_con_w in mutate_neuron()");
						return(NULL);
					}			
				}
				for (l=0; l< neuron_unit->num_con; l++)
				{
					*(neuron_unit->con_x + l) = *(con_x + l);
					*(neuron_unit->con_y + l) = *(con_y + l);
					*(neuron_unit->con_w + l) = *(con_w + l);
					*(neuron_unit->age + l) = *(age + l);
					if (neuron_unit->momentum == 1)
					{
						*(neuron_unit->delta_con_w + l) = *(delta_con_w + l);
					}
				}
			}
			else
			{
				free(neuron_unit->con_x);
				free(neuron_unit->con_y);
				free(neuron_unit->con_w);
				free(neuron_unit->age);
				if (neuron_unit->momentum == 1)
				{
					free(neuron_unit->delta_con_w);
					neuron_unit->delta_con_w=NULL;
				}
				neuron_unit->con_x=NULL;
				neuron_unit->con_y=NULL;
				neuron_unit->con_w=NULL;
				neuron_unit->age=NULL;
			}
			syslog(LOG_INFO,"Connection erased, new num_con=%d",neuron_unit->num_con);
			break; 
		}
		case 6:
		{
			if (neuron_unit->bias > 0.0)
			{
				temp = pow(100,-(rand_gen(neuron_unit->num_con + 7)));
				temp = (coin_toss(neuron_unit->num_con + 1) == 6) ? temp : -temp;
				temp *= neuron_unit->bias;
			}
			else
			{
				temp=rand_gen(rand_gen(neuron_unit->num_con + 7));
			}
			syslog(LOG_INFO,"Current bias = %3.9f",neuron_unit->bias);
			neuron_unit->bias += temp;
			syslog(LOG_INFO,"New bias = %3.9f",neuron_unit->bias);
			break;
		}
	}
	return(neuron_unit);
}
