/*  append_neuron.c */

/* 	Copyright 2004 Oswaldo Morizaki */

/* 	This file is part of ga-nn-ag.

    ga-nn-ag is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    ga-nn-ag is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with ga-nn-ag; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "my_header.h"
#include "aux_prot.h"

/** Append over parent1 **/
void * append_neuron(int num_neuron1, int num_neuron2, struct neuron ** parent1, 
										struct neuron ** parent2, int * inner_elem2, int * new_num_neuron)
{
	int k,l,m;
	int counter;
	int num_neuron;
	int * inner_elem;
	int * age;
	
	float range;
	float dist;
	
	float * con_x;
	float * con_y;
	
	double * con_w;
	double * delta_con_w;
	
	struct neuron ** temp_neuron;
	
	counter=0; //number of elements to append
	for (k=0; k < num_neuron2; k++)
	{
		if (inner_elem2[k])
		{
			counter++;
		}
	} 
	
	//syslog(LOG_INFO,"Number of elements to append = %d",counter);
	
	//Just in case realloc fails
	temp_neuron = NULL;
	if (counter)
	{
		num_neuron = (num_neuron1 + counter);
		
		if( !(temp_neuron = (struct neuron **)copy_neuron_array(num_neuron1,
										parent1, temp_neuron)) )
		{
			syslog(LOG_CRIT,"Error in copy parent1 to temp_neuron");
			return(NULL);
		}
		if ( (parent1 = (struct neuron **)free_neuron_array(num_neuron1,parent1) ))
		{
			syslog(LOG_CRIT,"Error in free_neuron_array parent1",k);
			return(NULL);
		}

//		syslog(LOG_INFO,"Resizing parent1 num_neuron1=%d num_neuron=%d",num_neuron1,num_neuron);
		/** Resize of parent1 **/
		if (!(parent1 = (struct neuron **)calloc(num_neuron,sizeof(struct neuron *)) ))
		{
			syslog(LOG_CRIT,"Error calloc parent1 in append_neuron()");
			return(NULL);
		}
		for (k=0; k< num_neuron; k++)
		{
			if(!(parent1[k] = (struct neuron *)calloc(1,sizeof(struct neuron)) ))
			{
				syslog(LOG_CRIT,"Error calloc parent1[%d] in append_neuron()",k);
				return(NULL);
			}
		}
		
		for (k=0; k<num_neuron1; k++)
		{
			if (temp_neuron[k]->num_con)
			{
				if (!(parent1[k]->con_x = (float *)malloc(temp_neuron[k]->num_con*sizeof(float)) ))
				{
					syslog(LOG_CRIT,"Error malloc parent1[%d]->con_x in append_neuron()",k);
					return(NULL);
				}
				if (!(parent1[k]->con_y = (float *)malloc(temp_neuron[k]->num_con*sizeof(float)) ))
				{
					syslog(LOG_CRIT,"Error malloc parent1[%d]->con_y in append_neuron()",k);
					return(NULL);
				}
				if (!(parent1[k]->con_w = (double *)malloc(temp_neuron[k]->num_con*sizeof(double)) ))
				{
					syslog(LOG_CRIT,"Error malloc parent1[%d]->con_w in append_neuron()",k);
					return(NULL);
				}
				if (!(parent1[k]->age = (int *)malloc(temp_neuron[k]->num_con*sizeof(int)) ))
				{
					syslog(LOG_CRIT,"Error malloc parent1[%d]->age in append_neuron()",k);
					return(NULL);
				}

				if (temp_neuron[k]->momentum == 1)
				{
					if (!(parent1[k]->delta_con_w = (double *)malloc
																					(temp_neuron[k]->num_con*sizeof(double)) ))
					{
						syslog(LOG_CRIT,"Error malloc parent1[%d]->delta_con_w in append_neuron()",k);
						return(NULL);
					}
				}
			}
			else
			{
				parent1[k]->con_x=NULL;
				parent1[k]->con_y=NULL;
				parent1[k]->con_w=NULL;
				parent1[k]->age=NULL;
				parent1[k]->delta_con_w=NULL;
			}
		}
		
		l=num_neuron1;
		for (k=0; k< num_neuron2; k++)
		{
			if (inner_elem2[k])
			{
				if (parent2[k]->num_con)
				{
//					syslog(LOG_INFO,"num_con[%d]=%d",l,parent2[k]->num_con);
					if (!(parent1[l]->con_x = (float *)malloc(parent2[k]->num_con*sizeof(float)) ))
					{
						syslog(LOG_CRIT,"Error malloc parent1[%d]->con_x in append_neuron()",l);
						return(NULL);
					}
					if (!(parent1[l]->con_y = (float *)malloc(parent2[k]->num_con*sizeof(float)) ))
					{
						syslog(LOG_CRIT,"Error malloc parent1[%d]->con_y in append_neuron()",l);
						return(NULL);
					}
					if (!(parent1[l]->con_w = (double *)malloc(parent2[k]->num_con*sizeof(double)) ))
					{
						syslog(LOG_CRIT,"Error malloc parent1[%d]->con_w in append_neuron()",l);
						return(NULL);
					}
					if (!(parent1[l]->age = (int *)malloc(parent2[k]->num_con*sizeof(int)) ))
					{
						syslog(LOG_CRIT,"Error malloc parent1[%d]->age in append_neuron()",l);
						return(NULL);
					}

					if (parent2[k]->momentum == 1)
					{
						if (!(parent1[l]->delta_con_w = (double *)malloc
																					(parent2[k]->num_con*sizeof(double)) ))
						{
							syslog(LOG_CRIT,"Error malloc parent1[%d]->delta_con_w in append_neuron()",l);
							return(NULL);
						}
					}
				}
				else
				{
					parent1[l]->con_x=NULL;
					parent1[l]->con_y=NULL;
					parent1[l]->con_w=NULL;
					parent1[l]->age=NULL;
					parent1[l]->delta_con_w=NULL;
				}
				l++;	
			}
		}
		
/** Copy from temp buffer to parent1 **/
		for (k=0; k< num_neuron1; k++)
		{
			copy_neuron(temp_neuron[k], parent1[k]);
		}

/** Append extra neurons **/		
		if (!( inner_elem = (int *)calloc(num_neuron,sizeof(int)) ))
		{
			syslog(LOG_CRIT,"Error calloc inner_elem in append_neuron");
			return(NULL);
		}

		l=num_neuron1;
		for (k=0; k< num_neuron2; k++)
		{
			if (inner_elem2[k])
			{
				copy_neuron(parent2[k], parent1[l]);
				inner_elem[l] = inner_elem2[k];
				l++;
			}
		}
		
		
/** Make connections **/
/* range with 1% of tolerance */
/** out - in connections **/
		for (k=0; k< num_neuron1; k++)
		{ 
			for (l=num_neuron1; l<num_neuron; l++)
			{
				if (parent1[k]->x_c > parent1[l]->x_c)
				{
					dist = parent1[k]->x_c - parent1[l]->x_c;
					if ( (inner_elem[l] == 1) || (inner_elem[l] == 2) )
					{
						range = (parent1[k]->range > parent1[l]->range) ? 
											parent1[l]->range : parent1[k]->range;
					}
					else if ( (inner_elem[l] == 4) || (inner_elem[l] == 8) )
					{
						range = (parent1[k]->range > parent1[l]->range) ? 
											parent1[k]->range : parent1[l]->range;
					}
					range += range*0.01;
					if (range > dist)
					{
						parent1[k]->num_con++;
						if ( parent1[k]->con_x == NULL)  //con_x
						{
							if ( !(parent1[k]->con_x = malloc(sizeof(float)) ))
							{
								syslog(LOG_CRIT,"Error malloc parent1[%d]->con_x",k);
								return(NULL);
							}
							if ( !(parent1[k]->con_y = malloc(sizeof(float)) ))
							{
								syslog(LOG_CRIT,"Error malloc parent1[%d]->con_y",k);
								return(NULL);
							}
							if ( !(parent1[k]->con_w = malloc(sizeof(double)) ))
							{
								syslog(LOG_CRIT,"Error malloc parent1[%d]->con_w",k);
								return(NULL);
							}
							if ( !(parent1[k]->age = malloc(sizeof(int)) ))
							{
								syslog(LOG_CRIT,"Error malloc parent1[%d]->age",k);
								return(NULL);
							}

							if (parent1[k]->momentum == 1);
							{
								if ( !(parent1[k]->delta_con_w = malloc(sizeof(double)) ))
								{
									syslog(LOG_CRIT,"Error malloc parent1[%d]->delta_con_w",k);
									return(NULL);
								}
							}
						}
						else 
						{
							if ( !(parent1[k]->con_x = realloc(parent1[k]->con_x,
									parent1[k]->num_con*sizeof(float)) ))
							{
								syslog(LOG_CRIT,"Error realloc parent1[%d]->con_x",k);
								return(NULL);
							}
							if ( !(parent1[k]->con_y = realloc(parent1[k]->con_y,
										parent1[k]->num_con*sizeof(float)) ))
							{
								syslog(LOG_CRIT,"Error realloc parent1[%d]->con_y",k);
								return(NULL);
							}
							if ( !(parent1[k]->con_w = realloc(parent1[k]->con_w,
									parent1[k]->num_con*sizeof(double)) ))
							{
								syslog(LOG_CRIT,"Error realloc parent1[%d]->con_w",k);
								return(NULL);
							}
							if ( !(parent1[k]->age = realloc(parent1[k]->age,
									parent1[k]->num_con*sizeof(int)) ))
							{
								syslog(LOG_CRIT,"Error realloc parent1[%d]->age",k);
								return(NULL);
							}

							if ( parent1[k]->momentum == 1)		//delta_con_w;
							{
								if ( !(parent1[k]->delta_con_w = realloc(parent1[k]->delta_con_w,
										parent1[k]->num_con*sizeof(double)) ))
								{
									syslog(LOG_CRIT,"Error realloc parent1[%d]->delta_con_w",k);
									return(NULL);
								}
							}
						}
						*(parent1[k]->con_x + parent1[k]->num_con - 1) = parent1[l]->x_c;
						*(parent1[k]->con_y + parent1[k]->num_con - 1) = parent1[l]->y_c;
						*(parent1[k]->con_w + parent1[k]->num_con - 1) = rand_gen(l);
						*(parent1[k]->age + parent1[k]->num_con - 1) = 0;
						if (parent1[k]->momentum == 1)
						{
							*(parent1[k]->delta_con_w + parent1[k]->num_con - 1) = 0;
						}
					}
				}
			}
		}
		
		/** in - out connections **/
		for (k=num_neuron1; k< num_neuron; k++)
		{ 
			for (l=0; l<num_neuron1; l++)
			{
				if (parent1[k]->x_c > parent1[l]->x_c)
				{
					dist = parent1[k]->x_c - parent1[l]->x_c;
					if ( (inner_elem[l] == 1) || (inner_elem[l] == 4) )
					{
						range = (parent1[k]->range > parent1[l]->range) ? 
											parent1[l]->range : parent1[k]->range;
					}
					else if ( (inner_elem[l] == 2) || (inner_elem[l] == 8) )
					{
						range = (parent1[k]->range > parent1[l]->range) ? 
											parent1[k]->range : parent1[l]->range;
						parent1[k]->range = range;
					}
					range += range*0.01;
					if (range > dist)
					{
						parent1[k]->num_con++;
						if ( parent1[k]->con_x == NULL)  //con_x
						{
							if ( !(parent1[k]->con_x = malloc(sizeof(float)) ))
							{
								syslog(LOG_CRIT,"Error malloc parent1[%d]->con_x",k);
								return(NULL);
							}
							if ( !(parent1[k]->con_y = malloc(sizeof(float)) ))
							{
								syslog(LOG_CRIT,"Error malloc parent1[%d]->con_y",k);
								return(NULL);
							}
							if ( !(parent1[k]->con_w = malloc(sizeof(double)) ))
							{
								syslog(LOG_CRIT,"Error malloc parent1[%d]->con_w",k);
								return(NULL);
							}
							if ( !(parent1[k]->age = malloc(sizeof(int)) ))
							{
								syslog(LOG_CRIT,"Error malloc parent1[%d]->age",k);
								return(NULL);
							}

							if (parent1[k]->momentum == 1);
							{
								if ( !(parent1[k]->delta_con_w = malloc(sizeof(double)) ))
								{
									syslog(LOG_CRIT,"Error malloc parent1[%d]->delta_con_w",k);
									return(NULL);
								}
							}
						}
						else 
						{
							if ( !(parent1[k]->con_x = realloc(parent1[k]->con_x,
									parent1[k]->num_con*sizeof(float)) ))
							{
								syslog(LOG_CRIT,"Error realloc parent1[%d]->con_x",k);
								return(NULL);
							}
							if ( !(parent1[k]->con_y = realloc(parent1[k]->con_y,
										parent1[k]->num_con*sizeof(float)) ))
							{
								syslog(LOG_CRIT,"Error realloc parent1[%d]->con_y",k);
								return(NULL);
							}
							if ( !(parent1[k]->con_w = realloc(parent1[k]->con_w,
									parent1[k]->num_con*sizeof(double)) ))
							{
								syslog(LOG_CRIT,"Error realloc parent1[%d]->con_w",k);
								return(NULL);
							}
							if ( !(parent1[k]->age = realloc(parent1[k]->age,
									parent1[k]->num_con*sizeof(int)) ))
							{
								syslog(LOG_CRIT,"Error realloc parent1[%d]->age",k);
								return(NULL);
							}
							if ( parent1[k]->momentum == 1)		//delta_con_w;
							{
								if ( !(parent1[k]->delta_con_w = realloc(parent1[k]->delta_con_w,
										parent1[k]->num_con*sizeof(double)) ))
								{
									syslog(LOG_CRIT,"Error realloc parent1[%d]->delta_con_w",k);
									return(NULL);
								}
							}
						}
						*(parent1[k]->con_x + parent1[k]->num_con - 1) = parent1[l]->x_c;
						*(parent1[k]->con_y + parent1[k]->num_con - 1) = parent1[l]->y_c;
						*(parent1[k]->con_w + parent1[k]->num_con - 1) = rand_gen(l);
						*(parent1[k]->age + parent1[k]->num_con - 1) = 0;
						if (parent1[k]->momentum == 1)
						{
							*(parent1[k]->delta_con_w + parent1[k]->num_con - 1) = 0;
						}
					}
				}
			}
		}
		*(new_num_neuron) = num_neuron;
		sort_neuron_array(num_neuron, parent1);
	}
	else
	{
		*(new_num_neuron) = num_neuron1;
	}
	
	for (k=0; k< *new_num_neuron; k++)
	{
		sort_neuron_connections(parent1[k]);
	}
	
	return(parent1);
}
