/*  load_nn_config.c */

/* 	Copyright 2004-2005 Oswaldo Morizaki */

/* 	This file is part of ga-nn-ag.

    ga-nn-ag is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    ga-nn-ag is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with ga-nn-ag; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "my_header.h"
#include "aux_prot.h"

int load_nn_config(struct nn_config *conf, const char * filename)
{
	FILE * file_pointer;
	if ((file_pointer=fopen(filename,"r")) == NULL)
	{
		return(-1);
	}
	while(!feof(file_pointer))
	{
		fgets(char_buffer,BUFFSIZE,file_pointer);

		if (!strncmp(char_buffer,"num_pat",7))
		{
			conf->num_pat=atoi(char_buffer+8);
		}
		else if (!strncmp(char_buffer,"num_input",9))
		{
			conf->num_input=atoi(char_buffer+10);
		}
		else if (!strncmp(char_buffer,"num_output",10))
		{
			conf->num_output=atoi(char_buffer+11);
		}
		else if (!strncmp(char_buffer,"mode",4))
		{
			conf->mode=atoi(char_buffer+5);
		}
		else if (!strncmp(char_buffer,"age_inf",7))
		{
			conf->age_inf=atof(char_buffer+8);
		}
		else if (!strncmp(char_buffer,"input_preffix",13))
		{
			clean_char_buffer(char_buffer);
			strcpy(conf->input_preffix,char_buffer+14);
		}
		else if (!strncmp(char_buffer,"output_preffix",14))
		{
			clean_char_buffer(char_buffer);
			strcpy(conf->output_preffix,char_buffer+15);
		}
	}
	fclose(file_pointer);
	return(1);
}
