/*  dwrite_neural_net.c */

/* 	Copyright 2004-2005 Oswaldo Morizaki */

/* 	This file is part of ga-nn-ag.

    ga-nn-ag is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    ga-nn-ag is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with ga-nn-ag; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "my_header.h"
#include "aux_prot.h"


int dwrite_neural_net(struct neural_net * net, int descriptor)
{
	int k,l,m;
	int num_con;
	int num_neuron;
	
	char char_temp[BUFFSIZE];
	
	num_neuron = net->num_neuron;
	
	sprintf(char_buffer,"neural_net\0");
	writen(descriptor,char_buffer,BUFFSIZE);
	sprintf(char_buffer,"num_neuron=%d\0",net->num_neuron);
	writen(descriptor,char_buffer,BUFFSIZE);
	sprintf(char_buffer,"num_input=%d\0",net->num_input);
	writen(descriptor,char_buffer,BUFFSIZE);
	sprintf(char_buffer,"num_output=%d\0",net->num_output);
	writen(descriptor,char_buffer,BUFFSIZE);
	sprintf(char_buffer,"age=%d\0",net->age);
	writen(descriptor,char_buffer,BUFFSIZE);
	sprintf(char_buffer,"dimension=%d\0",net->dimension);
	writen(descriptor,char_buffer,BUFFSIZE);
	sprintf(char_buffer,"type=%d\0",net->type);
	writen(descriptor,char_buffer,BUFFSIZE);

	for (k=0;k<num_neuron; k++)
	{
		sprintf(char_buffer,"neuron %d\0",k);
		writen(descriptor,char_buffer,BUFFSIZE);

		sprintf(char_buffer,"conv_rate=%f\0",net->neuron_array[k]->conv_rate);	
		writen(descriptor,char_buffer,BUFFSIZE);

		sprintf(char_buffer,"bias=%f\0",net->neuron_array[k]->bias);	
		writen(descriptor,char_buffer,BUFFSIZE);

		sprintf(char_buffer,"decayment=%f\0",net->neuron_array[k]->decayment);	
		writen(descriptor,char_buffer,BUFFSIZE);

		sprintf(char_buffer,"block=%d\0",net->neuron_array[k]->block);	
		writen(descriptor,char_buffer,BUFFSIZE);

		sprintf(char_buffer,"bias_corr=%d\0",net->neuron_array[k]->bias_corr);	
		writen(descriptor,char_buffer,BUFFSIZE);
		
		sprintf(char_buffer,"delta_type=%d\0",net->neuron_array[k]->delta_type);	
		writen(descriptor,char_buffer,BUFFSIZE);

		sprintf(char_buffer,"delta_inf=%f\0",net->neuron_array[k]->delta_inf);	
		writen(descriptor,char_buffer,BUFFSIZE);

		sprintf(char_buffer,"delta_disp=%f\0",net->neuron_array[k]->delta_disp);	
		writen(descriptor,char_buffer,BUFFSIZE);

		sprintf(char_buffer,"momentum=%d\0",net->neuron_array[k]->momentum);	
		writen(descriptor,char_buffer,BUFFSIZE);

		sprintf(char_buffer,"dimension=%d\0",net->neuron_array[k]->dimension);	
		writen(descriptor,char_buffer,BUFFSIZE);

		num_con = net->neuron_array[k]->num_con;
		sprintf(char_buffer,"num_con=%d\0",num_con);	
		writen(descriptor,char_buffer,BUFFSIZE);

		sprintf(char_buffer,"range=%1.5f",*(net->neuron_array[k]->range));	
		for (l=1; l< net->dimension; l++)
		{
			sprintf(char_temp,":%1.5f",net->neuron_array[k]->range[l]);	
			strcat(char_buffer, char_temp);
		}
		sprintf(char_temp,"\0");
		strcat(char_buffer, char_temp);
		writen(descriptor,char_buffer,BUFFSIZE);
		
		sprintf(char_buffer,"x_c=%1.5f",*(net->neuron_array[k]->x_c));	
		for (l=1; l< net->dimension; l++)
		{
			sprintf(char_temp,":%1.5f",net->neuron_array[k]->x_c[l]);
			strcat(char_buffer, char_temp);
		}
		sprintf(char_temp,"\0");
		strcat(char_buffer, char_temp);
		writen(descriptor,char_buffer,BUFFSIZE);

		if (net->neuron_array[k]->momentum > 0)
		{
			sprintf(char_buffer,"alpha=%1.5f",*(net->neuron_array[k]->alpha));	
			for (l=1; l< net->neuron_array[k]->momentum; l++)
			{
				sprintf(char_temp,":%1.5f",net->neuron_array[k]->alpha[l]);	
				strcat(char_buffer, char_temp);
			}
			sprintf(char_temp,"\0");
			strcat(char_buffer, char_temp);
		}
		else
		{
			sprintf(char_buffer,"alpha=NULL\0");	
		}
		writen(descriptor,char_buffer,BUFFSIZE);

		/* Connection order : age:weight:con_x[0]:... */
		for (l= 0; l< num_con; l++)
		{
			sprintf(char_buffer,"con=%d",net->neuron_array[k]->con[l]->age);
			sprintf(char_temp,":%1.5f",net->neuron_array[k]->con[l]->weight);
			strcat(char_buffer,char_temp);
			
			for (m=0; m< net->dimension; m++)
			{
				sprintf(char_temp,":%1.5f",net->neuron_array[k]->con[l]->con_x[m]);	
				strcat(char_buffer, char_temp);
			}
			sprintf(char_temp,"\0");
			strcat(char_buffer, char_temp);
			writen(descriptor,char_buffer,BUFFSIZE);;
		}
	}
	sprintf(char_buffer,"END\0");	
	writen(descriptor,char_buffer,BUFFSIZE);
	return(0);
}
