/*  calloc_neuron.c */
/* 	Copyright 2004 Oswaldo Morizaki */
/* 	This file is part of ga-nn-ag 

    ga-nn-ag is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    ga-nn-ag is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with ga-nn-ag; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
/*
	Allocate one neuron, cast to (struct neuron *)
*/

#include "my_header.h"
#include "aux_prot.h"

void * calloc_neuron(int dimension, int momentum, int num_con)
{
	int k,l;
	struct neuron * neuron1;
	
	if (!(neuron1 = (struct neuron *)calloc(1,sizeof(struct neuron)) ))
	{
		syslog(LOG_CRIT,"Error calloc neuron in calloc_neuron()");
		return(NULL);
	}
	
	neuron1->dimension = dimension;
	neuron1->momentum = momentum;
	neuron1->num_con = num_con;
	
	if (!(neuron1->range = (float *)calloc(dimension,sizeof(float)) ))
	{
		syslog(LOG_CRIT,"Error calloc neuron->range in calloc_neuron()");
		free(neuron1);
		return(NULL);
	}
	if (!(neuron1->x_c = (float *)calloc(dimension,sizeof(float)) ))
	{
		syslog(LOG_CRIT,"Error calloc neuron->x_c in calloc_neuron()");
		free(neuron1->range);
		free(neuron1);
		return(NULL);
	}
	
	if (momentum >0)
	{
		if (!(neuron1->alpha = (float *)calloc(momentum,sizeof(float)) ))
		{
			syslog(LOG_CRIT,"Error calloc neuron->alpha in calloc_neuron()");
			free(neuron1->range);
			free(neuron1->x_c);
			free(neuron1);
			return(NULL);
		}
	}
	else 
	{
		neuron1->alpha = NULL;
	}
	
	if (num_con > 0)
	{
		if (!(neuron1->con = (struct connection **)calloc(num_con,sizeof(struct connection *)) ))
		{
			syslog(LOG_CRIT,"Error calloc neuron->con in calloc_neuron()");
			free(neuron1->range);
			free(neuron1->x_c);
			if (momentum >0)
			{
			 free(neuron1->alpha);
			}
			free(neuron1);
			return(NULL);
		}
		
		for (k=0; k< num_con; k++)
		{
			if (!(neuron1->con[k] = (struct connection *)calloc_connection(dimension, momentum) ))
			{
				free(neuron1->range);
				free(neuron1->x_c);
				if (momentum >0)
				{
				 free(neuron1->alpha);
				}
				for (l=0; l< k-1; l++)
				{
					free(neuron1->con[k]);
				}
				free(neuron1->con);
				free(neuron1);
				return(NULL);
			}
		}
	}
	else
	{
		neuron1->con = NULL;
	}
	
	return(neuron1);
}
