/*  sort_neuron_connections.c */

/* 	Copyright 2004 Oswaldo Morizaki */

/* 	This file is part of ga-nn-ag.

    ga-nn-ag is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    ga-nn-ag is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with ga-nn-ag; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "my_header.h"
#include "aux_prot.h"

int sort_neuron_connections(struct neuron * neuron1)
{
	int k,l,m,n;
	int dimension;
	int momentum;
	int equal;
	int number;
	float * max_con_x;
	struct connection * temp_con;
	ga_errno = 0;
	
	if ( neuron1->num_con == 0 )
	{
		return(1);
	}
	
	dimension = neuron1->dimension;
	momentum = neuron1->momentum;
	
	if (!(temp_con = (struct connection *)calloc_connection(dimension, momentum) ))
	{
		ga_errno = 1;
		return(-1);
	}

	if (!(max_con_x = (float *)calloc(dimension, sizeof(float)) ))
	{
		ga_errno = 1;
		return(-2);
	}
	
	for (k = neuron1->num_con; k ; k--)
	{
		/* Initialization */
		number = 0;
		equal = 0;
		for (l=0; l< dimension; l++)
		{
			*(max_con_x+l) = -1; //so always number is set
		}
		for (l=0; l< k; l++)
		{
			for (m = 0; m< dimension; m++)
			{
				if (max_con_x[m] == neuron1->con[l]->con_x[m])
				{
					equal += 1;
				}
				if (max_con_x[m] < neuron1->con[l]->con_x[m])
				{
					if (equal == m)
					{
						for (n=0; n< dimension; n++)
						{
							max_con_x[n] = neuron1->con[l]->con_x[n];
							number = l;
						}
						break;
					}
				}
			}
		}
		
		/* copy to temp_con */
		for (n = 0; n< dimension; n++)
		{
			temp_con->con_x[n] = neuron1->con[k-1]->con_x[n];
		}
		if (momentum >0)
		{
			for (n = 0; n< momentum; n++)
			{
				temp_con->delta_weight[n] = neuron1->con[k-1]->delta_weight[n];
			}
		}
		temp_con->age = neuron1->con[k-1]->age;
		temp_con->weight = neuron1->con[k-1]->weight;
		
		/* copy new last connection to last position */
		for (n = 0; n< dimension; n++)
		{
			neuron1->con[k-1]->con_x[n] = neuron1->con[number]->con_x[n];
		}
		if (momentum >0)
		{
			for (n = 0; n< momentum; n++)
			{
				neuron1->con[k-1]->delta_weight[n] = neuron1->con[number]->delta_weight[n];
			}
		}
		neuron1->con[k-1]->age = neuron1->con[number]->age;
		neuron1->con[k-1]->weight = neuron1->con[number]->weight;

		/* Restore temp_con to position "number" */
		for (n = 0; n< dimension; n++)
		{
			neuron1->con[number]->con_x[n] = temp_con->con_x[n];
		}
		if (momentum >0)
		{
			for (n = 0; n< momentum; n++)
			{
				neuron1->con[number]->delta_weight[n] = temp_con->delta_weight[n];
			}
		}
		neuron1->con[number]->age = temp_con->age;
		neuron1->con[number]->weight = temp_con->weight;
		
	}
	
	free(temp_con);
	free(max_con_x);
	return(0);	
}
