/*  nn_init_generator.c */
/* 	Copyright 2004-2005 Oswaldo Morizaki */

/* 	This file is part of ga-nn-ag.

    ga-nn-ag is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    ga-nn-ag is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with ga-nn-ag; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "my_header.h"
#include "aux_prot.h"


/*
argc=variable
argv=name init_file dimension momentum alpha conv_rate bias_corr delta_type bias num1 num2 ...

One type of ordering:
	-	Neurons in layer should be in any order (random generated coordinates), a chaotic mesh 
	
Maybe a less chaotic scheme is tested in the future (employing line-code branch)

*/

int main(int argc, char * argv[])
{
	int k,l,m;
	int num_neuron = 0;
	int num_layer;
	int counter;
	int momentum;
	int dimension;
	int num_con;
	
	float range;
	float temp;

	int * num_elem_layer;
			
	struct neural_net * net;
	struct neural_net * result_net;
	struct neural_net * append_net;
		
	char char_temp[BUFFSIZE];
	
	if (argc < 11)
	{
		printf("Too few arguments\nUsage: %s ",argv[0]);
		printf("init_file dimension momentum alpha conv_rate bias_corr delta_type bias decayment num1 num2 ...\n");
		return(1);
	}
	
	openlog("nn_init_gen",LOG_PID,LOG_LOCAL3);
	
	dimension = atoi(argv[2]);
	if (dimension > 40)
	{
		printf("Dimension too high, limit below 40\n");
		return(1);
	}
		
	num_layer=argc-10;
	
	if (!(num_elem_layer = (int *)calloc(num_layer,sizeof(int)) ))
	{
		ga_errno = 1;
		syslog(LOG_INFO,"Error calloc num_elem_layer");
		return(1);
	}
	
	for(k=10; k<argc; k++)
	{
		*(num_elem_layer+k-10)=atoi(argv[k]);
		num_neuron += *(num_elem_layer+k-10);
	}

	syslog(LOG_INFO,"num_layer: %d num_neuron: %d",num_layer,num_neuron);
	

	/* Memory allocation for net */
	if (!(net = (struct neural_net *)calloc(1,sizeof(struct neural_net)) ))
	{
		ga_errno = 1;
		syslog(LOG_INFO,"Error calloc net");
		return(1);
	}	

	if (!(net->neuron_array = (struct neuron **)calloc(num_neuron,sizeof(struct neuron *)) ))
	{
		ga_errno = 1;
		syslog(LOG_INFO,"Error calloc net->neuron_array");
		return(1);
	}	

	net->dimension = dimension;
	net->num_neuron = num_neuron;
	
	for (k= 0; k< num_neuron; k++)
	{
		if ( !strncmp(argv[3],"rr",2) )
		{
			momentum = dice_toss(k,MAX_MOMENTUM);
		}
		else
		{
			momentum = atoi(argv[3]);
		}
		if ( !(*(net->neuron_array+k) = (struct neuron *)calloc_neuron(dimension,momentum,0) ))
		{
			ga_errno = 1;
			syslog(LOG_CRIT,"Error calloc_neuron %d",k);
			return(1);
		}
		net->neuron_array[k]->momentum = momentum;
	}
	

	/* Start setting coordinates */
	/* First, the easy ones */
	
	range=1.0/(num_layer-1);
	temp = 0.0;
	l=0;
	m=0;
	for (k=0 ; k< num_neuron; k++)
	{
		if (m == num_elem_layer[l])
		{
			temp += range;
			l += 1;
			m = 0;
		}
		net->neuron_array[k]->x_c[0] = temp;
		net->neuron_array[k]->range[0] = range;
		m += 1;
	}



	/* The hard part */

	for (k=0 ; k< num_neuron; k++)
	{
		for (l= 1; l< dimension; l++)
		{
			temp = rand_gen(l);
			net->neuron_array[k]->x_c[l] = temp; //set coordinates
			net->neuron_array[k]->range[l] = (temp > 0.5) ? (rand_gen(l) / 2) : 
																				( temp*rand_gen(l) ) ; //set range
		}

		for (l= 0; l< net->neuron_array[k]->momentum; l++) //alpha
		{
			if ( strncmp(argv[4],"rr",2) )
			{
				temp = rand_gen(l)*atof(argv[4]);
			}
			else
			{
				temp = rand_gen(l);
			}
			net->neuron_array[k]->alpha[l] = temp;
		}
		
		if ( strncmp(argv[5],"rr",2) ) //set conv_rate
		{
			temp = atof(argv[5]);
		}
		else
		{
			temp = rand_gen(k);
		}
		net->neuron_array[k]->conv_rate = temp;
		
		if ( strncmp(argv[6],"rr",2) ) //set bias_corr
		{
			l = atoi(argv[6]);
		}
		else
		{
			l = coin_toss(k);
		}
		net->neuron_array[k]->bias_corr = l;

		if ( strncmp(argv[7],"rr",2) ) //set delta_type
		{
			l = atoi(argv[7]);
		}
		else
		{
			l = dice_toss(k,NUM_TYPE);
		}
		net->neuron_array[k]->delta_type = l;
		
		if ( strncmp(argv[8],"rr",2) ) //set bias
		{
			temp = atof(argv[8]);
		}
		else
		{
			temp = rand_gen(k);
		}
		net->neuron_array[k]->bias = temp;
		
		if ( strncmp(argv[9],"rr",2) ) //set decayment
		{
			temp = atof(argv[9]);
		}
		else
		{
			temp = rand_gen(k);
		}
		net->neuron_array[k]->decayment = temp;
	}
	

	/* For the result net */
	/* Memory allocation for result_net */
	if (!(result_net = (struct neural_net *)calloc(1,sizeof(struct neural_net)) ))
	{
		ga_errno = 1;
		syslog(LOG_INFO,"Error calloc net");
		return(1);
	}	

	if (!(result_net->neuron_array = (struct neuron **)calloc(
																		*num_elem_layer,sizeof(struct neuron *)) ))
	{
		ga_errno = 1;
		syslog(LOG_INFO,"Error calloc result_net->neuron_array");
		return(1);
	}	

	result_net->dimension = dimension;
	result_net->num_neuron = *num_elem_layer;
	
	for (k=0 ; k< *num_elem_layer; k++)
	{
		if (!(result_net->neuron_array[k] = calloc_neuron
					(dimension,net->neuron_array[k]->momentum,0) ))
		{
			ga_errno = 1;
			syslog(LOG_INFO,"Error calloc result_net->neuron_array[%d]",k);
			return(1);
		}
		copy_neuron(net->neuron_array[k],result_net->neuron_array[k]);
	}
	
	
	/* For the append_net */
	if (!(append_net = (struct neural_net *)calloc(1,sizeof(struct neural_net)) ))
	{
		ga_errno = 1;
		syslog(LOG_INFO,"Error calloc net");
		return(1);
	}	

	if (!(append_net->neuron_array = (struct neuron **)calloc(1,sizeof(struct neuron *)) ))
	{
		ga_errno = 1;
		syslog(LOG_INFO,"Error calloc append_net->neuron_array");
		return(1);
	}	
	
	append_net->dimension = dimension;
	append_net->num_neuron = 1;
	
	for (k = *num_elem_layer; k< num_neuron; k++)
	{
		if (!(append_net->neuron_array[0] = calloc_neuron
					(dimension,net->neuron_array[k]->momentum,0) ))
		{
			ga_errno = 1;
			syslog(LOG_INFO,"Error calloc append_net->neuron_array[0]");
			return(1);
		}
		copy_neuron(net->neuron_array[k],*(append_net->neuron_array) );
		append_net->neuron_array[0]->inner = 4;
		
		result_net = (struct neural_net *)append_neuron(result_net,append_net);
		
		free_neuron( *(append_net->neuron_array) );
	}



	fwrite_neural_net(result_net, argv[1]);			
	/*----------------------------------*/	
			
	exit(0);
}
