/*  fwrite_neural_net.c */

/* 	Copyright 2004-2005 Oswaldo Morizaki */

/* 	This file is part of ga-nn-ag.

    ga-nn-ag is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    ga-nn-ag is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with ga-nn-ag; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "my_header.h"
#include "aux_prot.h"

int fwrite_neural_net(struct neural_net * net,	const char *filename)
{
	FILE * file_ptr;
	int k,l,m;
	int num_con;
	int num_neuron;
	
	
	char char_temp[BUFFSIZE];
	
	num_neuron = net->num_neuron;
	
	unlink(filename);
	
	if( (file_ptr=fopen(filename,"w")) == NULL)
	{
		syslog(LOG_CRIT,"Couldn't open %s: &s",filename,strerror(errno));
		return(-1);
	}
	
	sprintf(char_buffer,"neural_net\n");
	fputs(char_buffer,file_ptr);
	sprintf(char_buffer,"num_neuron=%d\n",net->num_neuron);
	fputs(char_buffer,file_ptr);
	sprintf(char_buffer,"age=%d\n",net->age);
	fputs(char_buffer,file_ptr);
	sprintf(char_buffer,"dimension=%d\n",net->dimension);
	fputs(char_buffer,file_ptr);
	putc('\n',file_ptr);

	for (k=0;k<num_neuron; k++)
	{
		sprintf(char_buffer,"neuron %d\n",k);
		fputs(char_buffer,file_ptr);

		sprintf(char_buffer,"conv_rate=%f\n",net->neuron_array[k]->conv_rate);	
		fputs(char_buffer,file_ptr);

		sprintf(char_buffer,"bias=%f\n",net->neuron_array[k]->bias);	
		fputs(char_buffer,file_ptr);

		sprintf(char_buffer,"decayment=%f\n",net->neuron_array[k]->decayment);	
		fputs(char_buffer,file_ptr);

		sprintf(char_buffer,"block=%d\n",net->neuron_array[k]->block);	
		fputs(char_buffer,file_ptr);

		sprintf(char_buffer,"bias_corr=%d\n",net->neuron_array[k]->bias_corr);	
		fputs(char_buffer,file_ptr);
		
		sprintf(char_buffer,"delta_type=%d\n",net->neuron_array[k]->delta_type);	
		fputs(char_buffer,file_ptr);

		sprintf(char_buffer,"momentum=%d\n",net->neuron_array[k]->momentum);	
		fputs(char_buffer,file_ptr);

		sprintf(char_buffer,"dimension=%d\n",net->neuron_array[k]->dimension);	
		fputs(char_buffer,file_ptr);

		num_con = net->neuron_array[k]->num_con;
		sprintf(char_buffer,"num_con=%d\n",num_con);	
		fputs(char_buffer,file_ptr);

		sprintf(char_buffer,"range=%1.5f",*(net->neuron_array[k]->range));	
		for (l=1; l< net->dimension; l++)
		{
			sprintf(char_temp,":%1.5f",net->neuron_array[k]->range[l]);	
			strcat(char_buffer, char_temp);
		}
		sprintf(char_temp,"\n");
		strcat(char_buffer, char_temp);
		fputs(char_buffer,file_ptr);
		
		sprintf(char_buffer,"x_c=%1.5f",*(net->neuron_array[k]->x_c));	
		for (l=1; l< net->dimension; l++)
		{
			sprintf(char_temp,":%1.5f",net->neuron_array[k]->x_c[l]);
			strcat(char_buffer, char_temp);
		}
		sprintf(char_temp,"\n");
		strcat(char_buffer, char_temp);
		fputs(char_buffer,file_ptr);

		if (net->neuron_array[k]->momentum > 0)
		{
			sprintf(char_buffer,"alpha=%1.5f",*(net->neuron_array[k]->alpha));	
			for (l=1; l< net->neuron_array[k]->momentum; l++)
			{
				sprintf(char_temp,":%1.5f",net->neuron_array[k]->alpha[l]);	
				strcat(char_buffer, char_temp);
			}
			sprintf(char_temp,"\n");
			strcat(char_buffer, char_temp);
		}
		else
		{
			sprintf(char_buffer,"alpha=NULL\n");	
		}
		fputs(char_buffer,file_ptr);

		for (l= 0; l< num_con; l++)
		{
			sprintf(char_buffer,"con=%d",net->neuron_array[k]->con[l]->age);
			sprintf(char_temp,":%1.5f",net->neuron_array[k]->con[l]->weight);
			strcat(char_buffer,char_temp);
			
			for (m=0; m< net->dimension; m++)
			{
				sprintf(char_temp,":%1.5f",net->neuron_array[k]->con[l]->con_x[m]);	
				strcat(char_buffer, char_temp);
			}
			sprintf(char_temp,"\n");
			strcat(char_buffer, char_temp);
			
			fputs(char_buffer,file_ptr);
		}
		putc('\n',file_ptr);
	}
	fclose(file_ptr);
	return(1);
}
