/*  va_dread_io_block.c */
/* 	Copyright 2004-2005 Oswaldo Morizaki Hirakata */

/* 	This file is part of ga-nn-ag.

    ga-nn-ag is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    ga-nn-ag is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with ga-nn-ag; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "my_header.h"
#include "aux_prot.h"

/* 
Reads block->char_vector 
Since first input is the block size, io_block first points
to an empty char_vector.
*/

void * va_dread_io_block(struct io_block * block)
{
	int k;
	char char_temp[BUFFSIZE];
	
	struct io_block * temp_block;
	
	/* First see if block is allocated */
	if (block == NULL)
	{
		syslog(LOG_INFO,"block unallocated, block->connfd missing");
		return(block);
	}
	
	if (!(temp_block = (struct io_block *)va_calloc_io_block(0,temp_block) ))
	{
		syslog(LOG_CRIT,"Error va_calloc_io_block() in va_dread_io_block()");
		return(block);
	}
	temp_block->connfd = block->connfd;

	/* Read NUM */	
	if(readn(temp_block->connfd,char_temp,BUFFSIZE) < 0)
	{
		syslog(LOG_CRIT,"Error readn() in va_dwrite_io_block %s",strerror(errno));
		temp_block = (struct io_block *)va_free_io_block(temp_block);
		return(block);
	}
	if (strncmp(char_temp,"NUM",3))
	{
		syslog(LOG_CRIT,"Malformed block, couldn't read NUM");
		temp_block = (struct io_block *)va_free_io_block(temp_block);
		return(block);
	}
	temp_block->num = atoi(char_temp+4); 

	/* Now calloc char_vector */	
	if (!(temp_block = (struct io_block *)va_calloc_io_block(temp_block->num,temp_block) ))
	{
		syslog(LOG_CRIT,"Error va_calloc_io_block() in va_dread_io_block()");
		temp_block->num = 0;
		temp_block = (struct io_block *)va_free_io_block(temp_block);
		return(block);
	}

	/* Read values */	
	sprintf(temp_block->char_vector[0],"NUM=%d\0",temp_block->num);	
	for (k=1; k< temp_block->num; k++)
	{
		if(readn(temp_block->connfd,temp_block->char_vector[k],BUFFSIZE) < 0)
		{
			syslog(LOG_CRIT,"Error readn() in va_dwrite_io_block %s",strerror(errno));
			temp_block = (struct io_block *)va_free_io_block(temp_block);
			return(block);
		}
		if (!strncmp(temp_block->char_vector[k],"NULL",4))
		{
			free(temp_block->char_vector[k]);
			temp_block->char_vector[k] = NULL;
		}
	}
	block = (struct io_block *)va_free_io_block(block);
	return(temp_block);
}
