/*  va_calloc_io_block.c */
/* 	Copyright 2004-2005 Oswaldo Morizaki Hirakata */

/* 	This file is part of ga-nn-ag.

    ga-nn-ag is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    ga-nn-ag is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with ga-nn-ag; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "my_header.h"
#include "aux_prot.h"

/* 
If block = NULL, then calloc from everything.
else, calloc just char_vector, using the block->num value, 
instead of the num value passed in the function call
*/

void * va_calloc_io_block(int num, struct io_block * block)
{
	int k,l;
	
	if (block == NULL)
	{
		if (!(block = (struct io_block *)calloc(1,sizeof(struct io_block)) ))
		{
			syslog(LOG_CRIT,"Error calloc io_block in va_calloc_io_block()");
			return(NULL);
		}
	}

	block->num = num;
	if (block->num == 0)
	{
		block->char_vector = NULL;
	}
	else
	{
		if (!(block->char_vector = (char **)calloc(block->num,sizeof(char *)) ))
		{
			syslog(LOG_CRIT,"Error calloc block->char_vector in va_calloc_io_block()");
			free(block);
			return(NULL);
		}
		for (k =0 ; k< block->num; k++)
		{
			if (!(block->char_vector[k] = (char *)calloc(BUFFSIZE,sizeof(char)) ))
			{
				syslog(LOG_CRIT,"Error calloc block->char_vector[%d] in va_calloc_io_block()",k);
				for (l=0; l< k; l++)
				{
					free(block->char_vector[l]);
				}
				free(block->char_vector);
				free(block);
				return(NULL);
			}
		}
	}
	return(block);
}
