/*  nn_load_input.c */

/* 	Copyright 2004-2005 Oswaldo Morizaki Hirakata */

/* 	This file is part of ga-nn-ag.

    ga-nn-ag is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    ga-nn-ag is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with ga-nn-ag; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "my_header.h"
#include "aux_prot.h"

int nn_load_input(float *input_buffer, int num_elem_input, struct io_connection * con)
{
	int k;
	int type;
	
	type = va_io_connect(con);
	if ((type == 10) || (type == 20))
	{
		sprintf(char_buffer,"PATTERN=%d\0",con->req);
		writen(con->connfd,char_buffer,BUFFSIZE);	
		k = 0;
		while (1)
		{
			readn(con->connfd,char_buffer,BUFFSIZE);
			if ( (strncmp(char_buffer,"END_INPUT",9)))
			{
				if (k < num_elem_input)
				{
					input_buffer[k] = atof(char_buffer);
					k += 1;
				}
				else 
				{
					con->connected = 0;
					close(con->connfd);
					return(2);		//Too many inputs
				}
			}
			else 
			{
				if (k == num_elem_input) //everything is fine
				{
					con->connected = 0;
					close(con->connfd);
					return(0);
				}
				else
				{
					con->connected = 0;
					close(con->connfd);
					return(3);	//Not enough inputs
				}
			}
		}
	}
	else if ((type == 40) || (type == 42))
	{
		k = 0;
		while (1)
		{
			fgets(char_buffer,BUFFSIZE,con->file_ptr);
			if ( (strncmp(char_buffer,"\n",1)) && !(feof(con->file_ptr)) )
			{
				if (k < num_elem_input)
				{
					input_buffer[k] = atof(char_buffer);
					k += 1;
				}
				else 
				{
					fclose(con->file_ptr);
					con->connected = 0;
					return(2);							//Too many inputs
				}
			}
			else if (feof(con->file_ptr))
			{
				if (k == num_elem_input) //everything is fine
				{
					fclose(con->file_ptr);
					con->connected = 0;
					return(0);
				}
				else
				{
					fclose(con->file_ptr);
					con->connected = 0;
					return(3);					//Not enough inputs
				}
			}
		}
	}
	return(-1);
}
