/*  ga_client_load_config.c */
/* 	Copyright 2004-2005 Oswaldo Morizaki Hirakata */

/* 	This file is part of ga-nn-ag.

    ga-nn-ag is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    ga-nn-ag is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with ga-nn-ag; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "my_header.h"
#include "aux_prot.h"

int ga_client_load_config(int argc, char * argv[], struct ga_client_config * conf)
{
	int k;
	/* Loading defaults */
	if (argc == 0)
	{
		conf->client_id = 0;
		conf->max_num_layer = 3;
		conf->max_num_neuron = 30;
		conf->mode = 0;
		conf->fifo_init = 0;
		conf->fifo_result = 0;
		strcpy(conf->server_ip,"127.0.0.1\0");
		strcpy(conf->server_port,"12000\0");
		strcpy(conf->init_preffix,"init\0");
		strcpy(conf->result_preffix,"result\0");
	}
	else if (argc > 0)
	{
		for (k=1; k< argc; k++)
		{
			if (!strncmp(argv[k],"client_id",9))
			{
				conf->client_id = atoi(argv[k]+10);
			}
			else if (!strncmp(argv[k],"mode",4))
			{
				conf->mode = atoi(argv[k]+5);
			}
			else if (!strncmp(argv[k],"server_ip",9))
			{
				strcpy(conf->server_ip,argv[k]+10);
			}
			else if (!strncmp(argv[k],"server_port",11))
			{
				strcpy(conf->server_port,argv[k]+12);
			}
			else if (!strncmp(argv[k],"init_preffix",12))
			{
				strcpy(conf->init_preffix,argv[k]+13);
				if (!strncmp(conf->init_preffix,"fifo",4))
				{
					conf->fifo_init = 1;
				}
			}
			else if (!strncmp(argv[k],"result_preffix",14))
			{
				strcpy(conf->result_preffix,argv[k]+15);
				if (!strncmp(conf->result_preffix,"fifo",4))
				{
					conf->fifo_result = 1;
				}
			}
		}
	}
	return(0);
}
