/*  weight_update.c */

/* 	Copyright 2004-2005 Oswaldo Morizaki */

/* 	This file is part of ga-nn-ag.

    ga-nn-ag is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    ga-nn-ag is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with ga-nn-ag; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "my_header.h"
#include "aux_prot.h"

/* Require nan revision */

int weight_update(struct neural_net * net, int num_elem_input, struct nn_config * conf)
{
	int k,l,m;
	int num_neuron;
	int number;
	
	double temp1;
	double temp2;
	
	num_neuron = net->num_neuron;
	
	if (net->type == 0)
	{
		for (k=num_neuron-1; k>=num_elem_input; k--)
		{
			if (net->neuron_array[k]->bias_corr == 1)
			{
				net->neuron_array[k]->bias += net->neuron_array[k]->delta*
																			net->neuron_array[k]->conv_rate;
				if (isnan(net->neuron_array[k]->bias))
				{
					syslog(LOG_INFO,"net->neuron_array[%d]->bias=NAN",k);
				}
			}

/* Threshold value to control weight*/

/*
			temp1=(net->neuron_array[k]->conv_rate)*(net->neuron_array[k]->delta)*
							(1-threshold(1,(abs(net->neuron_array[k]->delta) +
															net->neuron_array[k]->delta_disp) * 
															net->neuron_array[k]->delta_inf)); 
*/
			temp1=(net->neuron_array[k]->conv_rate)*(net->neuron_array[k]->delta) * 
						exp(-pow(net->neuron_array[k]->delta,2));

			
			for(l = 0; l< num_neuron; l++) 
			{
				if ((is_above(net->neuron_array[k],net->neuron_array[l], NULL) == 0) && 
						(is_connected(net->neuron_array[l],net->neuron_array[k], &number)> 0) )
				{
					temp2 = temp1*(net->neuron_array[l]->value)
									*exp(-(net->neuron_array[k]->con[number]->age*conf->age_inf));
									
					if (net->neuron_array[k]->momentum > 0)
					{
						for (m=0; m< net->neuron_array[k]->momentum; m++)
						{
							temp2 += net->neuron_array[k]->alpha[m]*
												net->neuron_array[k]->con[number]->delta_weight[m]*
												exp(-pow(net->neuron_array[k]->con[number]->delta_weight[m],2));
						}
						
						for (m=net->neuron_array[k]->momentum-1; m > 0 ; m--)
						{
							net->neuron_array[k]->con[number]->delta_weight[m] = 
												net->neuron_array[k]->con[number]->delta_weight[m-1];
						}
						net->neuron_array[k]->con[number]->delta_weight[0] = temp2;
					}
					
					net->neuron_array[k]->con[number]->weight += temp2;
					
//					syslog(LOG_INFO,"net->neuron_array[%d]->con[%d]->weight=%f temp2=%f",k,number,net->neuron_array[k]->con[number]->weight,temp2);
					
					
					if ( isnan(net->neuron_array[k]->con[number]->weight))
					{
						syslog(LOG_INFO,"net->neuron_array[%d]->con[%d]->weight=NAN",k,number);
					}
				}
			}
		}
	}
	else if (net->type == 1) //Uses p_value instead of value
	{
		for (k=num_neuron-1; k>=num_elem_input; k--)
		{
			if (net->neuron_array[k]->bias_corr == 1)
			{
				net->neuron_array[k]->bias += net->neuron_array[k]->delta*
																			net->neuron_array[k]->conv_rate;
			}
/*
			temp1=(net->neuron_array[k]->conv_rate)*(net->neuron_array[k]->delta) *
									(1-threshold(1,(abs(net->neuron_array[k]->delta) +
															net->neuron_array[k]->delta_disp) * 
															net->neuron_array[k]->delta_inf)); 
*/
			temp1=(net->neuron_array[k]->conv_rate)*(net->neuron_array[k]->delta) * 
						exp(-pow(net->neuron_array[k]->delta,2));
						
			for(l = 0; l< num_neuron; l++) 
			{
				if ((is_above(net->neuron_array[k],net->neuron_array[l], NULL) == 0) && 
						(is_connected(net->neuron_array[l],net->neuron_array[k], &number)> 0) )
				{
					temp2 = temp1*(net->neuron_array[l]->p_value)
									*exp(-(net->neuron_array[k]->con[number]->age*conf->age_inf));
									
					if (net->neuron_array[k]->momentum > 0)
					{
						for (m=0; m< net->neuron_array[k]->momentum; m++)
						{
							temp2 += net->neuron_array[k]->alpha[m]*
												net->neuron_array[k]->con[number]->delta_weight[m]*
												exp(-pow(net->neuron_array[k]->con[number]->delta_weight[m],2));
						}
						
						for (m=net->neuron_array[k]->momentum-1; m > 0 ; m--)
						{
							net->neuron_array[k]->con[number]->delta_weight[m] = 
												net->neuron_array[k]->con[number]->delta_weight[m-1];
						}
						net->neuron_array[k]->con[number]->delta_weight[0] = temp2;
					}
					net->neuron_array[k]->con[number]->weight += temp2;
					if ( isnan(net->neuron_array[k]->con[number]->weight))
					{
						syslog(LOG_INFO,"net->neuron_array[%d]->con[%d]->weight=NAN",k,number);
					}
				}
			}
		}
	}
	return 1;
}
