/*  nn.c */
/* 	Copyright 2004-2005 Oswaldo Morizaki */

/* 	This file is part of ga-nn-ag.

    ga-nn-ag is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    ga-nn-ag is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with ga-nn-ag; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "my_header.h"
#include "aux_prot.h"

/*****************************************/
/*
argc=4
argv=name conf_file neuron_array_init neuron_array_result


0 = production slave (test mode for ga_client)
1 = training
2 = production

*/
/*****************************************/


int main(int argc, char * argv[])
{
int k,l,m;
int num_neuron;
int num_pat;
int num_input;
int num_output;
int mode;
int descriptor;
int counter;

float * input_buffer;
float * output_buffer;

char char_buffer[BUFFSIZE];
char input_preffix[BUFFSIZE];
char output_preffix[BUFFSIZE];

struct nn_config conf;
struct neural_net * net;

float error,max_error;
float age_inf;

if (argc < 3)
{
	printf("Incorrect number of parameters\n");
	printf("For train / slave mode use:\n");
	printf("%s config_file neuron_array_init neuron_array_result\n\n",argv[0]);
	printf("For production use:\n");
	printf("%s config_file neuron_array_init\n",argv[0]);

	return(1);
}

openlog("nn_exec",LOG_PID,LOG_LOCAL2);

if (load_nn_config(&conf,argv[1])<0)
{
	syslog(LOG_CRIT,"Error load config file: %s",strerror(errno));
	return(1);
}

num_pat=conf.num_pat;
num_input=conf.num_input;
num_output=conf.num_output;
mode = conf.mode;
age_inf = conf.age_inf;

if ((argc == 3) && (mode != 2))
{
	printf("Incorrect number of parameters\nFor production use:\n");
	printf("%s config_file neuron_array_init\n",argv[0]);
	return(1);
}

syslog(LOG_INFO,"num_pat=%d num_input=%d num_output=%d mode=%d age_inf=%f",
				num_pat,num_input,num_output,conf.mode,age_inf);
syslog(LOG_INFO,"input_preffix=%s output_preffix=%s",conf.input_preffix,conf.output_preffix);


if (! (input_buffer=(float *)calloc(num_input,sizeof(float)) ))
{
	syslog(LOG_CRIT,"Error calloc input_buffer");
	return(1);
}

if (! (output_buffer=(float *)calloc(num_output,sizeof(float)) ))
{
	syslog(LOG_CRIT,"Error calloc output_buffer");
	return(1);
}

net = NULL;

/* Reading neural_net */
if (!(net = (struct neural_net *)fread_neural_net(net,argv[2]) ))
{
	syslog(LOG_CRIT,"Error in fread_neural_net in nn_exec");
	return(1);
}
num_neuron = net->num_neuron;


/* Sorting neural_net */
sort_neuron_array(net);
for (k=0; k< num_neuron; k++)
{
	sort_neuron_connections(net->neuron_array[k]);
/*	
	for (l=0 ; l< net->neuron_array[k]->num_con; l++)
	{
		syslog(LOG_INFO,"net->neuron_array[%d]->con[%d]->weight=%f",k,l,net->neuron_array[k]->con[l]->weight);
	}
*/	
}


if (mode == 0)
{
	if( (descriptor=open(argv[3],O_WRONLY, 0)) <0)
	{
		syslog(LOG_CRIT,"Error openning %s: %s",argv[3],strerror(errno));
		return(1);
	}
}

counter = 0;
if (net->type == 1)
{
	while(1) // Propagate until get output in the last neuron
	{
		sprintf(char_buffer,"%s%d",conf.input_preffix,counter);
		
		if (load_input(input_buffer,num_input,char_buffer) != 0)
		{
			syslog(LOG_CRIT,"Error load_input() %d: %s",counter,strerror(errno));
			if (mode == 0)
			{
				close(descriptor);
			}
			return(1);
		}
		counter += 1;

		for (l=0; l<num_input; l++)
		{
			net->neuron_array[l]->value = input_buffer[l];
		}
		if (forward_propagation(net,num_input) == 1)
		{
			break;
		}
	}
}		

for (k=counter; k<num_pat; k++)
{
	sprintf(char_buffer,"%s%d",conf.input_preffix,k);
	if (load_input(input_buffer,num_input,char_buffer) != 0)
	{
		syslog(LOG_CRIT,"Error load_input() %d: %s",k,strerror(errno));
		if (mode == 0)
		{
			close(descriptor);
		}
		return(1);
	}
	
	for (l=0; l<num_input; l++)
	{
		net->neuron_array[l]->value = input_buffer[l];
	}
	
	sprintf(char_buffer,"%s%d",conf.output_preffix,(k-counter));
	if (load_output(output_buffer,num_output,char_buffer) <0)
	{
		syslog(LOG_CRIT,"Error load_output() %d: %s",(k-counter),strerror(errno));
		if (mode == 0)
		{
			close(descriptor);
		}
		return(1);
	}

	forward_propagation(net,num_input);
	error=output_layer_error(net,num_output,output_buffer);
	syslog(LOG_INFO,"pattern=%d error=%f",k,error);
	
	if (mode == 0) // mode 1 = test slave mode
	{
		sprintf(char_buffer,"error=%f\0",error);
		writen(descriptor,char_buffer,BUFFSIZE);
	}
	else if (mode == 1) //mode 1 = training
	{
		back_propagation(net,num_input);
		weight_update(net,num_input,&conf);
	}
	else if (mode == 2) //mode 2 = production
	{	
		for (l=0; l<num_output; l++)
		{
			syslog(LOG_INFO,"Pattern: %d Output[%d]: %f Desired[%d]: %f\n",k,l,
			net->neuron_array[num_neuron-num_output+l-1]->value,l,output_buffer[l]);
		}
		syslog(LOG_INFO,"Error=%f",error);
	}
}

if (mode == 0)
{
	syslog(LOG_INFO,"Writting to descriptor %d %s",descriptor,argv[3]);
	if(	dwrite_neural_net(net,descriptor)< 0)
	{
		syslog(LOG_CRIT,"Error dwrite_neural_net() %s",strerror(errno));
		return(1);
	}
	close(descriptor);
}
else if (mode == 1)
{
	syslog(LOG_INFO,"Writting to file %s",argv[3]);
	if(	fwrite_neural_net(net,argv[3])< 0)
	{
		syslog(LOG_CRIT,"Error fwrite_neural_net() %s: %s",argv[3],strerror(errno));
		return(1);
	}
}
syslog(LOG_INFO,"***** Exiting *****");

exit(0);
}
