/*  load_output.c */

/* 	Copyright 2004-2005 Oswaldo Morizaki */

/* 	This file is part of ga-nn-ag.

    ga-nn-ag is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    ga-nn-ag is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with ga-nn-ag; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "my_header.h"
#include "aux_prot.h"

int load_output(float *output_buffer, int num_elem_output, const char * filename)
{
	int k;
	FILE * file_pointer;

	if( (file_pointer = fopen(filename,"r")) == NULL)
	{
		return(1);
	}

	k = 0;
	while (1)
	{
		fgets(char_buffer,BUFFSIZE,file_pointer);
		if ( (strncmp(char_buffer,"\n",1)) && !(feof(file_pointer)) )
		{
			if (k < num_elem_output)
			{
				output_buffer[k] = atof(char_buffer);
				output_buffer[k] = (output_buffer[k] > 1.0) ? 1.0 : output_buffer[k];
				k += 1;
			}
			else 
			{
				fclose(file_pointer);
				return(1);							//Too many outputs
			}
		}
		else if (feof(file_pointer))
		{
			if (k == num_elem_output) //everything is fine
			{
				fclose(file_pointer);
				return(0);
			}
			else
			{
				fclose(file_pointer);	//Not enough outputs
				return(3);
			}
		}
	}
}
