/*  fread_neural_net.c */

/* 	Copyright 2004-2005 Oswaldo Morizaki */

/* 	This file is part of ga-nn-ag.

    ga-nn-ag is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    ga-nn-ag is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with ga-nn-ag; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "my_header.h"
#include "aux_prot.h"

/*
net should be NULL
*/

void * fread_neural_net(struct neural_net * net,	const char * filename)
{
	int k,l,m,n,o,p;
	int momentum;
	int dimension;
	int num_neuron;
	int age;
	int type;
	int num_con;
	
	double temp;
	
	FILE * file_pointer;
	
	char char_temp[BUFFSIZE];
	
	struct neuron temp_neuron;
	
	ga_errno = 0;

	if (net != NULL)
	{
		syslog(LOG_CRIT,"Error in fread neural_net: neural_net already asigned");
		return(net);
	}

	
	if( (file_pointer=fopen(filename,"r")) == NULL )
	{
		return(NULL);
	}

	while(!feof(file_pointer))
	{
		fgets(char_buffer,BUFFSIZE,file_pointer);
		if(!strncmp(char_buffer,"neural_net",10))
		{
			fgets(char_buffer,BUFFSIZE,file_pointer);					//num_neuron
			num_neuron = atoi(char_buffer+11);
			fgets(char_buffer,BUFFSIZE,file_pointer);					//age
			age = atoi(char_buffer+4);
			fgets(char_buffer,BUFFSIZE,file_pointer);					//dimension
			dimension = atoi(char_buffer+10);
			fgets(char_buffer,BUFFSIZE,file_pointer);					//type
			type = atoi(char_buffer+5);


			fgets(char_buffer,BUFFSIZE,file_pointer);					//empty line
						
			/* neural net memory allocation */
			if (!(net = (struct neural_net *)calloc(1, sizeof(struct neural_net)) ))
			{
				ga_errno = 1;
				syslog(LOG_CRIT,"Error calloc neural_net in fread_neural_net()");
				return(NULL);
			}
			
			net->num_neuron = num_neuron;
			net->age = age;
			net->dimension = dimension;
			net->type = type;

			if (!(net->neuron_array = (struct neuron **)calloc(num_neuron, sizeof(struct neuron *)) ))
			{
				ga_errno = 1;
				syslog(LOG_CRIT,"Error calloc neural_net->neuron_array in fread_neural_net()");
				free(net);
				return(NULL);
			}

						
			for (k=0; k< num_neuron;k ++)
			{
				fgets(char_buffer,BUFFSIZE,file_pointer);				//neuron number
				if (k != atoi(char_buffer+7) )
				{
					ga_errno = 2;
					syslog(LOG_CRIT,"Malformed neural_net file neuron=%d %s",k,char_buffer);
					free(net->neuron_array);
					free(net);
					return(NULL);
				}
				
				fgets(char_buffer,BUFFSIZE,file_pointer);
				temp_neuron.conv_rate=atof(char_buffer+10);		//conv_rate
				
				fgets(char_buffer,BUFFSIZE,file_pointer);
				temp_neuron.bias=atof(char_buffer+5);					//bias

				fgets(char_buffer,BUFFSIZE,file_pointer);
				temp_neuron.decayment=atof(char_buffer+10);		//decayment
				
				fgets(char_buffer,BUFFSIZE,file_pointer);
				temp_neuron.block=atof(char_buffer+6);				//block

				fgets(char_buffer,BUFFSIZE,file_pointer);
				temp_neuron.bias_corr=atoi(char_buffer+10);		//bias_correction
				
				fgets(char_buffer,BUFFSIZE,file_pointer);
				temp_neuron.delta_type=atoi(char_buffer+11);	//delta_type
				
				fgets(char_buffer,BUFFSIZE,file_pointer);
				temp_neuron.delta_inf=atof(char_buffer+10);	//delta_inf

				fgets(char_buffer,BUFFSIZE,file_pointer);
				temp_neuron.delta_disp=atof(char_buffer+11);	//delta_disp

				fgets(char_buffer,BUFFSIZE,file_pointer);
				temp_neuron.momentum=atoi(char_buffer+9);		//momentum

				fgets(char_buffer,BUFFSIZE,file_pointer);
				temp_neuron.dimension=atoi(char_buffer+10);	//dimension
				
				fgets(char_buffer,BUFFSIZE,file_pointer);
				temp_neuron.num_con=atoi(char_buffer+8); 		//num_con

				if (!(net->neuron_array[k] = (struct neuron *)calloc_neuron(
													temp_neuron.dimension, temp_neuron.momentum, temp_neuron.num_con) ))
				{
					ga_errno = 1;
					syslog(LOG_CRIT,"Error calloc_neuron() in fread_neural_net()");
					return(NULL);
				}
				
				/* Couldn't use copy_neuron(), since temp_neuron doesn't have connections" */
				
				net->neuron_array[k]->dimension = 		temp_neuron.dimension;
				net->neuron_array[k]->conv_rate = 		temp_neuron.conv_rate;
				net->neuron_array[k]->bias_corr = 		temp_neuron.bias_corr;
				net->neuron_array[k]->delta_type = 	temp_neuron.delta_type;
				net->neuron_array[k]->delta_inf = 	temp_neuron.delta_inf;
				net->neuron_array[k]->delta_disp = 	temp_neuron.delta_disp;
				net->neuron_array[k]->momentum = 		temp_neuron.momentum;
				net->neuron_array[k]->num_con = 			temp_neuron.num_con;
				net->neuron_array[k]->bias =					temp_neuron.bias;
				net->neuron_array[k]->inner =				temp_neuron.inner;
				net->neuron_array[k]->block =				temp_neuron.block;
				net->neuron_array[k]->decayment = 		temp_neuron.decayment;
				net->neuron_array[k]->clock = 				temp_neuron.clock;
	
				net->neuron_array[k]->value =				temp_neuron.value;
				net->neuron_array[k]->delta =				temp_neuron.delta;
				net->neuron_array[k]->p_value =			temp_neuron.p_value;
				
				fgets(char_buffer,BUFFSIZE,file_pointer);  //range
				load_vector(dimension, net->neuron_array[k]->range, char_buffer);

				fgets(char_buffer,BUFFSIZE,file_pointer);  //x_c
				load_vector(dimension, net->neuron_array[k]->x_c, char_buffer);

				fgets(char_buffer,BUFFSIZE,file_pointer);  //alpha
				if (net->neuron_array[k]->momentum > 0)
				{
					load_vector(net->neuron_array[k]->momentum, net->neuron_array[k]->alpha, char_buffer);
				}

				for (l=0; l < temp_neuron.num_con; l++)	//connections
				{
					fgets(char_buffer,BUFFSIZE,file_pointer);
					load_connection(dimension,net->neuron_array[k]->con[l],char_buffer);
				}
				fgets(char_buffer,BUFFSIZE,file_pointer); //empty line

			}
		}
	}
	
	fclose(file_pointer);
	return(net);
		
}
