/*  va_unpack_io_block.c */
/* 	Copyright 2004-2006 Oswaldo Morizaki Hirakata */

/* 	This file is part of ga-nn-ag-2.

    ga-nn-ag is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    ga-nn-ag is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with ga-nn-ag; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "my_header.h"
#include "aux_prot.h"

/* 
- Function unpacks io_block->pack_vector in io_block->pack_char_vector
- Returns unpacked block 

- io_block->char_vector should be blank (points to NULL) 
*/

void * va_unpack_io_block(struct io_block * block, char sep)
{
	int k;
	int packsize;
	char * char_buffer;
	
	/* Check if block->num is zero */	
	if (block->num != 0)
	{
		if (block->char_vector != NULL)
		{
			/* Liberate char_vector and preserve connfd and pack_vector */
			packsize = block->packsize;
			if (!(char_buffer = (char *)calloc(packsize, sizeof(char))))
			{
				syslog(LOG_CRIT,"Error calloc char_buffer in va_unpack_io_block: %s",strerror(errno));
				return(NULL);
			}
			strncpy(char_buffer, block->pack_vector, packsize);
			if (!(block = (struct io_block *)va_calloc_io_block(0,0,packsize,block)))
			{
				syslog(LOG_CRIT,"Error va_calloc_io_block in va_unpack_io_block(): %s", strerror(errno));
				return(NULL);
			}
			strncpy(block->pack_vector, char_buffer, packsize);
			free(char_buffer);
		}
		else
		{
			block->num = 0;
		}
	}
	
//syslog(LOG_INFO,"in unpack_io_block pack_vector = %s, sep = %c",block->pack_vector, sep);
	
	block->num = va_load_num_values_vector(block->pack_vector, sep);
	
	if (!(block->char_vector = (char **)va_load_char_vector(block->char_vector,
												block->pack_vector, sep, &(block->buffsize)) ))
	{
		syslog(LOG_CRIT,"Error va_load_char_vector in va_unpack_io_block(): %s", strerror(errno));
		return(NULL);
	}

	
	/* Change NULL string to NULL pointer */
	for (k = 0; k< block->num; k++)
	{
		if (!strncmp(block->char_vector[k], "NULL", 4))
		{
			free(block->char_vector[k]);
			block->char_vector[k] = NULL;
		}
		
//syslog(LOG_INFO,"in unpack_io_block char_vector[%d] = %s",k,block->char_vector[k]);
		
	}
	
	return(block);
}
