/*  va_load_char_vector.c */

/* 	Copyright 2004-2006 Oswaldo Morizaki Hirakata */

/* 	This file is part of ga-nn-ag-2.

    ga-nn-ag is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    ga-nn-ag is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with ga-nn-ag; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

/* Returns in vector the components of char_buffer separated by sep */
/* Sets buffsize to maxlen (length of the vector[k] elements) */

#include "my_header.h"
#include "aux_prot.h"

void * va_load_char_vector(char ** vector, char * char_buffer, char sep, int *buffsize)
{
	int k,l,m;
	int num;
	char * char_temp;
	size_t len;
	size_t maxlen;
	
	len = strlen(char_buffer);
	len += 1;
	
	num = va_load_num_values_vector(char_buffer, sep);	
	maxlen = va_load_max_len_vector(char_buffer, sep);

//syslog(LOG_INFO,"in va_load_char_vector: num = %d maxlen = %d len = %d", num, maxlen,len);

	if (vector != NULL)
	{
		syslog(LOG_CRIT,"Error vector is already allocated in va_load_char_vector()");
		return(NULL);
	}

	if (!(char_temp = (char *)calloc(len, sizeof(char))))
	{
		syslog(LOG_CRIT,"Error calloc char_temp in va_load_char_vector(): %s", strerror(errno));
		return(NULL);
	}

	if (!(vector = (char **)calloc(num,sizeof(char *)) ))
	{
		syslog(LOG_CRIT,"Error calloc vector in va_load_char_vector(): %s", strerror(errno));
		return(NULL);
	}	
	for (k=0; k< num; k++)
	{
		if (!(vector[k] = (char *)calloc(maxlen,sizeof(char)) ))
		{
			syslog(LOG_CRIT,"Error calloc vector[%d] in va_load_char_vector() %s",k, strerror(errno));
			return(NULL);
		}	
	}
		
	l=0;
	m=0;
	for (k = 0; k < len ;k++)
	{
		char_temp[l] = char_buffer[k];
		if ( (sep == char_buffer[k]) || ('\n' == char_buffer[k]) || ('\0' == char_buffer[k]) )
		{
			char_temp[l]='\0';
			strncpy(vector[m],char_temp,maxlen);
			
//syslog(LOG_INFO,"in va_load_char_vector: vector[%d]=%s", m, vector[m]);
			
			l = 0;
			m += 1;
			if ((char_buffer[k] == '\n') || (char_buffer[k] == '\0'))
			{
				break;
			}
		}
		else
		{
			l+= 1;
		}
	}

	free(char_temp);

	*buffsize = maxlen;
	
	return(vector);
}
