/*  nn_output_layer_error.c */

/* 	Copyright 2004-2006 Oswaldo Morizaki Hirakata */

/* 	This file is part of ga-nn-ag.

    ga-nn-ag is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    ga-nn-ag is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with ga-nn-ag; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "my_header.h"
#include "aux_prot.h"

/* 
Error should be a float vector of lenght = num_elem_output

Returns cumulative error
*/

float nn_output_layer_error(struct neural_net * net,	int num_elem_output, float *output_buffer, float threshold_level, float * error)
{
	int k,l;
	int num_neuron;
	double temp;
	double local_error = 0;
	
	/* Clear error vector */
	for (k=0; k< num_elem_output; k++)
	{
		*(error+k) = 0.0;
	}
	
	num_neuron = net->num_neuron;
	
	for (k=0; k< num_neuron; k++)
	{
		net->neuron_array[k]->delta = 0;
	}
	
	for (k=0; k < num_elem_output; k++)
	{
		l = num_neuron - num_elem_output+k - 1;
		temp = output_buffer[k] - net->neuron_array[l]->value;
		local_error += temp*temp;
		*(error+k) = sqrtf(temp*temp);
		temp *= n_derive(net->neuron_array[l]->delta_type,net->neuron_array[l]->value, threshold_level);
		net->neuron_array[l]->delta=temp;
	}
	return(sqrtf(local_error));
}
