/*  nn_load_input.c */

/* 	Copyright 2004-2006 Oswaldo Morizaki Hirakata */

/* 	This file is part of ga-nn-ag-2.

    ga-nn-ag is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    ga-nn-ag is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with ga-nn-ag; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "my_header.h"
#include "aux_prot.h"

/* io_connection should point to an already connected facility */
/* 'size' is the amount of memory reserved for char_buffer */
/* function returns number of values per input */

void * nn_load_input(float **input_buffer, int num_elem_input, struct io_connection * con, int size, int *input_len)
{
	int k,l,m,n;
	int type;
	int counter;
	int alloc = 0;
	char char_temp[BUFFSIZE];
	char * char_buffer;

	if (!(char_buffer = (char *)calloc(size,sizeof(char)) ))
	{
		syslog(LOG_CRIT,"Error calloc char_buffer in nn_load_input");
		*input_len=-10;
		return(NULL);
	}

	if (input_buffer != NULL)
	{
		syslog(LOG_ERR,"Error input_buffer not free, memory leak posible");
		free(input_buffer);
	}
	if (!(input_buffer = (float **)calloc(num_elem_input,sizeof(float *)) ))
	{
		syslog(LOG_CRIT,"Error calloc input_buffer in nn_load_input: %s", strerror(errno));
		free(char_buffer);
		*input_len=-10;
		return(NULL);
	}
	
	type = va_io_connect(con);
	if ((type == 10) || (type == 20))
	{
		sprintf(char_temp,"PATTERN=%d\0",con->req);
		va_writen(con->connfd,char_temp,BUFFSIZE);	
		k = 0;
		while (1)
		{
			va_readn(con->connfd,char_buffer,size);
			if ( (strncmp(char_buffer,"END_INPUT",9)))
			{
				if (k < num_elem_input)
				{
					if (!alloc)
					{
						l = n_load_num_values_vector(char_buffer, size);
						counter = (l > 0) ? l : 1;
						for (l = 0; l< num_elem_input; l++)
						{
							if (!(input_buffer[l]= (float *)calloc(counter,sizeof(float)) ))
							{
								syslog(LOG_CRIT,"Error calloc input_buffer[%d] in nn_load_input: %s",l, strerror(errno));
								free(char_buffer);
								*input_len=-10;
								return(NULL);
							}
						}
						alloc =1;
					}
					
					l=0;
					m=0;
					for (n = 0; n < size ;n++)
					{
						char_temp[l] = char_buffer[n];
						if ( (':' == char_buffer[n]) || ('\n' == char_buffer[n]) || ('\0' == char_buffer[n]) )
						{
							char_temp[l]='\0';
							input_buffer[k][m] = atof(char_temp);
							l = 0;
							m += 1;
							if ((char_buffer[n] == '\n') || (m == counter))
							{
								break;
							}
						}
						else
						{
							l+= 1;
						}
					}					
					k += 1;
				}
				else 
				{
					con->connected = 0;
					close(con->connfd);
					*input_len=-2; //Too many inputs
					return(NULL);
				}
			}
			else 
			{
				if (k == num_elem_input) //everything is fine
				{
					con->connected = 0;
					close(con->connfd);
					free(char_buffer);
					*input_len=counter;
					return(input_buffer);
				}
				else
				{
					con->connected = 0;
					close(con->connfd);
					*input_len=-3;
					return(NULL); //Not enought inputs
				}
			}
		}
	}
	else if ((type == 40) || (type == 42))
	{
		k = 0;
		while (1)
		{
			fgets(char_buffer,size,con->file_ptr);
			if ( (strncmp(char_buffer,"\n",1)) && !(feof(con->file_ptr)) )
			{
				if (k < num_elem_input)
				{
					if (!alloc)
					{
						l = n_load_num_values_vector(char_buffer, size);
						counter = (l > 0) ? l : 1;
						for (l = 0; l< num_elem_input; l++)
						{
							if (!(input_buffer[l]= (float *)calloc(counter,sizeof(float)) ))
							{
								syslog(LOG_CRIT,"Error calloc input_buffer[%d] in nn_load_input: %s",l, strerror(errno));
								free(char_buffer);
								*input_len=-10;
								return(NULL);
							}
						}
						alloc =1;
					}
					
					l=0;
					m=0;
					for (n = 0; n < size ;n++)
					{
						char_temp[l] = char_buffer[n];
						if ( (':' == char_buffer[n]) || ('\n' == char_buffer[n]) || ('\0' == char_buffer[n]) )
						{
							char_temp[l]='\0';
							input_buffer[k][m] = atof(char_temp);
							l = 0;
							m += 1;
							if ((char_buffer[n] == '\n') || (m == counter))
							{
								break;
							}
						}
						else
						{
							l+= 1;
						}
					}					
					k += 1;
				}
				else 
				{
					fclose(con->file_ptr);
					con->connected = 0;
					*input_len=-2;			//Too many inputs
					return(NULL);
				}
			}
			else if (feof(con->file_ptr))
			{
				if (k == num_elem_input) //everything is fine
				{
					fclose(con->file_ptr);
					con->connected = 0;
					free(char_buffer);
					*input_len=counter;
					return(input_buffer);
				}
				else
				{
					fclose(con->file_ptr);
					con->connected = 0;
					*input_len=-3;			//Not enough inputs
					return(NULL);
				}
			}
		}
	}
	*input_len=-1;
	return(NULL);
}
