/*  nn_free_neural_net.c */

/* 	Copyright 2004-2005 Oswaldo Morizaki Hirakata */

/* 	This file is part of ga-nn-ag.

    ga-nn-ag is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    ga-nn-ag is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with ga-nn-ag; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "my_header.h"
#include "aux_prot.h"

/***** Free neural_net *****/
void * nn_free_neural_net(struct neural_net * target)
{
	int k;
	int num_neuron;

	if (target == NULL)
	{
		return(NULL);
	}
	
	num_neuron = target->num_neuron;
	
	if (num_neuron > 0)
	{	
		for (k=0; k< num_neuron; k++)
		{
			if (target->neuron_array[k] != NULL)
			{
				target->neuron_array[k] = (struct neuron *)n_free_neuron(target->neuron_array[k]);
			}
		}	
		free(target->neuron_array);
	}
	target->neuron_array = NULL;
	free(target);
	target = NULL;
	return(target);
}

