/*  nn_agr_f.c */
/* 	Copyright 2004-2006 Oswaldo Morizaki Hirakata */

/* 	This file is part of ga-nn-ag.

    ga-nn-ag is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    ga-nn-ag is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with ga-nn-ag; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "my_header.h"
#include "aux_prot.h"

/*
Type is defined by result net

Function requires mode, input_add, output_add, agr_net
*/

#define INIT_FILE 		conf.init_filename
#define DIMENSION 		conf.dimension
#define TYPE 				conf.type
#define MOMENTUM 			conf.momentum
#define ALPHA 				conf.alpha
#define CONV_RATE 		conf.conv_rate
#define BIAS_CORR 		conf.bias_corr
#define DELTA_TYPE 		conf.delta_type
#define DELTA_INF 		conf.delta_inf
#define DELTA_DISP 		conf.delta_disp
#define BIAS 				conf.bias
#define DECAYMENT			conf.decayment
#define NUM_OUTPUT_ADD	conf.output_add
#define NUM_INPUT_ADD	conf.input_add
#define MODE				conf.mode

void * nn_agr_f(struct neural_net * net, struct neural_net * agr_net, struct nn_init_config * init_config)
{
int k,l,m,n,o,p;
int agr_type;			
int type;
int num_neuron_add;
int num_output_add;
int num_input_add;
int old_num_output;
int old_num_input;
int dimension;
int momentum;
int connfd;

float temp;
	
struct nn_init_config conf;
struct neural_net * append_net = NULL;

struct io_connection init1_con;
struct io_connection init2_con;
struct io_connection result_con;



nn_load_nn_init_config(0,char_buffer, &conf); //mode 0 = reset

strcpy(conf.mode, init_config->mode);
strcpy(conf.input_add, init_config->input_add);
strcpy(conf.output_add, init_config->output_add);
agr_type = init_config->agr_type; // 10 = More outputs, 11 = More inputs, 20 = nn agr

old_num_input = net->num_input;
old_num_output = net->num_output;
dimension = net->dimension;
num_neuron_add = 0;

/* Aggregation of more outputs */
if (agr_type == 10)
{
	num_output_add = atoi(NUM_OUTPUT_ADD);
	
	temp = (float)net->num_neuron /net->num_output;
	
	k= (int)temp;
	
	num_neuron_add = va_dice_toss(k,k);
	
	num_neuron_add += num_output_add;
	
	if ( !(append_net = (struct neural_net *)calloc(1,sizeof(struct neural_net)) ))
	{
		ga_errno = 1;
		syslog(LOG_CRIT,"Error calloc append_net");
		return(NULL);
	}
	if ( !(append_net->neuron_array = (struct neuron **)calloc(1,sizeof(struct neuron)) ))
	{
		ga_errno = 1;
		syslog(LOG_CRIT,"Error calloc append_net->neuron_array");
		return(NULL);
	}
	append_net->num_neuron = 1;
	append_net->type = net->type;
	append_net->dimension = net->dimension;

		
	/* Append output neurons to net */
	for (k=0; k< num_neuron_add; k++)
	{
		if (!strncmp("rr",MOMENTUM,2))
		{
			momentum = va_dice_toss(k,MAX_MOMENTUM);
		}
		else 
		{
			momentum = atoi(MOMENTUM);
		}
		if ( !(append_net->neuron_array[0] = (struct neuron *)n_calloc_neuron(
				net->dimension,momentum,0) ))
		{
			ga_errno = 1;
			syslog(LOG_CRIT,"Error calloc append_net->neuron_array");
			return(NULL);
		}
		append_net->neuron_array[0]->momentum = momentum;
		
		if (k < num_output_add)
		{
			append_net->neuron_array[0]->x_c[0] = 1.0;
			append_net->neuron_array[0]->range[0] = va_rand_gen(k) / 2;
			append_net->neuron_array[0]->block = 13;		//upper
		}
		else
		{
			l = va_dice_toss(k,(net->num_neuron - net->num_input - net->num_output) );
			temp = net->neuron_array[l + net->num_input]->x_c[0];
			append_net->neuron_array[0]->x_c[0] = temp; //set coordinates
			append_net->neuron_array[0]->range[0] = (temp > 0.5) ? (va_rand_gen(l) / 2) : 
																				( temp*va_rand_gen(l) ) ; //set range
			append_net->neuron_array[0]->block = 11;		//inner
		}

		for (l= 1; l< dimension; l++)
		{
			temp = va_rand_gen(l);
			append_net->neuron_array[0]->x_c[l] = temp; //set coordinates
			append_net->neuron_array[0]->range[l] = (temp > 0.5) ? (va_rand_gen(l) / 2) : 
																				( temp*va_rand_gen(l) ) ; //set range
		}

		for (l= 0; l< append_net->neuron_array[0]->momentum; l++) //alpha
		{
			if ( strncmp(ALPHA,"rr",2) )
			{
				temp = va_rand_gen(l)*atof(ALPHA);
			}
			else
			{
				temp = va_rand_gen(l);
			}
			append_net->neuron_array[0]->alpha[l] = temp;
		}
		
		if ( strncmp(CONV_RATE,"rr",2) ) //set conv_rate
		{
			temp = atof(CONV_RATE);
		}
		else
		{
			temp = va_rand_gen(k);
		}
		append_net->neuron_array[0]->conv_rate = temp;
		
		if ( strncmp(BIAS_CORR,"rr",2) ) //set bias_corr
		{
			l = atoi(BIAS_CORR);
		}
		else
		{
			l = va_coin_toss(k);
		}
		append_net->neuron_array[0]->bias_corr = l;

		if ( strncmp(DELTA_TYPE,"rr",2) ) //set delta_type
		{
			l = atoi(DELTA_TYPE);
		}
		else
		{
			l = va_dice_toss(k,NUM_TYPE);
		}
		append_net->neuron_array[0]->delta_type = l;
		
		if ( strncmp(DELTA_INF,"rr",2) ) //set delta_inf
		{
			temp = atof(DELTA_INF);
		}
		else
		{
			temp = MAX_DELTA_DISP*va_rand_gen(k);
		}
		append_net->neuron_array[0]->delta_inf = temp;

		if ( strncmp(DELTA_DISP,"rr",2) ) //set delta_disp
		{
			temp = atof(DELTA_DISP);
		}
		else
		{
			temp = MAX_DELTA_DISP*va_rand_gen(k);
		}
		append_net->neuron_array[0]->delta_disp = temp;

		if ( strncmp(BIAS,"rr",2) ) //set bias
		{
			temp = atof(BIAS);
		}
		else
		{
			temp = va_rand_gen(k);
		}
		append_net->neuron_array[0]->bias = temp;
		
		if ( strncmp(DECAYMENT,"rr",2) ) //set decayment
		{
			temp = atof(DECAYMENT);
		}
		else
		{
			temp = va_rand_gen(k);
		}
		append_net->neuron_array[0]->decayment = temp;
		
		append_net->neuron_array[0]->inner = 4;
		
		net = (struct neural_net *)nn_append_neuron(net,append_net);

		n_free_neuron( append_net->neuron_array[0] );
	}	
}
/* Aggregation of more inputs */
else if (agr_type == 11)
{
	num_input_add = atoi(NUM_INPUT_ADD);
	num_neuron_add = num_input_add;
	
	if ( !(append_net = (struct neural_net *)calloc(1,sizeof(struct neural_net)) ))
	{
		ga_errno = 1;
		syslog(LOG_CRIT,"Error calloc append_net");
		return(NULL);
	}
	if ( !(append_net->neuron_array = (struct neuron **)calloc(1,sizeof(struct neuron)) ))
	{
		ga_errno = 1;
		syslog(LOG_CRIT,"Error calloc append_net->neuron_array");
		return(NULL);
	}
	append_net->num_neuron = 1;
	append_net->type = net->type;
	append_net->dimension = net->dimension;
	

	/* Append input neurons to net */
	for (k=0; k< num_neuron_add; k++)
	{
		if (!strncmp("rr",MOMENTUM,2))
		{
			momentum = va_dice_toss(k,MAX_MOMENTUM);
		}
		else 
		{
			momentum = atoi(MOMENTUM);
		}
		if ( !(append_net->neuron_array[0] = (struct neuron *)n_calloc_neuron(
				net->dimension,momentum,0) ))
		{
			ga_errno = 1;
			syslog(LOG_CRIT,"Error calloc append_net->neuron_array");
			return(NULL);
		}
		append_net->neuron_array[0]->momentum = momentum;
		
		append_net->neuron_array[0]->x_c[0] = 0.0;
		append_net->neuron_array[0]->range[0] = va_rand_gen(k) / 2;
		append_net->neuron_array[0]->block = 12;		//lower

		for (l= 1; l< dimension; l++)
		{
			temp = va_rand_gen(l);
			append_net->neuron_array[0]->x_c[l] = temp; //set coordinates
			append_net->neuron_array[0]->range[l] = (temp > 0.5) ? (va_rand_gen(l) / 2) : 
																				( temp*va_rand_gen(l) ) ; //set range
		}

		for (l= 0; l< append_net->neuron_array[0]->momentum; l++) //alpha
		{
			if ( strncmp(ALPHA,"rr",2) )
			{
				temp = va_rand_gen(l)*atof(ALPHA);
			}
			else
			{
				temp = va_rand_gen(l);
			}
			append_net->neuron_array[0]->alpha[l] = temp;
		}
		
		if ( strncmp(CONV_RATE,"rr",2) ) //set conv_rate
		{
			temp = atof(CONV_RATE);
		}
		else
		{
			temp = va_rand_gen(k);
		}
		append_net->neuron_array[0]->conv_rate = temp;
		
		if ( strncmp(BIAS_CORR,"rr",2) ) //set bias_corr
		{
			l = atoi(BIAS_CORR);
		}
		else
		{
			l = va_coin_toss(k);
		}
		append_net->neuron_array[0]->bias_corr = l;

		if ( strncmp(DELTA_TYPE,"rr",2) ) //set delta_type
		{
			l = atoi(DELTA_TYPE);
		}
		else
		{
			l = va_dice_toss(k,NUM_TYPE);
		}
		append_net->neuron_array[0]->delta_type = l;
		
		if ( strncmp(DELTA_INF,"rr",2) ) //set delta_inf
		{
			temp = atof(DELTA_INF);
		}
		else
		{
			temp = MAX_DELTA_DISP*va_rand_gen(k);
		}
		append_net->neuron_array[0]->delta_inf = temp;

		if ( strncmp(DELTA_DISP,"rr",2) ) //set delta_disp
		{
			temp = atof(DELTA_DISP);
		}
		else
		{
			temp = MAX_DELTA_DISP*va_rand_gen(k);
		}
		append_net->neuron_array[0]->delta_disp = temp;

		if ( strncmp(BIAS,"rr",2) ) //set bias
		{
			temp = atof(BIAS);
		}
		else
		{
			temp = va_rand_gen(k);
		}
		append_net->neuron_array[0]->bias = temp;
		
		if ( strncmp(DECAYMENT,"rr",2) ) //set decayment
		{
			temp = atof(DECAYMENT);
		}
		else
		{
			temp = va_rand_gen(k);
		}
		append_net->neuron_array[0]->decayment = temp;
		
		append_net->neuron_array[0]->inner = 2;
		
		if (!(net = (struct neural_net *)nn_append_neuron(net,append_net) ))
		{
			syslog(LOG_CRIT,"Error in nn_append_neuron");
			return(NULL);
		}
		
		n_free_neuron( append_net->neuron_array[0] );
	}	
}
/* Aggregation of whole networks */
else if (agr_type == 20)
{

	if (!(append_net = (struct neural_net *)nn_copy_neural_net(agr_net, append_net) ))
	{
		syslog(LOG_CRIT,"Error nn_copy_neural_net in nn_agr_f: %s", strerror(errno));
		return(NULL);
	}
	
	l = atoi(MODE);
	if (l == 0)	// full network append
	{
		for (k= 0; k< append_net->num_neuron; k++)
		{
			append_net->neuron_array[k]->inner = append_net->neuron_array[k]->block;
		}
	}
	else if (l == 1) // share the output
	{
		for (k= append_net->num_input; k< append_net->num_neuron; k++)
		{
			append_net->neuron_array[k]->inner = append_net->neuron_array[k]->block;
		}
		for (k= 0; k< append_net->num_input; k++)
		{
			append_net->neuron_array[k]->inner = 0;
			for (m= append_net->num_input; m< append_net->num_neuron; m++)
			{
				if(n_is_connected(append_net->neuron_array[k],append_net->neuron_array[m],NULL) >0)
				{
					append_net->neuron_array[m]->inner = 12;  //block lower
				}
			}
		}
	}
	else if (l == 2) //share the input
	{
		for (k= 0; k< append_net->num_neuron; k++)
		{
			append_net->neuron_array[k]->inner = append_net->neuron_array[k]->block;
		}
		for (k= append_net->num_neuron - append_net->num_output; k< append_net->num_neuron; k++)
		{
			append_net->neuron_array[k]->inner = 0;
			for (m= 0; m< append_net->num_neuron - append_net->num_output; m++)
			{
				if(n_is_connected(append_net->neuron_array[k],append_net->neuron_array[m],NULL) >0)
				{
					append_net->neuron_array[k]->inner = 13;  //block upper
				}
			}
		}
	}
	
	if (!(net = (struct neural_net *)nn_append_neuron(net,append_net) )) //requires more aggregation modes
	{
		syslog(LOG_CRIT,"Error appending neuron");
		return(NULL);
	}
	n_free_neuron( *(append_net->neuron_array) );
}

/* Clean inner values in net */
for (k= net->num_neuron; k+1; k--)
{
	net->neuron_array[k]->inner = 0;
}

append_net->num_neuron = 0;
append_net=nn_free_neural_net(append_net);

return(net);

}
