/*  my_header.h */
/* 	Copyright 2004-2006 Oswaldo Morizaki Hirakata */
/* 	This file is part of ga-nn-ag-2 

    ga-nn-ag is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    ga-nn-ag is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with ga-nn-ag; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef MY_HEADER_H
#define MY_HEADER_H

#include <sys/types.h>
#include <sys/stat.h>
#include <sys/wait.h>
#include <sys/un.h>
#include <sys/select.h>
#include <sys/time.h>
#include <sys/socket.h>
#include <sys/mman.h>
#include <netinet/in.h>
#include <arpa/inet.h>

#include <netdb.h>
#include <unistd.h>
#include <syslog.h>
#include <errno.h>
#include <fcntl.h>
#include <setjmp.h>
#include <pthread.h>
#include <dirent.h>

#include <stdlib.h>
#include <stdio.h>
#include <math.h>
#include <strings.h>

#define MAXSOCKADDR 128

#define SPRANGE 64
#define DPRANGE 384
#define BUFFSIZE 512
#define BUFFSIZE_1 511
#define BLOCKSIZE 32
#define LISTENQ 1024
#define FILE_MODE (S_IRUSR | S_IWUSR | S_IRGRP | S_IROTH)
#define MAX_RETRY 5
#define IO_SEP '!'
#define PAT_SEP '?'
#define BLOCK_SEP ';'
#define ELEM_SEP ':'

#define NUM_TYPE 3
#define MAX_MOMENTUM 2
#define MAX_DELTA_DISP 3
#define MAX_DELTA_INF 2
#define INM_ID 32700

#define GA_CLIENT_NUM_PARAM 7

/* Max dimension is limited by BUFFSIZE (512) and SATURATION (10^25) and precision (5 bytes) */
/* 512 / (25+5) ~ 16 */
#define SATURATION 10000000000000000000000000.0
#define MAX_DIMENSION 16
#define PI 3.141592653589

char char_buffer[BUFFSIZE];
char ** char_vector;

/*
ga_errno:

0 = no error
1 = memory allocation error
*/

int ga_errno;

struct nn_config
{
	int num_pat;
	int num_input;
	int num_output;
	int buffsize;
	
	int mode; //mode: 0 = train; 1 = test; 2 = prod
	int input_flag; // 1 = file  ; 0 = socket
	int output_flag; // 1 = file  ; 0 = socket
	
	float age_inf;	//age influence
	float threshold_level; //number above output is considered constant
	
	char input_preffix[BUFFSIZE];
	char output_preffix[BUFFSIZE];

	char init[BUFFSIZE];
	char result[BUFFSIZE];
};

/* Configuration structure for nn_init config */
/* Requires storage in char format, since it could be "rr" or the real value */
struct nn_init_config
{
	char init_filename[BUFFSIZE];
	char dimension[BUFFSIZE];
	char type[BUFFSIZE];
	char momentum[BUFFSIZE];
	char alpha[BUFFSIZE];
	char conv_rate[BUFFSIZE];
	char bias_corr[BUFFSIZE];
	char delta_type[BUFFSIZE];
	char delta_inf[BUFFSIZE];
	char delta_disp[BUFFSIZE];
	char bias[BUFFSIZE];
	char decayment[BUFFSIZE];
	char layers[BUFFSIZE];
	char output_add[BUFFSIZE];
	char input_add[BUFFSIZE];
	char old_init1[BUFFSIZE];
	char old_init2[BUFFSIZE];
	char mode[BUFFSIZE];			//0:full network, 1:share output, 2:share input
	int agr_type;					//Just used in functions
	int num_param;
};	

/* genetic algorithm server configuration structure */
struct ga_server_config
{	
	int timestamp;
	int time_wait;						// Time between provider activation (default = 60s)
	int master;							// master server flag
	int master_niche;					// master of a niche flag
	int run;								// run flag, if set, run with current config
	int agr; 							// agr mode: 10 output_agr, 11 input_agr, 20 nn_net_agr
	int agr_io_add; 					// inputs / outputs to add
	int clean_start;					// Call init_generator at beginning
	int num_hosts;
	int num_niches;
	int num_local;
	int train_ratio;				// ratio train / test

	char config_filename[BUFFSIZE];  	//name of ga_server configuration file
	char command_ip[BUFFSIZE];				//ip is employed by COMMAND SERVER, so it couldn't be localhost
	char service_ip[BUFFSIZE];				//ip for service server, only useful if not master
	char init_preffix[BUFFSIZE];			// default = init
	char result_preffix[BUFFSIZE];		// default = result
	char agr_add_preffix[BUFFSIZE];		
	char input_dir[BUFFSIZE];				// default = input
	char output_dir[BUFFSIZE];				// default = output
	char input_preffix[BUFFSIZE];			// default = input, input filename = input_cat%d_%d
	char output_preffix[BUFFSIZE];		// default = output, output filename = output_cat%d_%d
	
	char ** hosts;								// host%d=host_ip:host_config_file
	char ** hosts_config;
	char ** niches;							// niche%d=niche_ip:niche_config_file
	char ** niches_config;

	unsigned int command_port;				// default = 32000
	unsigned int service_port;				// default = 32001
	unsigned int niche_port;				// niche_port should be the same as service_port in the remote niches

	/* INIT / AGR */
	int nn_dimension;							// default = 3
	int nn_type;								// 0 = normal; 1 = direct (default = 0)
	int nn_num_input;
	int nn_num_output;

	int population;								// default = 100
	int generations;							// default = 100
	int max_neuron_mut;						// default = 1
	int max_num_layer;						// default = 5
	int max_num_neuron;						// default = 50
	int age;
	
	/* GA Section */
	int fitness_mode;							// default = 0
	int error_mode;							// default = 0

	float mut_new_prob;			// probability of generate a new neural net (default = 0.01)
	float mut_neuron_prob;		// probability of mutating a neuron (default = 0.01)
	float mut_net_prob;			// probability of mutating a whole net (num_neuron) (default = 0.01)
	float inm_prob;				// probability of inmigration (default = 0.01)
	float inm_level;				// level of standard deviation to activate inmigration (default = 0.1)
	float base;						// default = 10.0
	float boost;					// default = 1.0
	float level;					// default = 0.0
	
	float prob_alpha;				// default = 1.0
	float prob_range;				// default = 1.0
	float prob_conv_rate;		// default = 1.0
	float prob_bias_corr;		// default = 1.0
	float prob_delta_type;		// default = 1.0
	float prob_momentum;			// default = 1.0
	float prob_bias;				// default = 1.0
	
	int lifespan;					// lifespan in cycles, values are updated as used, default 25 (not used)
	int nursetime;					// nursetime in cycles, values are updated as used, should not be more than 50% of lifespan default 10

	/* Pattern section */
	int pat_fitness_mode;					// Same as fitness_mode
	int pat_error_mode;						// Same as error_mode
	int pat_group_mode;						// 0 = Whole as one, 1 = Group by column, 2 = Group by row (element), 3 = No grouping

	float pat_num_stable_prob;			// probability of mutation of num_stable (default 0.0)
	float pat_mut_prob;						//	probability of mutation in patterns (default 0.0)
	float pat_cross_prob;					// probability of crossing per generation (default 0.0)
	float pat_base;							// Same default as base
	float pat_boost;							// Same default as boost
	
	/* Other config structures */
	struct nn_config nn_train_conf;
	struct nn_init_config nn_init_conf;
	struct nn_init_config nn_agr_conf;
};

/* ga_client configuration structure */
struct ga_client_config
{
	int client_id; //client number, 32700 is reserved for inmigration server
	
	int exit_flag;
	
	char server_ip[BUFFSIZE];
	char server_port[BUFFSIZE];
};

/* neuron structure */
struct neuron
{
	float conv_rate;	// convergence rate
	float bias;			// bias input
	float decayment;	// memory decayment value (zero if no decayment)
	float delta_disp; // NOT USED (yet)
	float delta_inf;	// NOT USED (yet)

	int id;				//neuron id
	int eoi_flag;		//end of input flag
	int clock;			//clock tick
	int block;			//Marker for blocks, non volatile, values same as inner
									//11 = block inner : 12 = block lower : 13 = block upper : 14 = 12 and 13
	int bias_corr;		//just zero or one
	int delta_type;	//less than NUM_TYPE
	int momentum;		//momentum level
	int dimension; 	//neuron dimension space
	int num_con;		//number of connected elements
	int inner;			//0 = not inner : 1 = inner : 2 = lower border : 3 = upper border : 4 = 2 and 3
									//11 = block inner : 12 = block lower : 13 = block upper : 14 = 12 and 13
	float * range;		//range of connection, depends on dimension
	float * x_c;			//coordinate array, depends on dimension
	float * alpha;		//One value per momentum level

	struct connection ** con;
	
	double value;		//network value
	double p_value; //previus value
	double delta;		//error value
};

/* neuron connection */
struct connection
{
	int id;
	int age;
	int clock;
	int eoi_flag;
	float buffer;
	double weight;
	float * con_x;						//Size depends on dimension
	double * delta_weight;  		//Size depends on momentum
};

/* neural net parameters */
struct neural_net
{
	struct neuron ** neuron_array;
	int num_neuron;
	int num_input;
	int num_output;
	int age;					
	int dimension;
	int type;				//0 = classic; 1 = input drive
};


/* io connection */
/*
connection mode: 
10 = socket unix read/write
20 = socket inet read/write
30 = fifo read
31 = fifo write
40 = FILE read
41 = FILE write
42 = FILE read/write
*/
struct io_connection
{
	FILE * file_ptr;

	int mode;				//connection mode

	int connected;	//1=already connected, 0=not connected
	int io_flag; 		//0=read, 1=write, 2=both
	int socket; //socket flag
	int fifo;   //fifo flag
	int file;		//file flag
	int local;	//1=socket unix, 0=socket inet

	int connfd;	//socket descriptor
	int number;	//client number
	int req;		//requisition number

	char filename[BUFFSIZE];		
	char ip[BUFFSIZE];
	char port[BUFFSIZE];
	
	struct sockaddr_un cliaddr_un;
	struct sockaddr_in cliaddr_in;
};

struct io_block
{
	int num;
	int buffsize;
	int packsize;
	int connfd;
	char ** char_vector;
	char * pack_vector;
};

/* Information (fork exec) about the client */
struct ga_client_info
{
	pid_t pid;									//client pid 
	int is_running;							//is running
};


/* Information (thread service) about client */
struct ga_service_client_info
{
	int id;											//client id
	int state;									//0 = REQ; 1 = UPD;
	int command;								//0 = init; 1 = agr; 2 = exec_train; 3 = exec_test ; 4 = exec_terminate; 5 = foreign ; -1 = exit
	int curr_gen;								//current generation of the client
	
	int *connptr;								//connection descriptor
	
	struct sockaddr_in addr;				//address
	
	double c_error;							//cumulative error
	double fitness;							//fitness value
	
	struct nn_return_f * ret;
	
	/* Local parameters */	
	struct ga_pat_index * pat_index;
	int pat_curr_gen;						//current generation of pattern
	int nursetime;							//nursetime of client, set after an init or agr (reverse counter)
};

/* Index of clients (thread service) */
struct ga_service_client_index
{
	int num_client;															//number of clients
	int num_addr;																//number of inet address
	int * offsets;												
	struct sockaddr_in ** addr;					
	struct ga_service_client_info ** clients;
};


/* Structure for traveling descriptors */
struct ga_service_pass_fd
{
	int *passing_socket_fd;
	int sock_listen;
};

/* Structure for listen thread parameters */
struct ga_service_listen_thread_param
{
	struct ga_server_config * conf;
	int * listenfd;
};

/* Structure for listen thread parameters */
struct ga_service_provider_thread_param
{
	struct ga_server_config * conf;
	int local_current_generation;
};

/* Structure for accept thread parameters */
struct ga_service_accept_client_param
{
	int * connptr;
};

/* Structure for nn_f, return value */
struct nn_return_f
{
	int num_pat;
	int num_output;
	int * num_elem;
	float *** error;	// Detailed error, per pattern / output / ouput_elem
	struct neural_net * net;
};

/* Structure for pattern info */
struct nn_pattern
{
	int num_pat;
	int num_input;
	int * num_elem;
	float *** pattern;
};

/* Structure for pattern */
struct ga_pattern
{
	int pat_cat; 	// Pattern category
	int stable;		// 0 = not stable, 1 = stable
	int num_input;
	int num_output;
	int num_elem_input;
	int num_elem_output;
	int num_fitness;
	int num_elem_fitness;

	float fitness;
	
	float ** in_pattern; // input pattern value
	float ** out_pattern; // output pattern value
	float ** pat_fitness; // Size dependends on pat_group_mode
};

/* Structure for pattern category */
struct ga_pat_cat
{
	double cat_fitness;
	int group_mode;
	int pat_cat;
	int num_pat;	//Number of patterns in this category
	int num_stable;
	struct ga_pattern ** pat;
};

/* Structure for pattern index */
struct ga_pat_index
{
	int group_mode;
	int base;		// 0 if not base, 1 if base
	int num_cat;	// Number of pattern categories
//	int pat_curr_gen;
	struct ga_pat_cat ** cat;
};

/* Structure for genetic algorithm for categories */
struct ga_pat_ga_cat_thread_param
{
	struct ga_server_config * conf;
	
	int num_pat;	// number of returned patterns
	struct ga_pat_cat * cat;
	struct ga_pat_cat * result_cat;

	int ready;	
	int *num_thread;
	pthread_cond_t * cat_cond;
	pthread_mutex_t * cat_mutex;
};

#endif
