/*  ga_prov_set_command_block.c */
/*  Copyright 2004-2006 Oswaldo Morizaki Hirakata */

/*  This file is part of ga-nn-ag-2.

    ga-nn-ag is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    ga-nn-ag is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with ga-nn-ag; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "my_header.h"
#include "aux_prot.h"

/* Global variables and mutexes from service server*/
#include "ga_service_server_header.h"

void * ga_prov_set_command_block(struct io_block * command_block, int command, int num_nn)
{
	char temp_buffer[BUFFSIZE];

	sprintf(temp_buffer,"COMMAND\0");
	if (!(command_block = (struct io_block *)va_insert_io_block(-1,temp_buffer,command_block)))
	{
		syslog(LOG_CRIT,"Error va_insert_io_block() inserting: %s",temp_buffer);
		return(NULL);
	}

	switch (command)
	{
		case 0:
		{
			sprintf(temp_buffer,"INIT\0");
			break;
		}
		case 1:
		{
			sprintf(temp_buffer,"AGR\0");
			break;
		}
		case 2:
		{
			sprintf(temp_buffer,"TEST\0");
			break;
		}
		case 3:
		{
			sprintf(temp_buffer,"TRAIN\0");
			break;
		}
		default:
		{
			sprintf(temp_buffer,"EXIT\0");
			break;
		}
	}
	if (!(command_block = (struct io_block *)va_insert_io_block(-1,temp_buffer,command_block)))
	{
		syslog(LOG_CRIT,"Error va_insert_io_block() inserting: %s",temp_buffer);
		return(NULL);
	}
			
	sprintf(temp_buffer,"%d\0",num_nn); 
	if(!(command_block = (struct io_block *)va_insert_io_block(-1,temp_buffer,command_block)))
	{
		syslog(LOG_CRIT,"Error va_insert_io_block() inserting: %s",temp_buffer);
		return(NULL);
	}

	/* Insert NULL */
	if (!(command_block = (struct io_block *)va_insert_io_block(-1,NULL,command_block) ))
	{
		syslog(LOG_CRIT,"Error va_insert_io_block(command_block) inserting: NULL");
		return(NULL);
	}			
	
	return(command_block);
}																							
