/*  ga_prov_get_fitness.c */

/* 	Copyright 2004-2006 Oswaldo Morizaki */

/* 	This file is part of ga-nn-ag-2.

    ga-nn-ag is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    ga-nn-ag is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with ga-nn-ag; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "my_header.h"
#include "aux_prot.h"

/* 
fitness_mode: (default exponential)
	0 = exponential: base^(-(error - error_min)*boost / error_range)
	1 = radix: 1 + base*(1 - (error - error_min)/error_range)^(1/boost)

error_mode: (default rms)
	0 = rms
	1 = avg
	2 = max

Elements with command different than 3 get fitness 0.0;
	
*/
int ga_prov_get_fitness(struct ga_server_config * conf,
						 struct ga_service_client_index * index)
{
	int k,l,m,n;
	int ret;
	double error_max;
	double error_min;
	double range;
	
	double base = conf->base;
	double boost = conf->boost;
	
	/* Set c_error to zero */
	for (k=0; k< index->num_client; k++)
	{
		index->clients[k]->c_error = 0;
	}
	
	switch(conf->error_mode)
	{
		case 1: 
		{
			for (k=0; k< index->num_client; k++)
			{
				for (l=0; l< index->clients[k]->ret->num_pat ; l++)
				{
					for (m=0 ; m< index->clients[k]->ret->num_output; m++)
					{
						for (n=0 ; n< index->clients[k]->ret->num_elem[l]; n++)
						{
							index->clients[k]->c_error += fabs(index->clients[k]->ret->error[l][m][n]);
						}
					}
				}
				index->clients[k]->c_error /= index->clients[k]->ret->num_pat;
				if (!finite(index->clients[k]->c_error))
				{
					index->clients[k]->c_error = SATURATION;
				}
			}
			break;
		}
		case 2: 
		{
			for (k=0; k< index->num_client; k++)
			{
				for (l=0; l< index->clients[k]->ret->num_pat ; l++)
				{
					for (m=0 ; m< index->clients[k]->ret->num_output; m++)
					{
						for (n=0 ; n< index->clients[k]->ret->num_elem[l]; n++)
						{
							if (!finite(index->clients[k]->ret->error[l][m][n]))
							{
								index->clients[k]->c_error = SATURATION;
								break;
							}
							else
							{
								index->clients[k]->c_error = (index->clients[k]->c_error > 
											fabs(index->clients[k]->ret->error[l][m][n])) ? 
											index->clients[k]->c_error : fabs(index->clients[k]->ret->error[l][m][n]);
							}
						}
					}
				}
			}
			break;
		}
		default :
		{
			for (k=0; k< index->num_client; k++)
			{
				for (l=0; l< index->clients[k]->ret->num_pat ; l++)
				{
					for (m=0 ; m< index->clients[k]->ret->num_output; m++)
					{
						for (n=0 ; n< index->clients[k]->ret->num_elem[l]; n++)
						{
							index->clients[k]->c_error += pow(index->clients[k]->ret->error[l][m][n],2);
						}
					}
				}
				index->clients[k]->c_error /= index->clients[k]->ret->num_pat;
				index->clients[k]->c_error = pow(index->clients[k]->c_error,0.5);
				if (!finite(index->clients[k]->c_error))
				{
					index->clients[k]->c_error = SATURATION;
				}
			}
			break;
		}
	}
	
	/* Get error_min, range */
	/* Set initial values for error_min and error_max */
	k=0;
	while (k< index->num_client)
	{
		if (finite(index->clients[k]->c_error) && (index->clients[k]->c_error > 0))
		{
			error_max = index->clients[k]->c_error;
			error_min = index->clients[k]->c_error;
			break;
		}
		else
		{
			k++;
		}
	}

	for (k=0; k< index->num_client; k++)
	{
		if (finite(index->clients[k]->c_error))
		{
			error_max = (error_max > index->clients[k]->c_error ) ? 
								error_max : index->clients[k]->c_error;
			error_min = (error_min > index->clients[k]->c_error ) ? 
								index->clients[k]->c_error : error_min;
		}
	}
	range = (error_max > error_min) ? error_max - error_min : 1.0;
	
	switch(conf->fitness_mode)
	{
		case 1:
		{
			for (k=0; k< index->num_client; k++)
			{
				/* 1 + base*(1 - (error - error_min)/error_range)^(1/boost) */
				if (index->clients[k]->command == 3)
				{
					index->clients[k]->fitness = 1 + 
							base*pow( (1 - (index->clients[k]->c_error - error_min)/range),(1.0/boost));
				}
				else 
				{
					index->clients[k]->fitness = 0.0;
				}
			} 
		}
		default :
		{
			for (k=0; k< index->num_client; k++)
			{
				/* base^(-(error - error_min)*boost / error_range) */
				if (index->clients[k]->command == 3)
				{
					index->clients[k]->fitness =  pow(base, (index->clients[k]->c_error - error_min)*boost/range);
				}
				else
				{
					index->clients[k]->fitness = 0.0;
				}
			} 
		}
	}
	
	return(0);
}
