/*  ga_load_pattern.c */
/* 	Copyright 2004-2006 Oswaldo Morizaki Hirakata */
/* 	This file is part of ga-nn-ag-2 

    ga-nn-ag is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    ga-nn-ag is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with ga-nn-ag; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "my_header.h"
#include "aux_prot.h"

/*
Allocate pattern index, and all it's elements 

*/

void * ga_load_pattern(struct ga_server_config * conf,
						 struct ga_pat_index * index)
{
int k,l,m,n;
int temp;
int temp1;
int num_cat;
int counter;
int output_flag;

char char_buffer[NAME_MAX + 1];
char char_temp[NAME_MAX + 1];

DIR * in_dir;
DIR * out_dir;

FILE * in_file;
FILE * out_file;

struct dirent * dir;

struct io_block * temp_block = NULL;

char_buffer[NAME_MAX] = '\0';
char_temp[NAME_MAX] = '\0';

/* Check if index is NULL */
if (index != NULL)
{
	syslog(LOG_CRIT,"Error, not NULL ga_pat_index in ga_load_pattern");
	return(NULL);
}

/* Open directories */
if (!(in_dir = opendir(conf->input_dir)))
{
	syslog(LOG_CRIT,"Error opendir %s in ga_load_pattern", conf->input_dir);
	return(NULL);
}
if (!(out_dir = opendir(conf->output_dir)))
{
	syslog(LOG_CRIT,"Error opendir %s in ga_load_pattern", conf->output_dir);
	return(NULL);
}

//syslog(LOG_INFO,"PASS 0");

/* Get dimensions and reserve memory */
/* input filename format = %s_cat%d_%d: input_preffix, category, pattern  */
/* Number of categories (input) */
snprintf(char_buffer, NAME_MAX, "%s_cat\0",conf->input_preffix);

if ((num_cat = ga_get_num_file(in_dir, char_buffer)) < 0)
{
	syslog(LOG_CRIT,"Error ga_get_num_file in ga_load_pattern for input");
	return(NULL);
}
else if (num_cat == 0)
{
	syslog(LOG_CRIT,"Error, no inputs");
	return(NULL);
}

/* Number of categories (output) */
snprintf(char_buffer, NAME_MAX, "%s_cat\0",conf->output_preffix);
if ((temp = ga_get_num_file(out_dir, char_buffer)) < 0)
{
	syslog(LOG_CRIT,"Error ga_get_num_file in ga_load_pattern for output");
	return(NULL);
}
else if (temp == 0)
{
	syslog(LOG_CRIT,"Error, no outputs");
	return(NULL);
}

//syslog(LOG_INFO, "temp = %d, num_cat = %d", temp, num_cat);

/* Check if input and ouput has the same number of categories */
if (temp != num_cat)
{
	syslog(LOG_CRIT,"Error, not equal number of categories in input and output");
	return(NULL);
}

/* Calloc index */
if (!(index = (struct ga_pat_index *)calloc(1, sizeof(struct ga_pat_index))))
{
	syslog(LOG_CRIT,"Error calloc index in ga_load_pattern: %s", strerror(errno));
	return(NULL);
}
if (!(index->cat = (struct ga_pat_cat **)calloc(num_cat, sizeof(struct ga_pat_cat*))))
{
	syslog(LOG_CRIT,"Error calloc index->cat in ga_load_pattern: %s", strerror(errno));
	return(NULL);
}
index->num_cat = num_cat;
index->group_mode = conf->pat_group_mode;
index->pat_curr_gen = 0;

//syslog(LOG_INFO,"PASS 1");
//syslog(LOG_INFO,"num_cat= %d", index->num_cat);


for (k=0 ; k < index->num_cat ; k++)
{
	index->cat[k]->group_mode = conf->pat_group_mode;

	/* Get number of elements per category */
	snprintf(char_buffer, NAME_MAX, "%s_cat%d_\0",conf->input_preffix,k);
	if ((temp = ga_get_num_file(in_dir, char_buffer)) < 0)
	{
		syslog(LOG_CRIT,"Error ga_get_num_file in ga_load_pattern: %d", k);
		return(NULL);
	}
	snprintf(char_buffer, NAME_MAX, "%s_cat%d_\0",conf->output_preffix,k);
	if ((temp1 = ga_get_num_file(out_dir, char_buffer)) < 0)
	{
		syslog(LOG_CRIT,"Error ga_get_num_file in ga_load_pattern: %d", k);
		return(NULL);
	}

//syslog(LOG_INFO,"temp = %d, temp1 = %d",temp, temp1);
//syslog(LOG_INFO,"PASS 1.1");
	
	/* Check if category is empty */
	if ((temp == 0) || (temp1 == 0)) 
	{
		syslog(LOG_INFO,"Empty category, neither input nor output exist: cat=%d num_in=%d num_out=%d", 
					k,temp,temp1);
		index->cat[k] = NULL;
	}
	else
	{
		/* Memory reserve for category */
		if (!(index->cat[k] = (struct ga_pat_cat *)calloc(1, sizeof(struct ga_pat_cat))))
		{
			syslog(LOG_CRIT,"Error calloc index->cat[%d] in ga_load_pattern: %s",k, strerror(errno));
			return(NULL);
		}
		
		/* Memory reserve patterns */
		index->cat[k]->pat_cat = k;
		index->cat[k]->num_pat = temp;
		
		if (!(index->cat[k]->pat = (struct ga_pattern **)calloc(index->cat[k]->num_pat, sizeof(struct ga_pattern *))))
		{
			syslog(LOG_CRIT,"Error calloc index->cat[%d]->pat in ga_load_pattern: %s",k, strerror(errno));
			return(NULL);
		}

//syslog(LOG_INFO,"PASS 1.2 (inputs)");

		/******************************************/
		/*                 INPUTS                 */
		/******************************************/
		for (l =0; l< index->cat[k]->num_pat; l++)
		{
			/* Open input pattern file */
			snprintf(char_buffer,NAME_MAX, "%s/%s_cat%d_%d\0",conf->input_dir,
							conf->input_preffix, k, l);
			if (!(in_file = fopen(char_buffer, "r")))
			{
				syslog(LOG_ERR,"Error couldn't open %s", char_buffer);
				index->cat[k]->pat[l] = NULL;
			}
			else
			{
				/* Memory reserve for pattern */
				if (!(index->cat[k]->pat[l] = (struct ga_pattern *)calloc(1, sizeof(struct ga_pattern))))
				{
					syslog(LOG_CRIT,"Error calloc index->cat[%d]->pat[%d] in ga_load_pattern: %s",k,l, strerror(errno));
					return(NULL);
				}
				index->cat[k]->pat[l]->num_input = conf->nn_num_input;
				index->cat[k]->pat[l]->num_output = conf->nn_num_output;
				index->cat[k]->pat[l]->pat_cat = k;

				/* Memory reserve for in_pattern */
				if (!(index->cat[k]->pat[l]->in_pattern = (float **)calloc(index->cat[k]->pat[l]->num_input, 
																		sizeof(float *))))
				{
					syslog(LOG_CRIT,"Error calloc index->cat[%d]->pat[%d]->in_pattern in ga_load_pattern: %s",k,l, strerror(errno));
					return(NULL);
				}
				index->cat[k]->pat[l]->pat_fitness = NULL;

				/* Get input pattern elements */
				for (m=0; m< index->cat[k]->pat[l]->num_input; m++)
				{
				
					/* Calloc temp_block */
					if (!(temp_block = (struct io_block *)va_calloc_io_block(
													0,0,BUFFSIZE, temp_block)))
					{
						syslog(LOG_CRIT,"Error va_calloc_io_block in ga_load_pattern: %s", strerror(errno));
						return(NULL);
					}
					/* Read an input row, and unpack */
					if(!(fgets(temp_block->pack_vector, BUFFSIZE, in_file)))
					{
						syslog(LOG_CRIT,"Error fgets in ga_load_pattern: %s", strerror(errno));
						return(NULL);
					}
					
/* Required for bug FC4 GCC 4.02 */					
syslog(LOG_INFO,"input pattern [%d][%d][%d], pack_vector = %s",k,l,m, temp_block->pack_vector);					
					
					if (!(temp_block = (struct io_block *)va_unpack_io_block(temp_block, ELEM_SEP)))
					{
						syslog(LOG_CRIT,"Error va_unpack_io_block in ga_load_pattern k=%d, l=%d, m=%d",
									k,l,m);
						return(NULL);
					}
					
					/* Memory reserve for pattern elements per input */
					index->cat[k]->pat[l]->num_elem_input = temp_block->num;

					
					if (!(index->cat[k]->pat[l]->in_pattern[m] = (float *)calloc(
											temp_block->num, sizeof(float ))))
					{
						syslog(LOG_CRIT,"Error calloc index->cat[%d]->pat[%d]->in_pattern[%d] in ga_load_pattern: %s",
												k,l,m, strerror(errno));
						return(NULL);
					}

					
					/* Load pattern values */
					for (n=0; n< index->cat[k]->pat[l]->num_elem_input; n++)
					{
					
//syslog(LOG_INFO,"k=%d l=%d m=%d temp_block->char_vector[%d]=%s",k,l,m,n,temp_block->char_vector[n]);
					
						index->cat[k]->pat[l]->in_pattern[m][n] = atof(temp_block->char_vector[n]);
					}
					
					/* Free temp_block */
					temp_block = (struct io_block *)va_delete_io_block(-1, temp_block);
				}	
				/* Close file */
				fclose(in_file);
			}
		}
		/******************************************/
		/*               END INPUTS               */
		/******************************************/

//syslog(LOG_INFO,"PASS 1.3 (outputs)");

		/******************************************/
		/*                 OUTPUTS                */
		/******************************************/
		/* Open output */
		counter = 0;
		for (l =0; l< index->cat[k]->num_pat; l++)
		{
			/* Open input pattern file */
			snprintf(char_buffer,NAME_MAX, "%s/%s_cat%d_%d\0",conf->output_dir,
							conf->output_preffix, k, l);

//syslog(LOG_INFO,"output: %s num_pat=%d", char_buffer, index->cat[k]->num_pat);						

			if ((out_file = fopen(char_buffer, "r")) != NULL)
			{
				counter = 1;
				break;
			}
		}
		/* Check if everything is OK */
		if (!counter)
		{
			syslog(LOG_ERR,"Error, empty category (not empty when load input): %d", k);
			for (l=0; l< index->cat[k]->num_pat; l++)
			{	
				for (m=0; m< index->cat[k]->pat[l]->num_input; m++)
				{
					if (index->cat[k]->pat[l]->in_pattern[m] != NULL)
					{
						free(index->cat[k]->pat[l]->in_pattern[m]);
					}
				}
				if (index->cat[k]->pat[l]->in_pattern != NULL)
				{
					free(index->cat[k]->pat[l]->in_pattern);
				}
				if (index->cat[k]->pat[l] != NULL)
				{
					free(index->cat[k]->pat[l]);
				}
			}
			if (index->cat[k]->pat != NULL)
			{
				free(index->cat[k]->pat);
				index->cat[k]->pat = NULL;
			}
		}
		
		/* Search for a non NULL pattern */
		for (l=0 ; l< index->cat[k]->num_pat; l++)
		{
			if (index->cat[k]->pat[l] != NULL)
			{
				/* Remember which pattern was used */
				counter = l;
				
				/* Memory reserve for out_pattern */
				if (!(index->cat[k]->pat[l]->out_pattern = (float **)calloc(index->cat[k]->pat[l]->num_output, 
																		sizeof(float *))))
				{
					syslog(LOG_CRIT,"Error calloc index->cat[%d]->pat[%d]->out_pattern in ga_load_pattern: %s",k,l, strerror(errno));
					return(NULL);
				}
				
				index->cat[k]->pat[l]->pat_fitness = NULL;
				/* Memory reserve for error */
/*
				if (!(index->cat[k]->pat[l]->error = (float **)calloc(index->cat[k]->pat[l]->num_output, 
																		sizeof(float *))))
				{
					syslog(LOG_CRIT,"Error calloc index->cat[%d]->pat[%d]->error in ga_load_pattern: %s",k,l, strerror(errno));
					return(NULL);
				}
*/
				
				/* Get output pattern elements */
				for (m=0; m< index->cat[k]->pat[l]->num_output; m++)
				{
					/* Calloc temp_block */
					if (!(temp_block = (struct io_block *)va_calloc_io_block(
													0,0,BUFFSIZE, temp_block)))
					{
						syslog(LOG_CRIT,"Error va_calloc_io_block in ga_load_pattern for output: %s",
									 strerror(errno));
						return(NULL);
					}
				
					/* Read an input row, and unpack */
					if(!(fgets(temp_block->pack_vector, BUFFSIZE, in_file)))
					{
						syslog(LOG_CRIT,"Error fgets in ga_load_pattern for output: %s", strerror(errno));
						return(NULL);
					}

/* Required for bug FC4 GCC 4.02 */					
syslog(LOG_INFO,"output pattern [%d][%d][%d], pack_vector = %s",k,l,m, temp_block->pack_vector);					

					if (!(temp_block = (struct io_block *)va_unpack_io_block(temp_block, ELEM_SEP)))
					{
						syslog(LOG_CRIT,"Error va_unpack_io_block in ga_load_pattern for output k=%d, l=%d, m=%d"
									,k,l,m);
						return(NULL);
					}
					
					/* Memory reserve for pattern / error elements per output */
					index->cat[k]->pat[l]->num_elem_output = temp_block->num;
					
					if (!(index->cat[k]->pat[l]->out_pattern[m] = (float *)calloc(
											temp_block->num, sizeof(float ))))
					{
						syslog(LOG_CRIT,"Error calloc index->cat[%d]->pat[%d]->in_pattern[%d] in ga_load_pattern for output: %s",
												k,l,m, strerror(errno));
						return(NULL);
					}
/*
					if (!(index->cat[k]->pat[l]->error[m] = (float *)calloc(
											temp_block->num, sizeof(float ))))
					{
						syslog(LOG_CRIT,"Error calloc index->cat[%d]->pat[%d]->error[%d] in ga_load_pattern for output: %s",
												k,l,m, strerror(errno));
						return(NULL);
					}
*/
					
					/* Load pattern values */
					for (n=0; n< index->cat[k]->pat[l]->num_elem_output; n++)
					{
//syslog(LOG_INFO,"k=%d l=%d m=%d temp_block->char_vector[%d]=%s",	k,l,m,n,temp_block->char_vector[n]);
						index->cat[k]->pat[l]->out_pattern[m][n] = atof(temp_block->char_vector[n]);
					}
					
					/* Free temp_block */
					temp_block = (struct io_block *)va_delete_io_block(-1, temp_block);
				}	
				/* Close file */
				fclose(out_file);
				break;
			}
		}
		
		/* Copy values from index->cat[k]->pat[counter] to the rest of category */
		for (l=0 ; l< index->cat[k]->num_pat; l++)
		{
			if (l != counter)
			{
				if (index->cat[k]->pat[l] != NULL)
				{
					/* Memory reserve for out_pattern */
					if (!(index->cat[k]->pat[l]->out_pattern = (float **)calloc(index->cat[k]->pat[l]->num_output, 
																			sizeof(float *))))
					{
						syslog(LOG_CRIT,"Error calloc index->cat[%d]->pat[%d]->out_pattern in ga_load_pattern: %s",k,l, strerror(errno));
						return(NULL);
					}

					/* Memory reserve for error */
/*
					if (!(index->cat[k]->pat[l]->error = (float **)calloc(index->cat[k]->pat[l]->num_output, 
																			sizeof(float *))))
					{
						syslog(LOG_CRIT,"Error calloc index->cat[%d]->pat[%d]->error in ga_load_pattern: %s",k,l, strerror(errno));
						return(NULL);
					}	
*/
							
					/* Copy values from index->cat[k]->pat[counter] to index->cat[k]->pat[l] */
					for (m=0; m< index->cat[k]->pat[l]->num_output ; m++)
					{
						/* Memory reserve for out_pattern[m] and error[m] */
						index->cat[k]->pat[l]->num_elem_output = index->cat[k]->pat[counter]->num_elem_output;	
						if (!(index->cat[k]->pat[l]->out_pattern[m] = (float *)calloc(
								index->cat[k]->pat[counter]->num_elem_output, sizeof(float))))
						{
							syslog(LOG_CRIT,"Error calloc index->cat[%d]->pat[%d]->in_pattern[%d] in ga_load_pattern for output: %s",
												k,l,m, strerror(errno));
							return(NULL);
						}
/*
						if (!(index->cat[k]->pat[l]->error[m] = (float *)calloc(
								index->cat[k]->pat[counter]->num_elem_output, sizeof(float))))
						{
							syslog(LOG_CRIT,"Error calloc index->cat[%d]->pat[%d]->error[%d] in ga_load_pattern for output: %s",
												k,l,m, strerror(errno));
							return(NULL);
						}
*/
						for (n=0 ; n< index->cat[k]->pat[l]->num_elem_output; n++)
						{
							index->cat[k]->pat[l]->out_pattern[m][n] = index->cat[k]->pat[counter]->out_pattern[m][n];	
						}
					}
				}
			}
		}
		/******************************************/
		/*              END OUTPUTS               */
		/******************************************/
	}
}
//syslog(LOG_INFO,"PASS 3");


closedir(in_dir);
closedir(out_dir);

/* Mark random stable patterns */
/* Up to 50 % stable, minimum 1 stable */
for (k= 0; k< index->num_cat; k++)
{
	index->cat[k]->num_stable = 0;
	for (l=0; l< index->cat[k]->num_pat; l++)
	{
		index->cat[k]->pat[temp1]->stable = 0;
	}

	temp = va_dice_toss(k+index->cat[k]->num_pat, index->cat[k]->num_pat);
	temp /= 2;
	temp += 1;
	
	for (l=0; l< temp; l++)
	{
		temp1 = va_dice_toss(l,index->cat[k]->num_pat);
		if (!(index->cat[k]->pat[temp1]->stable))
		{
			index->cat[k]->num_stable += 1;
		}
		index->cat[k]->pat[temp1]->stable = 1;
	}
}

temp_block = (struct io_block *)va_free_io_block(temp_block);

return(index);
}
