/*  ga_delete_client_index.c */
/* 	Copyright 2004-2006 Oswaldo Morizaki Hirakata */

/* 	This file is part of ga-nn-ag-2.

    ga-nn-ag is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    ga-nn-ag is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with ga-nn-ag; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "my_header.h"
#include "aux_prot.h"

/* 
Deletes client from index
*/

void * ga_delete_client_index(struct ga_service_client_info * client,
															struct ga_service_client_index * index)
{
	ga_errno = 0;
	int k,l;
	int client_pos;
	int client_offset;
	int is_client_unique;
	int temp_num_client;
	int temp_num_addr;
	
	struct ga_service_client_index * temp_index = NULL;
	
	/* Check if client is in index */
	if ((client_pos = ga_is_in_client_index(client, index)) > 9)
	{
		client_pos -= 10;
	}
	else
	{
		syslog(LOG_ERR,"Error, client not in index");
		return(index);
	}
	
	/* Set is_client_unique */
	is_client_unique = 0;
	if (client_pos >= index->offsets[index->num_addr - 1])
	{
		client_offset = index->num_addr - 1;
		if (index->offsets[index->num_addr - 1] == index->num_client - 1)
		{
			is_client_unique = 1;
		}
	}
	else
	{
		for (k = 0; k< (index->num_addr - 1) ; k++)
		{	
			if ((client_pos >= index->offsets[k]) && (client_pos <= index->offsets[k+1]) )
			{
				client_offset = k;
				if ((client_pos == index->offsets[k]) && (index->offsets[k+1] = client_pos + 1))
				{
					is_client_unique = 1;
				}
			}
		}
	}
	
	temp_num_client = index->num_client - 1;
	temp_num_addr = (is_client_unique) ? (index->num_addr - 1) : index->num_addr;
	
	/* calloc temp_index */
	if (!(temp_index = (struct ga_service_client_index *)ga_calloc_client_index(
															10,	temp_num_client, temp_num_addr, temp_index) ))
	{
		ga_errno = 2;
		syslog(LOG_CRIT,"Error ga_calloc_client_index() for temp_index in ga_insert_client_index()");
		return(index);
	}
	
	/* Set nums */
	temp_index->num_client = temp_num_client;
	temp_index->num_addr = temp_num_addr;
	
	/* Copy offsets */
	for (k = 0; k< temp_index->num_addr; k++)
	{
		temp_index->offsets[k] = (k < client_offset) ? index->offsets[k] : index->offsets[k+1] -1;
	}
	
	/* Redirect clients */
	for (k = 0; k< temp_index->num_client ; k++)
	{
		temp_index->clients[k] = (k < client_pos) ? index->clients[k] : index->clients[k+1];
	}

	/* free elements client in client_pos */
	index->clients[client_pos]->ret = (struct nn_return_f *)nn_free_return_f(index->clients[client_pos]->net);
	index->clients[client_pos]->pat_index = (struct ga_pat_index *)ga_free_pat_index(index->clients[client_pos]->pat_index);
	free(index->clients[client_pos]);
	index->clients[client_pos] = NULL;

	/* free index */
	index = ga_free_client_index(10, index);

	index = temp_index;

	return(index);
}

