/*  ga_command_server.c */
/* 	Copyright 2004-2005 Oswaldo Morizaki Hirakata */

/* 	This file is part of ga-nn-ag-2.

    ga-nn-ag is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    ga-nn-ag is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with ga-nn-ag; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

/* Command server starts hosts or niches in remote machines */

#include "my_header.h"
#include "aux_prot.h"


int ga_command_server(struct ga_server_config * conf)
{
int commandfd;
int connfd;
int retry;
int run;
int ret;

char char_temp[BUFFSIZE];

pid_t command_pid;

socklen_t comlen;

struct sockaddr_in inet_command_addr;

struct io_block * command_block = NULL;

struct sigaction sig_chld;

syslog(LOG_INFO,"Starting ga_command_server with pid: %d", getpid());

/* Setup command socket */
if ( (commandfd = socket(PF_INET, SOCK_STREAM, 0)) < 0)
{
	syslog(LOG_CRIT,"Error creating command socket");
	return(1);
}
bzero(&inet_command_addr,sizeof(inet_command_addr));
inet_command_addr.sin_family = AF_INET;

if ((ret=inet_pton(AF_INET,conf->command_ip,&inet_command_addr.sin_addr)) < 1)
{
	syslog(LOG_CRIT,"Error inet_pton() in command_server() %d: %s",ret,strerror(errno));
	return(1);
}

syslog(LOG_INFO,"conf->command_port = %d",conf->command_port);


inet_command_addr.sin_port = htons((uint16_t)(conf->command_port));

if ( (bind(commandfd, (struct sockaddr *) &inet_command_addr, sizeof(inet_command_addr)) ) < 0)
{
	syslog(LOG_CRIT,"Error Binding command socket: %s",strerror(errno));
	return(1);
}

/* Setup command_block */
if (!(command_block = (struct io_block *)va_calloc_io_block(0,0,0,command_block) ))
{
	syslog(LOG_CRIT,"Error va_calloc_io_block()");
	return(1);
}

/* Set sigaction for SIGCHLD handling */
sigemptyset(&sig_chld.sa_mask);
sig_chld.sa_sigaction = ga_command_sig_chld;
sig_chld.sa_flags = 0;
sig_chld.sa_flags |= SA_RESTART;
sig_chld.sa_flags |= SA_NOMASK;
if (sigaction(SIGCHLD, &sig_chld, NULL) < 0)
{
	syslog(LOG_CRIT,"Couldn't set SIGCHLD handler");
	return(-1);
}

if ( (listen(commandfd,LISTENQ)) <0 )
{
	syslog(LOG_CRIT,"Error listenning command socket: %s",strerror(errno));
	return(1);
}

syslog(LOG_INFO,"ga_command_server ready to accept connections");

/* Accept connection */
while (1)
{
	comlen = sizeof(inet_command_addr);
	if ( (connfd = accept(commandfd, (struct sockaddr *) &inet_command_addr, &comlen)) <0 )
	{
		if (errno == EINTR)
		{
			continue;
		}
		else
		{
			syslog(LOG_CRIT,"Accept error Command Server: %s",strerror(errno));
			return;
		}
	}
	
	if ((command_pid = fork())< 0)
	{
		syslog(LOG_CRIT,"Fork error command");
		return(1);
	}
	else if(command_pid == 0)
	{
		close(connfd);
		close(commandfd);
		
		/* Setting up connfd in command_block */
		command_block->connfd = connfd;
		
		/* Read command_block */
		retry = 0;
		while (1)
		{
			command_block = (struct io_block *)va_dread_io_block(command_block);
			if (command_block->num == 0)
			{
				retry ++;
			}
			else 
			{
				break;
			}
			
			if (retry == MAX_RETRY)
			{
				syslog(LOG_CRIT,"Error reading command_block, exiting");
				return(1);
			}
		}
		
		/* Delete first element of command_block (num) */
		command_block = (struct io_block *)va_delete_io_block(0,command_block);
		
		/* Check command READ */
		if (!strncmp("READFILE",command_block->char_vector[0],8) )
		{
			if (!strncmp("SAME",command_block->char_vector[0]+9,4) ) // Read same file
			{
			
			}
			/* Set new config file name */
			else
			{
				strcpy(conf->config_filename, command_block->char_vector[0]+9);
			}
		}
		/* Read from socket a new config file */
		else if (!strncmp("READINET",command_block->char_vector[0],8) )
		{
			/* Get name */
			strncpy(char_temp,command_block->char_vector[0]+9,BUFFSIZE);
			char_temp[BUFFSIZE] = '\0';
			
			/* Delete first element of command_block (READINET=name) */
			command_block = (struct io_block *)va_delete_io_block(0,command_block);
			
			/* Write to file */
			if (va_fwrite_io_block(command_block, char_temp) <0)
			{
				syslog(LOG_CRIT,"Error va_fwrite_io_block()");
				return(1);
			}
			
			/* Set new config file name */
			strcpy(conf->config_filename, char_temp);
		}
		
		/* Reload config file */
		if ((run = ga_server_load_config(conf, conf->config_filename)) < 0)
		{
			syslog(LOG_CRIT,"Error reloading ga_server_config, exiting");
			return(1);
		}
		
		/* Now run with the new values */
		if (run != 1)
		{	
			syslog(LOG_ERR,"Warning, run != 1");
		}
		
		/* Start service server */
		if (ga_service_server(conf) != 0)
		{
			syslog(LOG_CRIT,"Error in ga_service_server()");
			return(1);
		}
	}
}

return(0);
}
