/*  ga_is_in_client_index.c */
/* 	Copyright 2004-2005 Oswaldo Morizaki Hirakata */

/* 	This file is part of ga-nn-ag-2.

    ga-nn-ag is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    ga-nn-ag is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with ga-nn-ag; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "my_header.h"
#include "aux_prot.h"

/* 
Return value: 
-	10 if client is not in index, but addr is
-	1 if client is in index
-	0 if neither client nor addr aren't in index
*/

int ga_is_in_client_index(struct ga_service_client_info * client,
										struct ga_service_client_index * index)
{
	int k,l;
	int range;
	int lower;
	int is_addr;
	
	is_addr = 0;
	for (k = 0; k< index->num_addr; k++)
	{
		if (client->addr.sin_addr.s_addr == index->addr[k]->sin_addr.s_addr)
		{
			is_addr = 10;
			lower = index->offsets[k];		
			range = index->offsets[k+1] - index->offsets[k];
			for (l = 0; l< range; l++)
			{
				if (client->id == index->clients[lower + l]->id) 
				{
					is_addr = 1;
					break;
				}
			}
			break;
		}
	}
	return(is_addr);
}
