/*  read_ga_server_remote_config.c */

/* 	Copyright 2004 Oswaldo Morizaki */

/* 	This file is part of ga-nn-ag.

    ga-nn-ag is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    ga-nn-ag is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with ga-nn; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "my_header.h"
#include "aux_prot.h"

int read_ga_server_remote_config(struct ga_server_config *conf, int descriptor)
{
	int k;
	int counter;
	char char_temp[BUFFSIZE];

	readn(descriptor,char_buffer,BUFFSIZE);
//	syslog(LOG_INFO,char_buffer);
	
	while( (strncmp(char_buffer,"EOC",3)) )
	{
		if (!strncmp(char_buffer,"max_local",9))
		{
			conf->max_local=atoi(char_buffer+10);
			syslog(LOG_INFO,"max_local = %d",conf->max_local);
		}
		else if (!strncmp(char_buffer,"first_local",11))
		{
			conf->first_local=atoi(char_buffer+12);
			syslog(LOG_INFO,"first_local = %d",conf->first_local);
		}
		else if (!strncmp(char_buffer,"last_local",10))
		{
			conf->last_local=atoi(char_buffer+11);
			syslog(LOG_INFO,"last_local = %d",conf->last_local);
		}
		else if (!strncmp(char_buffer,"local_server_port",17))
		{
			conf->local_server_port=atoi(char_buffer+18);
			syslog(LOG_INFO,"local_server_port = %d",conf->local_server_port);
		}
		else if (!strncmp(char_buffer,"poblation",9))
		{
			conf->poblation=atoi(char_buffer+10);
			syslog(LOG_INFO,"poblation = %d",conf->poblation);
		}
		else if (!strncmp(char_buffer,"generations",11))
		{
			conf->generations=atoi(char_buffer+12);
			syslog(LOG_INFO,"generations = %d",conf->generations);
		}
		else if (!strncmp(char_buffer,"max_neuron_mut",14))
		{
			conf->max_neuron_mut=atoi(char_buffer+15);
			syslog(LOG_INFO,"max_neuron_mut = %d",conf->max_neuron_mut);
		}
		else if (!strncmp(char_buffer,"max_num_layer",13))
		{
			conf->max_num_layer=atoi(char_buffer+14);
			syslog(LOG_INFO,"max_num_layer = %d",conf->max_num_layer);
		}		
		else if (!strncmp(char_buffer,"max_num_neuron",14))
		{
			conf->max_num_neuron=atoi(char_buffer+15);
			syslog(LOG_INFO,"max_num_neuron = %d",conf->max_num_neuron);
		}
		else if (!strncmp(char_buffer,"agregation",10))
		{
			conf->agr=atoi(char_buffer+11);
			syslog(LOG_INFO,"agregation = %d",conf->agr);
		}
		else if (!strncmp(char_buffer,"ip",2))
		{
			strcpy(conf->ip,(char_buffer+3));
			syslog(LOG_INFO,"Master server = %s",conf->ip);
		}
		else if (!strncmp(char_buffer,"init_preffix",12))
		{
			strcpy(conf->init_preffix,(char_buffer+13));
			syslog(LOG_INFO,"init_preffix = %s",conf->init_preffix);
		}
		else if (!strncmp(char_buffer,"result_preffix",14))
		{
			strcpy(conf->result_preffix,(char_buffer+15));
			syslog(LOG_INFO,"result_preffix = %s",conf->result_preffix);
		}
	
		readn(descriptor,char_buffer,BUFFSIZE);
	}
	syslog(LOG_INFO,"Remote server config read");
	return(1);
}
