/*  read_neuron_array.c */

/* 	Copyright 2004 Oswaldo Morizaki */

/* 	This file is part of ga-nn-ag.

    ga-nn-ag is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    ga-nn-ag is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with ga-nn; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "my_header.h"
#include "aux_prot.h"

int read_neuron_array(int num_neuron, struct neuron ** neuron_array,	int fd)
{
	int k,l,m,n,o,p;
	double temp[4];
	char char_temp[BUFFSIZE];

	for (k=0; k< num_neuron;k ++)
	{
		readn(fd,char_buffer,BUFFSIZE);				//neuron number
		readn(fd,char_buffer,BUFFSIZE);
		neuron_array[k]->alpha=atof(char_buffer+6);		 	//alpha
		readn(fd,char_buffer,BUFFSIZE);
		neuron_array[k]->conv_rate=atof(char_buffer+10);		//conv_rate
		readn(fd,char_buffer,BUFFSIZE);
		neuron_array[k]->bias_corr=atoi(char_buffer+10);		//bias_correction
		readn(fd,char_buffer,BUFFSIZE);
		neuron_array[k]->delta_type=atoi(char_buffer+11);	//delta_type
		readn(fd,char_buffer,BUFFSIZE);
		neuron_array[k]->momentum=atoi(char_buffer+9);		//momentum

//		syslog(LOG_INFO,"neuron_array[%d]->momentum = %d",k,neuron_array[k]->momentum);
				
		readn(fd,char_buffer,BUFFSIZE);
		neuron_array[k]->x_c=atof(char_buffer+4);				//x_c
		readn(fd,char_buffer,BUFFSIZE);
		neuron_array[k]->y_c=atof(char_buffer+4);				//y_c
		readn(fd,char_buffer,BUFFSIZE);
		neuron_array[k]->range=atof(char_buffer+6);			//range
		readn(fd,char_buffer,BUFFSIZE);
		l=atoi(char_buffer+8); 
		neuron_array[k]->num_con=l;								//num_con

		if (l)
		{
			if ( !(neuron_array[k]->con_x = (float *)calloc(l,sizeof(float)) ))
			{
				syslog(LOG_CRIT,"Error calloc neuron_array[%d]->con_x\n",k);
				return(-1);
			}
			if ( !(neuron_array[k]->con_y = (float *)calloc(l,sizeof(float)) ))
			{
				syslog(LOG_CRIT,"Error calloc neuron_array[%d]->con_y\n",k);
				return(-1);
			}
			if( !(neuron_array[k]->con_w = (double *)calloc(l,sizeof(double)) ))
			{
				syslog(LOG_CRIT,"Error calloc neuron_array[%d]->con_w\n",k);
				return(-1);
			}
			if( !(neuron_array[k]->age = (int *)calloc(l,sizeof(int)) ))
			{
				syslog(LOG_CRIT,"Error calloc neuron_array[%d]->age\n",k);
				return(-1);
			}

			if (neuron_array[k]->momentum == 1)
			{
				if ( !(neuron_array[k]->delta_con_w = (double *)calloc(l,sizeof(double)) ))
				{
					syslog(LOG_CRIT,"Error calloc neuron_array[%d]->delta_con_w\n",k);
					return(-1);
				}
			}
		}
		else		
		{
			neuron_array[k]->con_x = NULL;
			neuron_array[k]->con_y = NULL;
			neuron_array[k]->con_w = NULL;
			neuron_array[k]->age = NULL;
			neuron_array[k]->delta_con_w = NULL;
		}
				
		readn(fd,char_buffer,BUFFSIZE);
		neuron_array[k]->bias=atof(char_buffer+5);			//bias
				
		for (m=0; m<l; m++)
		{
			readn(fd,char_buffer,BUFFSIZE);
			o=0;
			p=0;
			for (n=0;n<BUFFSIZE;n++)
			{
				char_temp[n-o]=char_buffer[n];
				if ( (char_buffer[n] == ':') || (char_buffer[n] == '\0') )
				{
					char_temp[n-o]='\0';
					o=n+1;
					temp[p]=atof(char_temp);
					p++;
					if ((char_buffer[n] == '\0'))
					{
	 					break;
					}
				}
			}
						
			*(neuron_array[k]->con_x+m)=temp[0];
			*(neuron_array[k]->con_y+m)=temp[1];
			*(neuron_array[k]->con_w+m)=temp[2];
			*(neuron_array[k]->age + m)=(int)temp[3];
		}
	}
	readn(fd,char_buffer,BUFFSIZE);  // END
	p=strncmp(char_buffer,"END",3);
	return(p);
}
