/*  ga_server.c */
/* 	Copyright 2004 Oswaldo Morizaki */

/* 	This file is part of ga-nn-ag.

    ga-nn-ag is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    ga-nn-ag is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with ga-nn; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "my_header.h"
#include "aux_prot.h"

jmp_buf jump_niche;


int main(void)
{
int k,l,m,n,o,p;
int poblation;
int counter;
int max_fd;
int ready_fd;
int generations;
int max_neuron_mut;
int gen;
int status;
int exit_flag;
int agr;
int lifespan;
int local;
int max_local;
int num_hosts;
int connfd_remote;
int connfd_niche;
int retry;
int num_niche;
int niche_flag;

int local_server_port;
int remote_server_port;

pid_t pid;
pid_t pid_temp;
socklen_t clilen;

int *listenfd;
int *connfd;
int *connected;
int *num_neuron;
int *new_num_neuron;
int *inner_elem1;
int *inner_elem2;

float base;
float boost;
float mut_neuron_prob;
float mut_net_prob;
float level;
float mut_new_prob;
float max_local_f;
float poblation_f;
float inm_prob;

float *fitness;
double *error;

int **parents;

float **vertice;

fd_set read_set,write_set,ex_set;

struct sockaddr_un cli_un_addr, serv_un_addr;
struct sockaddr_in cli_in_addr, serv_in_addr;
struct sockaddr_in serv_in_addr_remote;
struct ga_server_config ga_conf;
struct ga_server_config ga_conf_temp;
struct individual ** net_array;
struct neuron ** parent1;
struct neuron ** parent2;

char char_temp[BUFFSIZE];
char ** char_vector;

if( (pid = fork()) <0 )
{
	printf("Error fork: %s\n",strerror(errno));
	
}
else if (pid != 0)
{
	printf("ga_server started pid=%d\n",getpid());
	exit(0);
}

setsid();
openlog("ga_server",LOG_PID,LOG_LOCAL0);
syslog(LOG_INFO,"Daemon started");

load_ga_server_config(&ga_conf, "ga_server_config");

poblation =	ga_conf.poblation;
generations =	ga_conf.generations;
boost =	ga_conf.boost;
base = ga_conf.base;
max_neuron_mut = ga_conf.max_neuron_mut;
mut_new_prob = ga_conf.mut_new_prob;
mut_neuron_prob = ga_conf.mut_neuron_prob;
mut_net_prob = ga_conf.mut_net_prob;
level = ga_conf.level;
agr = ga_conf.agr;
lifespan = ga_conf.lifespan;
local_server_port = ga_conf.local_server_port;
remote_server_port = ga_conf.remote_server_port;
max_local =	ga_conf.max_local;
num_hosts =	ga_conf.num_hosts;
inm_prob = ga_conf.inm_prob;

poblation_f = poblation;
max_local_f = max_local;

num_niche = ga_conf.num_niche;

if (!strncmp(ga_conf.ip,"127.0.0.1",9))
{
	local = 1;
}
else
{
	local = 0;
}

if ((poblation / max_local) > num_hosts + 1)
{
	syslog(LOG_CRIT,"Not enough hosts");
	return(1);
}

if (ga_conf.num_niche > 0)
{
	if ( mkfifo("niche_fifo",FILE_MODE) <0)
	{
		syslog(LOG_CRIT,"Error creating fifo for local NICHE SERVER:%s",strerror(errno));
//		return(1);
	}	
}

exit_flag=0;
niche_flag=0;

if( !(connfd = (int *)calloc(poblation,sizeof(int)) ))
{
	syslog(LOG_CRIT,"Error calloc connfd: %s",strerror(errno));
	return(1);
}
if ( !(listenfd = (int *)calloc(poblation,sizeof(int)) ))
{
	syslog(LOG_CRIT,"Error calloc listenfd: %s",strerror(errno));
	return(1);
}
if ( !(connected = (int *)calloc(poblation,sizeof(int)) ))
{
	syslog(LOG_CRIT,"Error calloc connected: %s",strerror(errno));
	return(1);
}

for (k=0; (k < max_local) && (k< poblation); k++)
{
	if ( (listenfd[k] = socket(PF_LOCAL, SOCK_STREAM, 0)) < 0)
	{
		syslog(LOG_CRIT,"Error creating listen socket");
		return(1);
	}
	bzero(&serv_un_addr,sizeof(serv_un_addr));
	serv_un_addr.sun_family = PF_LOCAL;
	sprintf(char_buffer,"unix%d.str",k);
	unlink(char_buffer);
	strcpy(serv_un_addr.sun_path,char_buffer);
	
	if ( (bind(listenfd[k], (struct sockaddr *) &serv_un_addr, sizeof(serv_un_addr)) ) < 0)
	{
		syslog(LOG_CRIT,"Error Binding socket: %d %s",k,strerror(errno));
		return(1);
	}
	if ( (listen(listenfd[k],LISTENQ)) <0 )
	{
		syslog(LOG_CRIT,"Error listenning %d %s",k,strerror(errno));
		return(1);
	}
}

for (k=max_local; k < poblation; k++)
{
	if ( (listenfd[k] = socket(PF_INET, SOCK_STREAM, 0)) < 0)
	{
		syslog(LOG_CRIT,"Error creating listen socket");
		return(1);
	}
	bzero(&serv_in_addr,sizeof(serv_in_addr));
	serv_in_addr.sin_family = PF_INET;
	
	if (inet_pton(AF_INET,ga_conf.ip,&serv_in_addr.sin_addr) < 1)
	{
		syslog(LOG_CRIT,"Error inet_pton() %d %s",k,strerror(errno));
		return(1);
	}
	serv_in_addr.sin_port = htons((uint16_t)(local_server_port + k));

	if ( (bind(listenfd[k], (struct sockaddr *) &serv_in_addr, sizeof(serv_in_addr)) ) < 0)
	{
		syslog(LOG_CRIT,"Error Binding socket: %d %s",k,strerror(errno));
		return(1);
	}
	if ( (listen(listenfd[k],LISTENQ)) <0 )
	{
		syslog(LOG_CRIT,"Error listenning %d %s",k,strerror(errno));
		return(1);
	}
}

if ( (pid = fork()) < 0)
{
	syslog(LOG_CRIT,"Error fork client activation: %s",strerror(errno));
	return(1);
}

/*** Code for SLAVE ELEMENTS ***/
else if (pid==0)
{
	for (k=0;(k < max_local) && (k < poblation); k++)
	{
/*************** Client caller ****************/	
/***************Re design pending *************/	
		if ((pid=fork()) < 0)
		{
			syslog(LOG_CRIT,"Error fork client: %d %s",k,strerror(errno));
			return(1);
		}
		else if (pid==0)
		{
			setsid();
			if ( !(char_vector = (char **)malloc(11*sizeof(char *)) ))
			{
				syslog(LOG_CRIT,"Error malloc char_vector");
				return(1);
			}
			for (l=0; l< 11; l++)
			{
				if ( !(char_vector[l] = (char *)malloc(BUFFSIZE*sizeof(char)) ))
				{
					syslog(LOG_CRIT,"Error malloc char_vector[%d]",l);
					return(1);
				}
			}
			char_vector[10]=NULL;
			sprintf(char_vector[0],"./ga_client\0");
			sprintf(char_vector[1],"%d\0",k);
			sprintf(char_vector[2],"%d\0",ga_conf.max_num_layer);
			sprintf(char_vector[3],"%d\0",ga_conf.max_num_neuron);
			sprintf(char_vector[4],"%d\0",generations);
			sprintf(char_vector[5],"127.0.0.1\0");
			sprintf(char_vector[6],"%d\0",local_server_port+k);
			sprintf(char_vector[7],"%d\0",agr);
			sprintf(char_vector[8],"%s\0",ga_conf.init_preffix);
			sprintf(char_vector[9],"%s\0",ga_conf.result_preffix);

			execvp("./ga_client",char_vector);
		}
	}

	/*** Connection to remote servers ***/
	
	memcpy(&ga_conf_temp, &ga_conf, sizeof(struct ga_server_config));
	
	for (k=1; k< (poblation_f / max_local_f); k++)
	{
		syslog(LOG_INFO,"Using remote server %d",k);
		if ( (connfd_remote = socket(PF_INET, SOCK_STREAM, 0)) < 0)
		{
			syslog(LOG_CRIT,"Error creating socket: %d %s",k,strerror(errno));
			return(1);
		}
			
		bzero(&serv_in_addr_remote, sizeof(serv_in_addr_remote));
		serv_in_addr_remote.sin_family = PF_INET;
		serv_in_addr_remote.sin_port = htons((uint16_t)remote_server_port); 
		
		syslog(LOG_INFO,"remote host: %s",ga_conf.hosts[k-1]);
		
		if (inet_pton(AF_INET,ga_conf.hosts[k-1],&serv_in_addr_remote.sin_addr) < 1)
		{
			syslog(LOG_CRIT,"Error inet_pton() %d %s",k,strerror(errno));
			return(1);
		}
		if( (connect(connfd_remote, (struct sockaddr *) &serv_in_addr_remote, 
								sizeof(serv_in_addr_remote))) <0)
		{
			syslog(LOG_CRIT,"Couldn't connect to remote server: %d %s",k,strerror(errno));
			return(1);
		}
		sprintf(ga_conf_temp.message,"SPAWN\0");
	
		ga_conf_temp.first_local = k*max_local;
		ga_conf_temp.last_local = ((k+1)*max_local > poblation) ? 
															(poblation - 1) : ((k+1)*max_local - 1);
		
		write_ga_server_remote_config(&ga_conf_temp, connfd_remote);
		close(connfd_remote);
	}

	/*** Start remote niches ***/
	
	for (k=0; (k< num_niche) && (ga_conf.master > 0) ; k++)
	{
		syslog(LOG_INFO,"Init remote niche %d",k);
		if ( (connfd_remote = socket(PF_INET, SOCK_STREAM, 0)) < 0)
		{
			syslog(LOG_CRIT,"Error creating socket: %d %s",k,strerror(errno));
			return(1);
		}
			
		bzero(&serv_in_addr_remote, sizeof(serv_in_addr_remote));
		serv_in_addr_remote.sin_family = PF_INET;
		serv_in_addr_remote.sin_port = htons((uint16_t)remote_server_port); 
		
		syslog(LOG_INFO,"remote niche: %s",ga_conf.niches[k]);
		
		if (inet_pton(AF_INET,ga_conf.niches[k],&serv_in_addr_remote.sin_addr) < 1)
		{
			syslog(LOG_CRIT,"Error inet_pton() %d %s",k,strerror(errno));
			return(1);
		}
		if( (connect(connfd_remote, (struct sockaddr *) &serv_in_addr_remote, 
								sizeof(serv_in_addr_remote))) <0)
		{
			syslog(LOG_CRIT,"Couldn't connect to remote server: %d %s",k,strerror(errno));
			return(1);
		}

		sprintf(ga_conf_temp.message,"NICHE\0");
		
		write_ga_server_remote_config(&ga_conf_temp, connfd_remote);
		close(connfd_remote);
	}
	exit(0);
}

/*** Start of LOCAL NICHE for remote connections ***/
/*** Fork NICHE Server (num_niche > 0) ***/

if (ga_conf.num_niche > 0)
{
	if ((pid	= fork()) < 0)
	{
		syslog(LOG_CRIT,"Error in NICHE SERVER, going without it");
	}
	else if (pid == 0)
	{
		free(listenfd);
		free(connfd);
		free(connected);

		if( !(connfd = (int *)calloc(1,sizeof(int)) )) 
		{
			syslog(LOG_CRIT,"Error calloc connfd for local NICHE SERVER: %s",strerror(errno));
			return(1);
		}
		if ( !(listenfd = (int *)calloc(1,sizeof(int)) ))
		{
			syslog(LOG_CRIT,"Error calloc listenfd local NICHE SERVER: %s",strerror(errno));
			return(1);
		}
		if ( !(connected = (int *)calloc(1,sizeof(int)) ))
		{
			syslog(LOG_CRIT,"Error calloc connected local NICHE SERVER: %s",strerror(errno));
			return(1);
		}

			/*
			if (signal(SIGALRM, sig_alarm) == SIG_ERR)
			{
				return(1);
			}
			alarm(ga_conf.time_wait);
			*/
			

		if ( !(num_neuron = (int *)calloc(poblation,sizeof(float)) ))
		{
			syslog(LOG_CRIT,"Error calloc num_neuron: %s",strerror(errno));
			return(1);
		}
		if ( !(new_num_neuron = (int *)calloc(poblation,sizeof(float)) ))
		{
			syslog(LOG_CRIT,"Error calloc num_neuron: %s",strerror(errno));
			return(1);
		}
		if ( !(net_array = (struct individual **)calloc(poblation,sizeof(struct individual *)) ))
		{
			syslog(LOG_CRIT,"Error calloc net_array: %s",strerror(errno));
			return(1);
		}

		for (k=0; k< poblation; k++)
		{
			if ( !(net_array[k] = (struct individual *)calloc(1,sizeof(struct individual)) ))
			{
				syslog(LOG_CRIT,"Error calloc net_array[%d]: %s",k,strerror(errno));
				return(1);
			}
		}

		/*** Listening socket for niche ***/

		if ( (listenfd[0] = socket(PF_INET, SOCK_STREAM, 0)) < 0)
		{
			syslog(LOG_CRIT,"Error creating listen socket");
			return(1);
		}
		bzero(&serv_in_addr,sizeof(serv_in_addr));
		serv_in_addr.sin_family = PF_INET;
	
		if (inet_pton(AF_INET,ga_conf.ip,&serv_in_addr.sin_addr) < 1)
		{
			syslog(LOG_CRIT,"Error inet_pton() %d %s",k,strerror(errno));
			return(1);
		}
		serv_in_addr.sin_port = htons((uint16_t)(local_server_port + k));

		if ( (bind(listenfd[0], (struct sockaddr *) &serv_in_addr, sizeof(serv_in_addr)) ) < 0)
		{
			syslog(LOG_CRIT,"Error Binding socket: %d %s",k,strerror(errno));
			return(1);
		}
		if ( (listen(listenfd[0],LISTENQ)) <0 )
		{
			syslog(LOG_CRIT,"Error listenning %d %s",k,strerror(errno));
			return(1);
		}

		/*** Open niche_fifo in read_only mode ***/
		if( (connfd_niche=open("niche_fifo",O_RDONLY, 0)) <0)
		{
			syslog(LOG_CRIT,"Error openning niche_fifo: %s",strerror(errno));
			return(1);
		}

		/*** Jump point for data reload ***/
		if (setjmp(jump_niche) != 0)
		{
	
		}

		if (niche_flag)
		{
			for (k=0; k< poblation; k++)
			{
				if ( (net_array[k]->neuron_array = (struct neuron **)free_neuron_array(
										num_neuron[k],net_array[k]->neuron_array) ))
				{
					syslog(LOG_CRIT,"Error in free_neuron_array net_array[%d]->neuron_array",k);
					return(1);
				}
			}
		}

		/*** Wait niche_fifo to be ready for reading ***/

		FD_ZERO(&read_set);
		FD_ZERO(&write_set);
		FD_ZERO(&ex_set);
		FD_SET(connfd_niche, &read_set);
		max_fd = connfd_niche + 1;

		if ( (ready_fd=pselect(max_fd, &read_set, &write_set, &ex_set, NULL, NULL)) <0 )
		{
			syslog(LOG_CRIT,"Error in pselect in local NICHE SERVER: %s",strerror(errno));
			return(1);
		}
		if (FD_ISSET(connfd_niche, &read_set) )
		{
			for (k=0; k< poblation; k++)
			{
				if( (readn(connfd_niche,char_buffer,BUFFSIZE)) < 0)
				{
					syslog(LOG_CRIT,"Error reading niche_fifo");
					return(1);
				}
				if ( !(strncmp("neuron_array",char_buffer,12) ) )
				{
					readn(connfd_niche,char_buffer,BUFFSIZE);
					num_neuron[k] = atoi(char_buffer+11);
					syslog(LOG_INFO,"client=%d num_neuron=%d",k,num_neuron[k]);  //required for bug

					if ( !(net_array[k]->neuron_array = (struct neuron **)calloc(
																				num_neuron[k],sizeof(struct neuron *)) ))
					{
						syslog(LOG_CRIT,"Error calloc net_array[%d]->neuron_array: %s",k,
										strerror(errno));
						return(1);
					}

					for (m=0; m< num_neuron[k]; m++)
					{
						if ( !(net_array[k]->neuron_array[m] = (struct neuron *)calloc(
												1,sizeof(struct neuron)) ))
						{
							syslog(LOG_CRIT,"Error calloc net_array[%d]->neuron_array[%d]: %s",k,l,
														strerror(errno));
							return(1);
						}
					}

					/*** read from FIFO net_array ***/
					read_neuron_array(num_neuron[k], net_array[k]->neuron_array, connfd_niche);
				}
			}
		}

		/*** Signal Handler to reload ***/
		niche_flag += 1; 
		if (signal(SIGUSR1,sig_usr1) == SIG_ERR)
		{
			syslog(LOG_CRIT,"Couldn't catch SIGUSR1, exiting");
			return(1);
		}

		/*** Ready for to accept remote connections ***/
		while (1)
		{
			clilen = sizeof(cli_in_addr);
			if ( (connfd[0] = accept(listenfd[0], (struct sockaddr *) &cli_in_addr, &clilen)) <0 )
			{
				if (errno == EINTR)
				{
					continue;
				}
				else
				{
					syslog(LOG_CRIT,"Accept error Inmigration Server: %s",strerror(errno));
					return;
				}
			}
			
			if ((pid = fork())< 0)
			{
				syslog(LOG_CRIT,"Fork error Inmigration Server");
			}
			else if(pid == 0)
			{
				/*** INMIGRATION CODE HERE ***/		
				l = dice_toss(pid,poblation);
				dwrite_neuron_array(num_neuron[l], net_array[l]->neuron_array, connfd[0]);
				exit(0);
			}
		}
	}
	pid_temp = pid; // pid of local NICHE SERVER
}

/************* Code for MASTER SERVER BEGINS HERE **************/
if (ga_conf.num_niche > 0)
{
	if( (connfd_niche=open("niche_fifo",O_WRONLY, 0)) <0)
	{
		syslog(LOG_CRIT,"Error openning niche_fifo for writting: %s",strerror(errno));
		return(1);
	}
}

/*** Accepting clients connections ***/
syslog(LOG_INFO,"Start waiting for client connections");

l=0;
while(1)
{
	if (l==poblation)
	{	
		break;
	}	

	errno = 0;
	for (k=0; (k< max_local) && (k< poblation); k++)
	{
		if (!( *(connected+k) ) )
		{
			clilen = sizeof(cli_un_addr);
			if ( (connfd[k] = accept(listenfd[k], (struct sockaddr *) &cli_un_addr, &clilen)) <0 )
			{
				if (errno == EINTR)
				{
					continue;
				}
				else
				{
					syslog(LOG_CRIT,"Accept error (PF_LOCAL): %s",strerror(errno));
					return(1);
				}
			}
			else
			{
				*(connected+k)=1;
				l++;
				syslog(LOG_INFO,"Connected client: %d",k);
			}
		}
	}

	for (k=max_local; k<poblation; k++)
	{
		if (!( *(connected+k) ) )
		{
			clilen = sizeof(cli_in_addr);
			if ( (connfd[k] = accept(listenfd[k], (struct sockaddr *) &cli_in_addr, &clilen)) <0 )
			{
				if (errno == EINTR)
				{
					continue;
				}
				else
				{
					syslog(LOG_CRIT,"Accept error: %s",strerror(errno));
					return;
				}
			}
			else
			{
				*(connected+k)=1;
				l++;
				syslog(LOG_INFO,"Connected client: %d",k);
			}
		}
	}
}

if ( !(fitness = (float *)calloc(poblation,sizeof(float)) ))
{
	syslog(LOG_CRIT,"Error calloc fitness: %s",strerror(errno));
	return(1);
}
if ( !(error = (double *)calloc(poblation,sizeof(double)) ))
{
	syslog(LOG_CRIT,"Error calloc error: %s",strerror(errno));
	return(1);
}
if ( !(num_neuron = (int *)calloc(poblation,sizeof(float)) ))
{
	syslog(LOG_CRIT,"Error calloc num_neuron: %s",strerror(errno));
	return(1);
}
if ( !(new_num_neuron = (int *)calloc(poblation,sizeof(float)) ))
{
	syslog(LOG_CRIT,"Error calloc new_num_neuron: %s",strerror(errno));
	return(1);
}
if ( !(net_array = (struct individual **)calloc(poblation,sizeof(struct individual *)) ))
{
	syslog(LOG_CRIT,"Error calloc net_array: %s",strerror(errno));
	return(1);
}

if ( !(vertice = (float **)calloc(2,2*sizeof(float *)) ))
{
	syslog(LOG_CRIT,"Error calloc vertice: %s",strerror(errno));
	return(1);
}
for (k=0; k<2; k++)
{
	if ( !(*(vertice+k) = (float *)calloc(2,sizeof(float)) ))
	{
		syslog(LOG_CRIT,"Error calloc vertice[%d]: %s",k,strerror(errno));
		return(1);
	}
}

if ( !(inner_elem1 = malloc(sizeof(int))) || !(inner_elem2 = malloc(sizeof(int))) )
{
	syslog(LOG_CRIT,"Error malloc inner_elem1 / 2");
	return(1);
}

if ( !(parents = (int **)calloc(poblation,2*sizeof(int *)) ))
{
	syslog(LOG_CRIT,"Error calloc parents: %s",strerror(errno));
	return(1);
}
for(k=0; k< poblation; k++)
{
	if( !(*(parents+k) = (int *)calloc(2, sizeof(int)) ))
	{
	syslog(LOG_CRIT,"Error calloc parents[%d]: %s",k,strerror(errno));
	return(1);
	}
}


/****************** LOOP FOR GENERATIONS ****************/
for (gen=0; gen< generations; gen ++)
{

max_fd=0;
FD_ZERO(&read_set);
for (k=0; k<poblation; k++)
{
	FD_SET(connfd[k], &read_set);
	max_fd = (connfd[k] > max_fd) ? connfd[k] : max_fd;
	connected[k]=1;
}

FD_ZERO(&write_set);
FD_ZERO(&ex_set);
max_fd += 1; 				 //number of descriptors;

syslog(LOG_INFO,"max_fd: %d",max_fd); //needed for bug

l=0;
counter=0;
while(1)
{
	if ( l < poblation )
	{
		FD_ZERO(&read_set);
		for (k=0; k<poblation; k++)
		{
			if (*(connected+k))
			{
				FD_SET(connfd[k], &read_set);
			}
		}
		if ( (ready_fd=pselect(max_fd, &read_set, &write_set, &ex_set, NULL, NULL)) <0 )
		{
			syslog(LOG_CRIT,"Error in pselect: %s",strerror(errno));
			return(1);
		}

		for (k=0; k<poblation; k++)
		{
			if (FD_ISSET(connfd[k], &read_set) )
			{
				if( (readn(connfd[k],char_buffer,BUFFSIZE)) < 0)
				{
					syslog(LOG_CRIT,"Error closed connection %d",k);
					connected[k]=0;
//				sprintf(char_buffer,"unix%d.str",k);
//				unlink(char_buffer);					
					return(1);
				}
				else
				{
					if ( !(strncmp("Error",char_buffer,5) ) )
					{
						error[k] = atof(char_buffer+6);
					}

					else if ( !(strncmp("neuron_array",char_buffer,12) ) )
					{
						readn(connfd[k],char_buffer,BUFFSIZE);
						num_neuron[k] = atoi(char_buffer+11);
						syslog(LOG_INFO,"client=%d num_neuron=%d",k,num_neuron[k]);  //required for bug
						counter += num_neuron[k];
						if ( !(net_array[k] = (struct individual *)calloc(1,sizeof(struct individual)) ))
						{
							syslog(LOG_CRIT,"Error calloc net_array[%d]: %s",k,strerror(errno));
							return(1);
						}
						if ( !(net_array[k]->neuron_array = (struct neuron **)calloc(
																										num_neuron[k],sizeof(struct neuron *)) ))
						{
							syslog(LOG_CRIT,"Error calloc net_array[%d]->neuron_array: %s",k,
											strerror(errno));
							return(1);
						}

						for (m=0; m< num_neuron[k]; m++)
						{
							if ( !(net_array[k]->neuron_array[m] = (struct neuron *)calloc(
														1,sizeof(struct neuron)) ))
							{
								syslog(LOG_CRIT,"Error calloc net_array[%d]->neuron_array[%d]: %s",k,l,
														strerror(errno));
								return(1);
							}
						}
						read_neuron_array(num_neuron[k], net_array[k]->neuron_array, connfd[k]);
					}
					
					else if (!strncmp("All work done",char_buffer,13) )
					{
//						syslog(LOG_INFO,"End of reading from client %d",k);
						l+=1;
						connected[k]=0;
					}
				}
			}
		}
	}
	else
	{
		syslog(LOG_INFO,"All work done with clients");
		break;
	}
}


/* Verification before next generation */
/***************************************/
get_fitness(poblation, base, boost, num_neuron, error, fitness);
for (k=0 ; k< poblation; k++)
{
	sprintf(char_buffer,"client_number=%d num_neuron=%d error=%f fitness=%f",
									k,num_neuron[k],error[k],fitness[k]);
	syslog(LOG_INFO,char_buffer);
	if (error[k] <= level)
	{
		exit_flag=1;
	}
} 

if (exit_flag)
{
	for (k=0; k< poblation; k++)
	{
		sprintf(char_buffer,"Exiting");
		writen(connfd[k],char_buffer,BUFFSIZE);
	}
	syslog(LOG_INFO,"Exiting generation %d level %1.6f",gen,level);
	break;
}

if (gen == generations - 1)
{
	for (k=0; k< poblation; k++)
	{
		sprintf(char_buffer,"All work done client=%d",k);
		writen(connfd[k],char_buffer,BUFFSIZE);
	}
	syslog(LOG_INFO,"Last generation");
	break;
}

/*** Updating for Local NICHE SERVER HERE ***/

if (ga_conf.num_niche > 0)
{
	FD_ZERO(&read_set);
	FD_ZERO(&write_set);
	FD_ZERO(&ex_set);
	FD_SET(connfd_niche, &write_set);
	max_fd = connfd_niche + 1;

	/*** Sending Signal to local Niche ***/

	syslog(LOG_INFO,"NICHE SERVER reload of data pid=%d",pid_temp);
	kill(pid_temp, SIGUSR1);

	if ( (ready_fd=pselect(max_fd, &read_set, &write_set, &ex_set, NULL, NULL)) <0 )
	{
		syslog(LOG_CRIT,"Error in pselect in local NICHE SERVER: %s",strerror(errno));
		return(1);
	}
	if (FD_ISSET(connfd_niche, &write_set) )
	{
		for (k=0; k< poblation; k++)
		{
			dwrite_neuron_array(num_neuron[k],net_array[k]->neuron_array,connfd_niche);
		}
	}
}


/************ Cross ****************/
/***********************************/

if ( (mate(poblation,parents,fitness))<0)
{
	syslog(LOG_CRIT,"Error in cross function");
	return(1);
}
sprintf(char_buffer,"Parents: ");
for (k=0; k<poblation; k++)
{
		sprintf(char_temp,"%d:%d ",parents[k][0],parents[k][1]);
		strcat(char_buffer,char_temp);
}
syslog(LOG_INFO,char_buffer);


parent1 = NULL;
parent2 = NULL;
for (k=0; k < poblation; k++)
{

	/*** Randomize ***/
	
	if (!toss(mut_new_prob,k) ) //1:normal 0:new neuron_array for client
	{
		/***************************************************/	
		/***** First free already asigned memory !!! *******/
		if( !(parent1 = (struct neuron **)copy_neuron_array(num_neuron[parents[k][0]],
										net_array[parents[k][0]]->neuron_array, parent1)) )
		{
			syslog(LOG_CRIT,"Error in copy to parent1 %d",k);
			return(1);
		}										
		if( !(parent2 = (struct neuron **)copy_neuron_array(num_neuron[parents[k][1]],
										net_array[parents[k][1]]->neuron_array, parent2)) )
		{
			syslog(LOG_CRIT,"Error in copy to parent2 %d",k);
			return(1);
		}

		if ( !(inner_elem1 = (int *)realloc(inner_elem1,num_neuron[parents[k][0]]*sizeof(int)) ))
		{
			syslog(LOG_CRIT,"Error in realloc inner_elem1");
			return(1);
		}
		if ( !(inner_elem2 = (int *)realloc(inner_elem2,num_neuron[parents[k][1]]*sizeof(int)) ))
		{
			syslog(LOG_CRIT,"Error in realloc inner_elem2");
			return(1);
		}

		/********* Selection of neurons ***********/	

		region_gen(vertice);
//		sprintf(char_buffer,"parent1 element=%d %f:%f %f:%f",k,vertice[0][0],
//													vertice[0][1],vertice[1][0],vertice[1][1]);
//		syslog(LOG_INFO,char_buffer);	
		if ( inner_neuron(num_neuron[parents[k][0]], parent1, vertice, inner_elem1) < 0)
		{
			syslog(LOG_CRIT,"Error in inner_neuron1: %s",strerror(errno));
			return(3);
		}
		if ( inner_neuron(num_neuron[parents[k][1]], parent2, vertice, inner_elem2) < 0)
		{
			syslog(LOG_CRIT,"Error in inner_neuron2: %s",strerror(errno));
			return(3);
		}

		near_neuron(num_neuron[parents[k][0]],parent1,inner_elem1);
		near_neuron(num_neuron[parents[k][1]],parent2,inner_elem2);

		sprintf(char_buffer,"parent1:");
		for (l=0; l<num_neuron[parents[k][0]]; l++)
		{
			sprintf(char_temp,"%d",inner_elem1[l]);
			strcat(char_buffer,char_temp);
		}
		syslog(LOG_INFO,char_buffer);
	
		sprintf(char_buffer,"parent2:");
		for (l=0; l<num_neuron[parents[k][1]]; l++)
		{
			sprintf(char_temp,"%d",inner_elem2[l]);
			strcat(char_buffer,char_temp);
		}
		syslog(LOG_INFO,char_buffer);

		if ( (n=isolate_region(num_neuron[parents[k][0]], parent1, inner_elem1)) <0)
		{
			syslog(LOG_CRIT,"Error isolate_region parent1 %d",n);
			return(1);
		}
		if ( (n=isolate_region(num_neuron[parents[k][1]], parent2, inner_elem2)) <0)
		{
			syslog(LOG_CRIT,"Error isolate_region parent2 %d",n);
			return(1);
		}

		syslog(LOG_INFO,"Size parent1[%d] before remove_neuron()=%d",k,num_neuron[parents[k][0]]);
	
		if (!(parent1 =	(struct neuron **)remove_neuron(
													num_neuron[parents[k][0]],parent1,inner_elem1, &n) ))
		{
			syslog(LOG_CRIT,"Error in remove_neuron parent1 %d",k);
			return(1);
		}
	
		new_num_neuron[k]=n;
		syslog(LOG_INFO,"Size parent1[%d] after remove_neuron()=%d",k,new_num_neuron[k]);
	
		if (!(parent1 =	(struct neuron **)append_neuron(new_num_neuron[k],
					num_neuron[parents[k][1]], parent1,parent2,inner_elem2, &n ) ))
		{
			syslog(LOG_CRIT,"Error in append_neuron parent1 %d",k);
			return(1);
		}

		new_num_neuron[k]=n;
		syslog(LOG_INFO,"Size parent1[%d] after append_neuron()=%d",k,new_num_neuron[k]);
	
	
		/************ Mutation ************/
		/**********************************/

		if (toss(mut_neuron_prob,k) )
		{
			l = dice_toss(k, max_neuron_mut);
			
			/************** Requires num_input num_output ************/
			
			l = (coin_toss(l) > 0) ? l : -l;
			syslog(LOG_INFO,"Mutation neuron_array: append/remove=%d",l);
			if ( !(parent1 = (struct neuron **)mutate_neuron_array(new_num_neuron[k], l, 
																				parent1, &n) ))
			{
				syslog(LOG_CRIT,"Error in mutate_neuron_array(): net=%d",k);
				return(1);
			}
			new_num_neuron[k]=n;
			syslog(LOG_INFO,"neuron_array mutated, new num_neuron=%d",new_num_neuron[k]);
		}
	
		for (l=0; l< new_num_neuron[k]; l++)
		{
			if (toss(mut_neuron_prob,l))
			{
				syslog(LOG_INFO,"Mutation of neuron: net=%d element=%d",k,l);
				if ( !(parent1[l] = (struct neuron *)mutate_neuron(parent1[l], &ga_conf) ))
				{
					syslog(LOG_CRIT,"Error in mutate_neuron(): net=%d element=%d",k,l);
					return(1);
				}
			}
		}
	
		dwrite_neuron_array(new_num_neuron[k], parent1, connfd[k]);

		if ( (parent1 = (struct neuron **)free_neuron_array(new_num_neuron[k],parent1) ))
		{
			syslog(LOG_CRIT,"Error in free_neuron_array parent1 %d",k);
			return(1);
		}
		if ( (parent2 = (struct neuron **)free_neuron_array(num_neuron[parents[k][1]],parent2) ))
		{
			syslog(LOG_CRIT,"Error in free_neuron_array parent2 %d",k);
			return(1);
		}
	}
	else
	{
		if ( (ga_conf.num_niche > 0) && (toss(ga_conf.inm_prob, gen)) )
		{
			l = dice_toss(ga_conf.num_niche, gen);  //NICHE select
			
			syslog(LOG_INFO,"Requesting foreign neuron_array");
			if ( (connfd_remote = socket(PF_INET, SOCK_STREAM, 0)) < 0)
			{
				syslog(LOG_CRIT,"Error creating socket: %d %s",k,strerror(errno));
				return(1);
			}
			
			bzero(&serv_in_addr_remote, sizeof(serv_in_addr_remote));
			serv_in_addr_remote.sin_family = PF_INET;

			 /***  this requires max_local > 0, so local server port is unused ***/
			serv_in_addr_remote.sin_port = htons((uint16_t)local_server_port);  
		
			syslog(LOG_INFO,"remote niche[%d]: %s",l,ga_conf.niches[l]);
		
			if (inet_pton(AF_INET,ga_conf.niches[l],&serv_in_addr_remote.sin_addr) < 1)
			{
				syslog(LOG_CRIT,"Error inet_pton() %d %s",k,strerror(errno));
				return(1);
			}
			if( (connect(connfd_remote, (struct sockaddr *) &serv_in_addr_remote, 
								sizeof(serv_in_addr_remote))) <0)
			{
				syslog(LOG_CRIT,"Couldn't connect to niche[%d] server: %d %s",l,k,strerror(errno));
				return(1);
			}

			/*** Retriving remote neuron_array from niche ***/
			readn(connfd_remote,char_buffer,BUFFSIZE);

			if ( !(strncmp("neuron_array",char_buffer,12) ) )
			{
				readn(connfd_remote,char_buffer,BUFFSIZE);
				m = atoi(char_buffer+11);  //num_neuron
				syslog(LOG_INFO,"client=%d niche=%d num_neuron=%d",k,l,m);  //required for bug

				if ( !(parent1 = (struct neuron **)calloc(m,sizeof(struct neuron *)) ))
				{
					syslog(LOG_CRIT,"Error calloc parent1 niche%d: %s",l,strerror(errno));
					return(1);
				}
				for (n=0; n< m; n++)
				{
					if ( !(parent1[n] = (struct neuron *)calloc(1,sizeof(struct neuron)) ))
					{	
						syslog(LOG_CRIT,"Error calloc parent1 niche[%d]: %s",l,strerror(errno));
						return(1);
					}
				}
				read_neuron_array(m, parent1, connfd_remote);

				/*** Now writing to client the foreign neuron_array ***/

				dwrite_neuron_array(m, parent1, connfd[k]);

				/*** Should try just bypassing values ***/

				if ( (parent1 = (struct neuron **)free_neuron_array(m,parent1) ))
				{
					syslog(LOG_CRIT,"Error in free_neuron_array parent1 %d",k);
					return(1);
				}
			}
			close(connfd_remote);
		}
		else
		{
			sprintf(char_buffer,"Randomize client %d",k);
			writen(connfd[k],char_buffer,BUFFSIZE);
			syslog(LOG_INFO,char_buffer);
		}
	}

	sprintf(char_buffer,"All work done for client=%d gen=%d",k,gen);
	writen(connfd[k],char_buffer,BUFFSIZE);
	
	syslog(LOG_INFO,"**** Passed iteraction %d generation %d ****",k,gen);
}


for (k=0; k< poblation; k++)
{
	if ( (net_array[k]->neuron_array = (struct neuron **)free_neuron_array(
										num_neuron[k],net_array[k]->neuron_array) ))
	{
		syslog(LOG_CRIT,"Error in free_neuron_array net_array[%d]->neuron_array",k);
		return(1);
	}

/// ADDED LATER
/// Take with care

	free(net_array[k]);
}

syslog(LOG_INFO,"**** Passed generation %d ****",gen);

}
/******************** END LOOP GENERATIONS ***************/

for (k=0; (k< poblation) && (k< max_local); k++)
{
	close(connfd[k]);
	sprintf(char_buffer,"unix%d.str",k);
	unlink(char_buffer);		
}
if (ga_conf.num_niche > 0)
{
	unlink("niche_fifo");
}

syslog(LOG_INFO,"********* Exiting *********");
exit(0);
}
