/*  verify_connections.c */

/* 	Copyright 2004 Oswaldo Morizaki */

/* 	This file is part of ga-nn-ag.

    ga-nn-ag is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    ga-nn-ag is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with ga-nn; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "my_header.h"
#include "aux_prot.h"

/* Verify and correct broken connections with 1% 
	tolerance in coordinates */

int verify_connections(int num_neuron, struct neuron ** neuron_array)
{
	int k,l,m,n;
	int counter;
	int find;
	float x_c,y_c;
	float con_x, con_y;
	float temp_x,temp_y;
	
	counter=0;
	for (k=num_neuron-1; k+1; k--)
	{
		for (l=0; l< neuron_array[k]->num_con; l++)
		{
			find=0;
			con_x=*(neuron_array[k]->con_x+l);
			con_y=*(neuron_array[k]->con_y+l);
			for (m=k-1; m+1 ; m--)
			{
				if ( (con_x == neuron_array[l]->x_c) && (con_y == neuron_array[l]->y_c) )
				{
					find=1;
					break;
				}
			}
			if (find == 0)
			{
				for (m=k-1; m+1 ; m--)
				{
					if ( (con_x > (neuron_array[l]->x_c - 0.01/num_neuron)) && 
										(con_x < (neuron_array[l]->x_c + 0.01/num_neuron)) && 
										(con_y > (neuron_array[l]->y_c - 0.01*neuron_array[k]->range)) &&
										(con_y < (neuron_array[l]->y_c + 0.01*neuron_array[k]->range)) )
					{
						find=1;
						*(neuron_array[k]->con_x+l) = neuron_array[l]->x_c;
						*(neuron_array[k]->con_y+l) = neuron_array[l]->y_c;
						break;
					}
				}
			}
			if (find == 0)
			{
				counter++;
			}
		}
	}
	return(counter);
}
