/*  write_ga_server_remote_config.c */

/* 	Copyright 2004 Oswaldo Morizaki */

/* 	This file is part of ga-nn-ag.

    ga-nn-ag is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    ga-nn-ag is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with ga-nn; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "my_header.h"
#include "aux_prot.h"

int write_ga_server_remote_config(struct ga_server_config *conf, int descriptor)
{
	char char_temp[BUFFSIZE];

	sprintf(char_temp,"max_local=%d\0",conf->max_local);
	writen(descriptor,char_temp,BUFFSIZE);
	sprintf(char_temp,"first_local=%d\0",conf->first_local);
	writen(descriptor,char_temp,BUFFSIZE);
	sprintf(char_temp,"last_local=%d\0",conf->last_local);
	writen(descriptor,char_temp,BUFFSIZE);
	sprintf(char_temp,"local_server_port=%d\0",conf->local_server_port);
	writen(descriptor,char_temp,BUFFSIZE);
	sprintf(char_temp,"poblation=%d\0",conf->poblation);
	writen(descriptor,char_temp,BUFFSIZE);
	sprintf(char_temp,"generations=%d\0",conf->generations);
	writen(descriptor,char_temp,BUFFSIZE);
	sprintf(char_temp,"max_neuron_mut=%d\0",conf->max_neuron_mut);
	writen(descriptor,char_temp,BUFFSIZE);
	sprintf(char_temp,"max_num_layer=%d\0",conf->max_num_layer);
	writen(descriptor,char_temp,BUFFSIZE);
	sprintf(char_temp,"max_num_neuron=%d\0",conf->max_num_neuron);
	writen(descriptor,char_temp,BUFFSIZE);
	sprintf(char_temp,"agregation=%d\0",conf->agr);
	writen(descriptor,char_temp,BUFFSIZE);
	sprintf(char_temp,"ip=%s\0",conf->ip);
	writen(descriptor,char_temp,BUFFSIZE);
	sprintf(char_temp,"EOC\0");
	writen(descriptor,char_temp,BUFFSIZE);

	return(1);
}
