/**
 *  XMMS/BMP/audacious plugin Framework
 *
 *  Copyright (C) 2006-2012 Teru KAMOGASHIRA
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


static void
#ifdef __GNUC__
__attribute__ ((constructor))
#endif
plugin_init(void)
{
  fprintf(stderr, "libxmmsplugin: plugin_init(): %s\n", configSectionString);
  pthread_mutex_init(&plugin_mutex, NULL);
}

static void
#ifdef __GNUC__
__attribute__ ((destructor))
#endif
plugin_fini(void)
{
  fprintf(stderr, "libxmmsplugin: plugin_fini(): %s\n", configSectionString);
  pthread_mutex_destroy(&plugin_mutex);
}

#if _AUD_PLUGIN_VERSION_MIN >= 18
static gboolean init(void)
#else
static void init(void)
#endif
{
#ifndef __GNUC__
  plugin_init();
#endif
  fprintf(stderr, "libxmmsplugin: init(): %s\n", configSectionString);
  pthread_mutex_lock(&plugin_mutex);
  plugin_available = true;
  if(XMMSPlugin != NULL) delete XMMSPlugin;
  XMMSPlugin = new fv3::libxmmsplugin(ppConfTable, sizeof(ppConfTable)/sizeof(PluginParameterTable),
				      about_text, productString, configSectionString);  
  XMMSPlugin->registerModSamples(mod_samples);
  pthread_mutex_unlock(&plugin_mutex);
#if _AUD_PLUGIN_VERSION_MIN >= 18
  return TRUE;
#endif
}

static void cleanup(void)
{
  fprintf(stderr, "libxmmsplugin: cleanup(): %s\n", configSectionString);
  pthread_mutex_lock(&plugin_mutex);
  plugin_available = false;
  fprintf(stderr, "NOTICE: cleanup() during play may not be supported.\n");
  delete XMMSPlugin;
  XMMSPlugin = NULL;
  pthread_mutex_unlock(&plugin_mutex);
#ifndef __GNUC__
  plugin_fini();
#endif
}

// common plugin fields

static void configure(void){if(XMMSPlugin != NULL)XMMSPlugin->configure();}
static void about(void){if(XMMSPlugin != NULL)XMMSPlugin->about();}
#if __AUDACIOUS_PLUGIN_API__ >= 13 || _AUD_PLUGIN_VERSION_MIN >= 18
static gint decoder_to_output_time(gint time){return time;}
static gint output_to_decoder_time(gint time){return time;}
static void dsp_start(gint * channels, gint * rate){if(XMMSPlugin != NULL) XMMSPlugin->start(channels, rate);}
static void dsp_process(gfloat ** data, gint * samples){if(XMMSPlugin != NULL) XMMSPlugin->process(data,samples);}
static void dsp_flush(){if(XMMSPlugin != NULL) XMMSPlugin->flush();}
static void dsp_finish(gfloat ** data, gint * samples){if(XMMSPlugin != NULL) XMMSPlugin->finish(data,samples);}
#else
static void query_format(AFormat * fmt, gint * rate, gint * nch)
{if(XMMSPlugin != NULL)XMMSPlugin->query_format(fmt,rate,nch);}
static int  mod_samples(gpointer * d, gint length, AFormat afmt, gint srate, gint nch)
{if(XMMSPlugin != NULL) return XMMSPlugin->mod_samples(d,length,afmt,srate,nch); return 0;}
#endif

#ifndef AUDACIOUS140
static EffectPlugin ep = {
  NULL, NULL, (char*)productString,
  init, cleanup, about, configure, mod_samples, query_format,
};
extern "C" EffectPlugin *get_eplugin_info(void)
{
  fprintf(stderr, "freeverb3.cpp: get_eplugin_info()\n");
  init();
  return &ep;
}

#else
static EffectPlugin epe = {
#if _AUD_PLUGIN_VERSION_MIN < 18
  NULL, /* handle */
  NULL, /* filename */
#endif
  (gchar*)productString, /* description */
  init,
  cleanup,
  about,
  configure,
#if __AUDACIOUS_PLUGIN_API__ >= 10 || _AUD_PLUGIN_VERSION_MIN >= 18
  NULL, /* settings */
#endif

#if __AUDACIOUS_PLUGIN_API__ >= 16
  NULL, /* sendmsg */
#endif

#if __AUDACIOUS_PLUGIN_API__ < 16 && _AUD_PLUGIN_VERSION_MIN < 18
  FALSE, /* enabled */
#if __AUDACIOUS_PLUGIN_API__ >= 13
  NULL, NULL, /* mod_samples, query_format */
# else
  mod_samples, query_format,
# endif
#endif

#if __AUDACIOUS_PLUGIN_API__ >= 13 || _AUD_PLUGIN_VERSION_MIN >= 18
  dsp_start,
  dsp_process,
  dsp_flush,
  dsp_finish,
  decoder_to_output_time,
  output_to_decoder_time,
#endif

#if __AUDACIOUS_PLUGIN_API__ >= 16 || _AUD_PLUGIN_VERSION_MIN >= 18
  0, /* order */
  TRUE, /* preserves_format */
#endif
};

static EffectPlugin *eplist[] = {&epe, NULL};
#if _AUD_PLUGIN_VERSION_MIN >= 18
extern "C" {
DECLARE_PLUGIN(plugin, NULL, NULL, NULL, NULL, eplist, NULL, NULL, NULL);
}
#else
SIMPLE_EFFECT_PLUGIN(plugin, eplist);
#endif
#endif
