// -*- C++ -*-
//
// Copyright (C) 1998, 1999, 2000, 2002  Los Alamos National Laboratory,
// Copyright (C) 1998, 1999, 2000, 2002  CodeSourcery, LLC
//
// This file is part of FreePOOMA.
//
// FreePOOMA is free software; you can redistribute it and/or modify it
// under the terms of the Expat license.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the Expat
// license for more details.
//
// You should have received a copy of the Expat license along with
// FreePOOMA; see the file LICENSE.
//

//-----------------------------------------------------------------------------
// Classes:
//   LifeStencil
//-----------------------------------------------------------------------------

#ifndef POOMA_EXAMPLES_LIFE_STENCIL_H
#define POOMA_EXAMPLES_LIFE_STENCIL_H

#include "Pooma/Arrays.h"

//-----------------------------------------------------------------------------
// LifeStencil implements the Game of Life
//-----------------------------------------------------------------------------

class LifeStencil
{
public:
  LifeStencil() {}

  template <class A>
  inline
  typename A::Element_t
  operator()(const A& x, int i, int j) const
  {
    int count =
      x(i-1, j+1) + x(i, j+1) + x(i+1, j+1) +
      x(i-1, j  ) +             x(i+1, j  ) +
      x(i-1, j-1) + x(i, j-1) + x(i+1, j-1) ;

    int result = 0;
    if ((count == 3) || (x(i,j) && (count == 2))){
      result = 1;
    }
    return result;
  }

  inline int lowerExtent(int) const { return 1; }
  inline int upperExtent(int) const { return 1; }  
};

#endif // POOMA_EXAMPLES_LIFE_STENCIL_H

// ACL:rcsinfo
// ----------------------------------------------------------------------
// $RCSfile: LifeStencil.h,v $
// $Revision: 1.7 $
// ----------------------------------------------------------------------
// ACL:rcsinfo
