##################################################################

# simple user-application Makefile using the version of POOMA
# installed in the 'POOMADIR' directory.
##################################################################

### include the POOMA makefile stub, to get compiler flags and libraries

include $(POOMADIR)/$(POOMAARCH)/lib/Makefile.pooma


### the name of the example code to compile

EXAMPLE = RBJacobi2


### the main target for this makefile

$(EXAMPLE): $(EXAMPLE).inst.cpp
	$(POOMA_CXX) $(POOMA_CXX_DBG_ARGS) -o $(EXAMPLE) $(EXAMPLE).inst.cpp $(POOMA_INCLUDES) $(POOMA_DEFINES) $(POOMA_LIBS)

# To build the instrumented example 
$(EXAMPLE).inst.cpp : $(EXAMPLE).pdb
	$(TAUINSTR) $(EXAMPLE).pdb $(EXAMPLE).cpp -o $(EXAMPLE).inst.cpp

# To build the .pdb file 
$(EXAMPLE).pdb : $(EXAMPLE).cpp 
	$(TAUPARSE) $(EXAMPLE).cpp $(POOMA_INCLUDES) 

### clean things up a bit

clean:
	rm -rf $(EXAMPLE) $(EXAMPLE).o $(EXAMPLE).inst.cpp $(EXAMPLE).pdb $(EXAMPLE).ii ii_files ti_files 


# ACL:rcsinfo
#  ----------------------------------------------------------------------
#  $RCSfile: Makefile.profile,v $   $Author: richard $
#  $Revision: 1.4 $   $Date: 2004/11/01 18:16:00 $
#  ----------------------------------------------------------------------
# ACL:rcsinfo
