// -*- C++ -*-
//
// Copyright (C) 1998, 1999, 2000, 2002  Los Alamos National Laboratory,
// Copyright (C) 1998, 1999, 2000, 2002  CodeSourcery, LLC
//
// This file is part of FreePOOMA.
//
// FreePOOMA is free software; you can redistribute it and/or modify it
// under the terms of the Expat license.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the Expat
// license for more details.
//
// You should have received a copy of the Expat license along with
// FreePOOMA; see the file LICENSE.
//

//-----------------------------------------------------------------------------
// Class:
// NullPreconditioner
//-----------------------------------------------------------------------------

#ifndef POOMA_NULL_PRECONDITIONER_H
#define POOMA_NULL_PRECONDITIONER_H

//////////////////////////////////////////////////////////////////////

//-----------------------------------------------------------------------------
// Overview: 
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
//
// NullPreconditioner
//
//-----------------------------------------------------------------------------

class NullPreconditioner
{
public:

  NullPreconditioner() {}

  template<class Expr>
  void operator()(const Expr& x, const Expr& y) const
  {
    y = x;
  }

};

//////////////////////////////////////////////////////////////////////

#endif     // POOMA_NULL_PRECONDITIONER_H

// ACL:rcsinfo
// ----------------------------------------------------------------------
// $RCSfile: NullPreconditioner.h,v $   $Author: richard $
// $Revision: 1.3 $   $Date: 2004/11/01 18:15:51 $
// ----------------------------------------------------------------------
// ACL:rcsinfo
