// -*- C++ -*-
//
// Copyright (C) 1998, 1999, 2000, 2002  Los Alamos National Laboratory,
// Copyright (C) 1998, 1999, 2000, 2002  CodeSourcery, LLC
//
// This file is part of FreePOOMA.
//
// FreePOOMA is free software; you can redistribute it and/or modify it
// under the terms of the Expat license.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the Expat
// license for more details.
//
// You should have received a copy of the Expat license along with
// FreePOOMA; see the file LICENSE.
//

//-----------------------------------------------------------------------------
// Class:
// FivePointIC1Stencil
// Stencil for the IC(1) preconditioner given the FivePoint matrix stencil
//-----------------------------------------------------------------------------

#ifndef POOMA_FIVEPOINTIC1STENCIL_H
#define POOMA_FIVEPOINTIC1STENCIL_H

#include <iostream>

class FivePointIC1Stencil {

public : 

   FivePointIC1Stencil () { }

   FivePointIC1Stencil (double s, double se, double w, double c)
      { south_m = s;
      southeast_m = se;
      west_m = w;
      center_m = c; }

   FivePointIC1Stencil &operator= (const FivePointIC1Stencil &in) {
      south_m = in.south_m;
      southeast_m = in.southeast_m;
      west_m = in.west_m;
      center_m = in.center_m;
      return * this; }

  FivePointIC1Stencil kludge ()
  {
    return FivePointIC1Stencil (south_m, southeast_m, west_m,
       1.0 / center_m);
  }

   inline double &south() { return south_m; }
   inline double &southeast() { return southeast_m; }
   inline double &west() { return west_m; }
   inline double &center() { return center_m; }

   inline const double &south() const { return south_m; }
   inline const double &southeast() const { return southeast_m; }
   inline const double &west() const { return west_m; }
   inline const double &center() const { return center_m; }

   void print() {
      std::cout << "("; 
      std::cout << south_m << ", "; 
      std::cout << southeast_m << ", "; 
      std::cout << west_m << ", "; 
      std::cout << center_m << ")" << std::endl; 
      return; }

   ~FivePointIC1Stencil () { }

private:
   double south_m;
   double southeast_m;
   double west_m;
   double center_m;

}; // end class FivePointIC1Stencil

std::ostream& operator<< (std::ostream& s, const FivePointIC1Stencil& c)
{
   return s << "( " << c.south() << ", " << c.southeast() << ", " <<
      c.west() << ", " << c.center() << ")" ; }

#endif // POOMA_FIVEPOINTIC1STENCIL_H
