##################################################################

# simple user-application Makefile using the version of POOMA
# installed in the 'POOMADIR' directory.
##################################################################

### include the POOMA makefile stub, to get compiler flags and libraries

include $(POOMADIR)/$(POOMAARCH)/lib/Makefile.pooma


### the name of the example code to compile

EXAMPLE1 = Sender
EXAMPLE2 = Receiver


### the main target for this makefile

$(EXAMPLE1): $(EXAMPLE1).inst.cpp
	$(POOMA_CXX) $(POOMA_CXX_DBG_ARGS) -o $(EXAMPLE1) $(EXAMPLE1).inst.cpp $(POOMA_INCLUDES) $(POOMA_DEFINES) $(POOMA_LIBS)

# To build the instrumented example 
$(EXAMPLE1).inst.cpp : $(EXAMPLE1).pdb
	$(TAUINSTR) $(EXAMPLE1).pdb $(EXAMPLE1).cpp -o $(EXAMPLE1).inst.cpp

# To build the .pdb file 
$(EXAMPLE1).pdb : $(EXAMPLE1).cpp 
	$(TAUPARSE) $(EXAMPLE1).cpp $(POOMA_INCLUDES) 

$(EXAMPLE2): $(EXAMPLE2).inst.cpp
	$(POOMA_CXX) $(POOMA_CXX_DBG_ARGS) -o $(EXAMPLE2) $(EXAMPLE2).inst.cpp $(POOMA_INCLUDES) $(POOMA_DEFINES) $(POOMA_LIBS)

# To build the instrumented example 
$(EXAMPLE2).inst.cpp : $(EXAMPLE2).pdb
	$(TAUINSTR) $(EXAMPLE2).pdb $(EXAMPLE2).cpp -o $(EXAMPLE2).inst.cpp

# To build the .pdb file 
$(EXAMPLE2).pdb : $(EXAMPLE2).cpp 
	$(TAUPARSE) $(EXAMPLE2).cpp $(POOMA_INCLUDES) 

### clean things up a bit

clean:
	rm -rf $(EXAMPLE1) $(EXAMPLE1).o $(EXAMPLE1).inst.cpp $(EXAMPLE1).pdb $(EXAMPLE1).ii $(EXAMPLE2) $(EXAMPLE2).o $(EXAMPLE2).inst.cpp $(EXAMPLE2).pdb $(EXAMPLE2).ii ii_files ti_files 


# ACL:rcsinfo
#  ----------------------------------------------------------------------
#  $RCSfile: Makefile.profile,v $   $Author: richard $
#  $Revision: 1.3 $   $Date: 2004/11/01 18:15:44 $
#  ----------------------------------------------------------------------
# ACL:rcsinfo
