// -*- C++ -*-
//
// Copyright (C) 1998, 1999, 2000, 2002  Los Alamos National Laboratory,
// Copyright (C) 1998, 1999, 2000, 2002  CodeSourcery, LLC
//
// This file is part of FreePOOMA.
//
// FreePOOMA is free software; you can redistribute it and/or modify it
// under the terms of the Expat license.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the Expat
// license for more details.
//
// You should have received a copy of the Expat license along with
// FreePOOMA; see the file LICENSE.
//

//-----------------------------------------------------------------------------
// Classes:
//   GKPoissonStencil
//-----------------------------------------------------------------------------

#ifndef POOMA_EXAMPLES_GKPOISSON_GKPOISSONSTENCIL_H
#define POOMA_EXAMPLES_GKPOISSON_GKPOISSONSTENCIL_H

// include files

#include "Pooma/Arrays.h"

//-----------------------------------------------------------------------------
// Stencil GKPoissonStencil
//-----------------------------------------------------------------------------

class GKPoissonStencil
{
public:

  GKPoissonStencil(double gamma0) 
    : gamma0_m(gamma0), ijfact_m(0.25-gamma0)
  { }

  template <class A>
  inline
  typename A::Element_t
  operator()(const A& x, int i, int j) const
  {
    return ( ijfact_m * x(i,j) +

             0.125  * ( x(i+1,j+1) + x(i+1,j-1) + 
			x(i-1,j+1) + x(i-1,j-1) ) +

	     0.0625 * ( x(i  ,j+2) + x(i  ,j-2) +
			x(i+2,j  ) + x(i-2,j  ) ) );
  }

  inline int lowerExtent(int) const { return 2; }
  inline int upperExtent(int) const { return 2; }  

private:

  double gamma0_m, ijfact_m;
};

#endif // POOMA_EXAMPLES_GKPOISSON_GKPOISSONSTENCIL_H

// ACL:rcsinfo
// ----------------------------------------------------------------------
// $RCSfile: GKPoissonStencil.h,v $   $Author: richard $
// $Revision: 1.12 $   $Date: 2004/11/01 18:15:33 $
// ----------------------------------------------------------------------
// ACL:rcsinfo
