// -*- C++ -*-
//
// Copyright (C) 1998, 1999, 2000, 2002  Los Alamos National Laboratory,
// Copyright (C) 1998, 1999, 2000, 2002  CodeSourcery, LLC
//
// This file is part of FreePOOMA.
//
// FreePOOMA is free software; you can redistribute it and/or modify it
// under the terms of the Expat license.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the Expat
// license for more details.
//
// You should have received a copy of the Expat license along with
// FreePOOMA; see the file LICENSE.
//

//-----------------------------------------------------------------------------
// Classes:
//   DoofNinePt
//-----------------------------------------------------------------------------

#ifndef POOMA_EXAMPLES_DOOF2D_STENCIL9_H
#define POOMA_EXAMPLES_DOOF2D_STENCIL9_H

// include files

#include "Pooma/Arrays.h"

//-----------------------------------------------------------------------------
// Stencil DoofNinePt
//-----------------------------------------------------------------------------

class DoofNinePt
{
public:
  DoofNinePt() {}

  template <class A>
  inline
  typename A::Element_t
  operator()(const A& x, int i, int j) const
  {
    return ( fact_s *
             ( x(i+1,j+1) + x(i+1,j  ) + x(i+1,j-1) +
               x(i  ,j+1) + x(i  ,j  ) + x(i  ,j-1) +
               x(i-1,j+1) + x(i-1,j  ) + x(i-1,j-1) ) );
  }

  inline int lowerExtent(int) const { return 1; }
  inline int upperExtent(int) const { return 1; }  

private:
  static const double fact_s;
};

const double DoofNinePt::fact_s = 1.0/9.0;

#endif // POOMA_EXAMPLES_DOOF2D_STENCIL9_H

// ACL:rcsinfo
// ----------------------------------------------------------------------
// $RCSfile: stencil9.h,v $   $Author: richard $
// $Revision: 1.12 $   $Date: 2004/11/01 18:15:25 $
// ----------------------------------------------------------------------
// ACL:rcsinfo
