#!/usr/bin/env perl 
#   Copyright (C) 1998, 1999, 2000, 2002  Los Alamos National Laboratory,
#   Copyright (C) 1998, 1999, 2000, 2002  CodeSourcery, LLC
#
#   This file is part of FreePOOMA.
#
#   FreePOOMA is free software; you can redistribute it and/or modify it
#   under the terms of the Expat license.
#
#   This program is distributed in the hope that it will be useful, but
#   WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the Expat
#   license for more details.
#
#   You should have received a copy of the Expat license along with
#   FreePOOMA; see the file LICENSE.

# Script to display compile times and object and executable file sizes.
# laa, 1997

$DEBUG = 0;

$VERSION  = "19-November-1997";
$VERSION  = "05-January-1998";
$VERSION  = "12-February-1998";
$top      = $ARGV[0];

print sprintf "%10s  %7s  %7s  %7s  %7s  %20s  %10s  %s\n", "Bytes", "wall", "real", "user", "sys", "SUITE", "PASS", "Filename";

# It shouldn't be necessary to chdir, but if $top is a symbolic link
# find seems to work better.
chdir $top;
$command = qq(find . -name "*.info");
@filelist = `$command`;

foreach $infofile (@filelist) {
	# .o objectfiles
	if    ($infofile =~ /(\S+\.o)_(\S+)\.info/)   { 
		$objectfile     = $1;
		$pass           = $2;
		$size           = filesize ($objectfile);

	}
	# executables
	elsif    ($infofile =~ /(\S+)_(\S+)\.info/)   { 
		$objectfile     = $1;
		$pass           = $2;
	$objectcopy     = "$1_$2";
		$size           = filesize ($objectcopy);
	}
	($wall, $real, $user, $sys) = &elapsedtime ($infofile);
	($suite,$ofile) = $objectfile =~ /^.*\/(\S+)\/(\S*$)/;
	$objectfile     =~ s/$top\///;
	print sprintf "%10d  %7s  %7s  %7s  %7s  %20s  %10s  %s\n", $size, $wall, $real, $user, $sys, $suite, $pass, $ofile;
#exit if ($DEBUG);
}

################################################################################
sub filesize {
	my ($filename) = @_;
	my ($dev,$ino,$mode,$nlink,$uid,$gid,$rdev,$size,$atime,$mtime,$ctime,$blksize,$blocks) = stat $filename;
	$size;
}

################################################################################
sub elapsedtime {
	my ($infofile) = @_;
	my  ($wall, $real, $user, $sys) = ("?", "?", "?", "?");

	open (F, "<$infofile") or die "Can't open $infofile for reading";
	$t1 = <F>;
	while ( <F> ) {
		$t2 = $_;
		if ($_ =~ /^real +(\d*:*\d*\.\d+)$/) { $real = $1 };
		if ($_ =~ /^user +(\d*:*\d*\.\d+)$/) { $user = $1 };
		if ($_ =~ /^sys +(\d*:*\d*\.\d+)$/) { $sys = $1 };
	}
	close (F);

	$t1 =~ s/:0/: /g;
	$t2 =~ s/:0/: /g;
	($dow1,$mon1,$day1,$hour1,$min1,$sec1,$tz1,$year1) = split(/[ :]+/, $t1);
	($dow2,$mon2,$day2,$hour2,$min2,$sec2,$tz2,$year2) = split(/[ :]+/, $t2);
	$seconds1 = ($hour1 * 3600) + ($min1 * 60) + $sec1;
	$seconds2 = ($hour2 * 3600) + ($min2 * 60) + $sec2;
	$wall  =  $seconds2 - $seconds1;
	$wall  = "?" unless ($t1 =~ /^[A-z]{1,3} +[A-z]{1,3} +[ \d]{1,2} +[ \d]{1,2}:[ \d]{1,2}:[ \d]{1,2}/);
	$wall  = "?" unless ($t2 =~ /^[A-z]{1,3} +[A-z]{1,3} +[ \d]{1,2} +[ \d]{1,2}:[ \d]{1,2}:[ \d]{1,2}/);
	my @array = ($wall, $real, $user, $sys);
}

# ACL:rcsinfo
#  ----------------------------------------------------------------------
#  $RCSfile: showtimes.pl,v $   $Author: richard $
#  $Revision: 1.9 $   $Date: 2004/11/01 18:15:22 $
#  ----------------------------------------------------------------------
# ACL:rcsinfo
