#!/usr/bin/env perl 
#   Copyright (C) 1998, 1999, 2000, 2002  Los Alamos National Laboratory,
#   Copyright (C) 1998, 1999, 2000, 2002  CodeSourcery, LLC
#
#   This file is part of FreePOOMA.
#
#   FreePOOMA is free software; you can redistribute it and/or modify it
#   under the terms of the Expat license.
#
#   This program is distributed in the hope that it will be useful, but
#   WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the Expat
#   license for more details.
#
#   You should have received a copy of the Expat license along with
#   FreePOOMA; see the file LICENSE.
#
# laa, 10-March-1998
#
# Create make-related resources for an existing project.
###############################################################################

$PROGRAM     = $0; $PROGRAM =~ s/.*\/(.*)$/$1/;
$DATE        = `date`; chomp $DATE;

$mode = shift @ARGV;
if    ($mode =~ /^newuser$/i) { # Create user preferences file
	($ufile, $user_pref_name) = @ARGV;
	&write_user_prefs_file ($ufile, $user_pref_name);
}
elsif ($mode =~ /^newproject$/i) { # Create new project???
	print "mode=$mode not yet implemented.";
	exit;
}
else {
	print "Unrecognized mode for $PROGRAM. Exiting.\n";
	exit;
}

###############################################################################
sub write_user_prefs_file {
($ufile, $user_pref_name) = @_;

if (-e $ufile) {
  print "Your user prefs file '$ufile' already exists. Exiting.\n";
  exit;
}

open (MK, ">$ufile") || die "Couldn't open $ufile for writing\n";
print MK <<EOF;
# Generated by $PROGRAM, $DATE
# Use this file to set or override make variables set in other 
# parts of the make system. Inclusion of this file in keyed on
# the environment variable USER_PREF_NAME.
#
# PLEASE DON'T override make variables set in the SUITE files. 

# COPY stderr & stdout INFO_FILE
#SUITE_REDIRECT      = 2>&1 | tee -a \$(INFO_FILE)

# REDIRECT stderr & stdout INFO_FILE (this is the default in the include.tail.mk file)
#SUITE_REDIRECT      = >> \$(INFO_FILE) 2>&1

# Allow stderr & stdout to come only to the screen
#SUITE_REDIRECT      = 

# Set options for xterm, for use with "WATCH=x"
#WATCH_OPTS          = -geom 155x50 -sb -sl 1000
 
ifndef LD_PARALLEL
LD_PARALLEL := 8
endif

default::

# Sample rule
hello:
	\@echo Hello \$(USER_PREF_NAME)
EOF
close MK;
}

# ACL:rcsinfo
#  ----------------------------------------------------------------------
#  $RCSfile: new.pl,v $   $Author: richard $
#  $Revision: 1.9 $   $Date: 2004/11/01 18:15:22 $
#  ----------------------------------------------------------------------
# ACL:rcsinfo
